/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;

public class TooltipDisplayComponentFix
extends DataFix {
    private static final List<String> CONVERTED_ADDITIONAL_TOOLTIP_TYPES = List.of("minecraft:banner_patterns", "minecraft:bees", "minecraft:block_entity_data", "minecraft:block_state", "minecraft:bundle_contents", "minecraft:charged_projectiles", "minecraft:container", "minecraft:container_loot", "minecraft:firework_explosion", "minecraft:fireworks", "minecraft:instrument", "minecraft:map_id", "minecraft:painting/variant", "minecraft:pot_decorations", "minecraft:potion_contents", "minecraft:tropical_fish/pattern", "minecraft:written_book_content");

    public TooltipDisplayComponentFix(Schema p_399807_) {
        super(p_399807_, true);
    }

    protected TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.DATA_COMPONENTS);
        Type $$1 = this.getOutputSchema().getType(References.DATA_COMPONENTS);
        OpticFinder $$2 = $$0.findField("minecraft:can_place_on");
        OpticFinder $$3 = $$0.findField("minecraft:can_break");
        Type $$4 = $$1.findFieldType("minecraft:can_place_on");
        Type $$5 = $$1.findFieldType("minecraft:can_break");
        return this.fixTypeEverywhereTyped("TooltipDisplayComponentFix", $$0, $$1, p_399664_ -> TooltipDisplayComponentFix.fix(p_399664_, $$2, $$3, $$4, $$5));
    }

    private static Typed<?> fix(Typed<?> p_399559_, OpticFinder<?> p_399761_, OpticFinder<?> p_400308_, Type<?> p_399624_, Type<?> p_399684_) {
        HashSet<String> $$5 = new HashSet<String>();
        p_399559_ = TooltipDisplayComponentFix.fixAdventureModePredicate(p_399559_, p_399761_, p_399624_, "minecraft:can_place_on", $$5);
        p_399559_ = TooltipDisplayComponentFix.fixAdventureModePredicate(p_399559_, p_400308_, p_399684_, "minecraft:can_break", $$5);
        return p_399559_.update(DSL.remainderFinder(), p_399965_ -> {
            p_399965_ = TooltipDisplayComponentFix.fixSimpleComponent(p_399965_, "minecraft:trim", $$5);
            p_399965_ = TooltipDisplayComponentFix.fixSimpleComponent(p_399965_, "minecraft:unbreakable", $$5);
            p_399965_ = TooltipDisplayComponentFix.fixComponentAndUnwrap(p_399965_, "minecraft:dyed_color", "rgb", $$5);
            p_399965_ = TooltipDisplayComponentFix.fixComponentAndUnwrap(p_399965_, "minecraft:attribute_modifiers", "modifiers", $$5);
            p_399965_ = TooltipDisplayComponentFix.fixComponentAndUnwrap(p_399965_, "minecraft:enchantments", "levels", $$5);
            p_399965_ = TooltipDisplayComponentFix.fixComponentAndUnwrap(p_399965_, "minecraft:stored_enchantments", "levels", $$5);
            boolean $$2 = p_399965_.get("minecraft:hide_tooltip").result().isPresent();
            p_399965_ = p_399965_.remove("minecraft:hide_tooltip");
            boolean $$3 = p_399965_.get("minecraft:hide_additional_tooltip").result().isPresent();
            p_399965_ = p_399965_.remove("minecraft:hide_additional_tooltip");
            if ($$3) {
                for (String $$4 : CONVERTED_ADDITIONAL_TOOLTIP_TYPES) {
                    if (!p_399965_.get($$4).result().isPresent()) continue;
                    $$5.add($$4);
                }
            }
            if ($$5.isEmpty() && !$$2) {
                return p_399965_;
            }
            return p_399965_.set("minecraft:tooltip_display", p_399965_.createMap(Map.of(p_399965_.createString("hide_tooltip"), p_399965_.createBoolean($$2), p_399965_.createString("hidden_components"), p_399965_.createList($$5.stream().map(arg_0 -> ((Dynamic)p_399965_).createString(arg_0))))));
        });
    }

    private static Dynamic<?> fixSimpleComponent(Dynamic<?> p_400153_, String p_399904_, Set<String> p_399838_) {
        return TooltipDisplayComponentFix.fixRemainderComponent(p_400153_, p_399904_, p_399838_, UnaryOperator.identity());
    }

    private static Dynamic<?> fixComponentAndUnwrap(Dynamic<?> p_399467_, String p_399917_, String p_400243_, Set<String> p_400006_) {
        return TooltipDisplayComponentFix.fixRemainderComponent(p_399467_, p_399917_, p_400006_, p_400276_ -> (Dynamic)DataFixUtils.orElse((Optional)p_400276_.get(p_400243_).result(), (Object)p_400276_));
    }

    private static Dynamic<?> fixRemainderComponent(Dynamic<?> p_400119_, String p_400142_, Set<String> p_399576_, UnaryOperator<Dynamic<?>> p_399468_) {
        return p_400119_.update(p_400142_, p_399611_ -> {
            boolean $$4 = p_399611_.get("show_in_tooltip").asBoolean(true);
            if (!$$4) {
                p_399576_.add(p_400142_);
            }
            return (Dynamic)p_399468_.apply(p_399611_.remove("show_in_tooltip"));
        });
    }

    private static Typed<?> fixAdventureModePredicate(Typed<?> p_399798_, OpticFinder<?> p_399899_, Type<?> p_399691_, String p_400139_, Set<String> p_400013_) {
        return p_399798_.updateTyped(p_399899_, p_399691_, p_399580_ -> Util.writeAndReadTypedOrThrow(p_399580_, p_399691_, p_399655_ -> {
            OptionalDynamic $$3 = p_399655_.get("predicates");
            if ($$3.result().isEmpty()) {
                return p_399655_;
            }
            boolean $$4 = p_399655_.get("show_in_tooltip").asBoolean(true);
            if (!$$4) {
                p_400013_.add(p_400139_);
            }
            return (Dynamic)$$3.result().get();
        }));
    }
}

