/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.jtracy.Plot;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.slf4j.Logger;

public class TracyZoneFiller
implements ProfilerFiller {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 5);
    private final List<Zone> activeZones = new ArrayList<Zone>();
    private final Map<String, PlotAndValue> plots = new HashMap<String, PlotAndValue>();
    private final String name = Thread.currentThread().getName();

    @Override
    public void startTick() {
    }

    @Override
    public void endTick() {
        for (PlotAndValue $$0 : this.plots.values()) {
            $$0.set(0);
        }
    }

    @Override
    public void push(String p_373085_) {
        Optional $$4;
        String $$1 = "";
        String $$2 = "";
        int $$3 = 0;
        if (SharedConstants.IS_RUNNING_IN_IDE && ($$4 = STACK_WALKER.walk(p_372968_ -> p_372968_.filter(p_372812_ -> p_372812_.getDeclaringClass() != TracyZoneFiller.class && p_372812_.getDeclaringClass() != ProfilerFiller.CombinedProfileFiller.class).findFirst())).isPresent()) {
            StackWalker.StackFrame $$5 = (StackWalker.StackFrame)$$4.get();
            $$1 = $$5.getMethodName();
            $$2 = $$5.getFileName();
            $$3 = $$5.getLineNumber();
        }
        Zone $$6 = TracyClient.beginZone((String)p_373085_, (String)$$1, (String)$$2, (int)$$3);
        this.activeZones.add($$6);
    }

    @Override
    public void push(Supplier<String> p_372939_) {
        this.push(p_372939_.get());
    }

    @Override
    public void pop() {
        if (this.activeZones.isEmpty()) {
            LOGGER.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        Zone $$0 = this.activeZones.removeLast();
        $$0.close();
    }

    @Override
    public void popPush(String p_373009_) {
        this.pop();
        this.push(p_373009_);
    }

    @Override
    public void popPush(Supplier<String> p_373088_) {
        this.pop();
        this.push(p_373088_.get());
    }

    @Override
    public void markForCharting(MetricCategory p_373090_) {
    }

    @Override
    public void incrementCounter(String p_372894_, int p_372810_) {
        this.plots.computeIfAbsent(p_372894_, p_372885_ -> new PlotAndValue(this.name + " " + p_372894_)).add(p_372810_);
    }

    @Override
    public void incrementCounter(Supplier<String> p_372847_, int p_372796_) {
        this.incrementCounter(p_372847_.get(), p_372796_);
    }

    private Zone activeZone() {
        return this.activeZones.getLast();
    }

    @Override
    public void addZoneText(String p_372877_) {
        this.activeZone().addText(p_372877_);
    }

    @Override
    public void addZoneValue(long p_373111_) {
        this.activeZone().addValue(p_373111_);
    }

    @Override
    public void setZoneColor(int p_373019_) {
        this.activeZone().setColor(p_373019_);
    }

    static final class PlotAndValue {
        private final Plot plot;
        private int value;

        PlotAndValue(String p_373109_) {
            this.plot = TracyClient.createPlot((String)p_373109_);
            this.value = 0;
        }

        void set(int p_373126_) {
            this.value = p_373126_;
            this.plot.setValue((double)p_373126_);
        }

        void add(int p_372929_) {
            this.set(this.value + p_372929_);
        }
    }
}

