/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;

public enum ConversionType {
    SINGLE(true){

        @Override
        void convert(Mob p_371283_, Mob p_371774_, ConversionParams p_371350_) {
            Entity $$5;
            Entity $$3 = p_371283_.getFirstPassenger();
            p_371774_.copyPosition(p_371283_);
            p_371774_.setDeltaMovement(p_371283_.getDeltaMovement());
            if ($$3 != null) {
                $$3.stopRiding();
                $$3.boardingCooldown = 0;
                for (Entity entity : p_371774_.getPassengers()) {
                    entity.stopRiding();
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                $$3.startRiding(p_371774_);
            }
            if (($$5 = p_371283_.getVehicle()) != null) {
                p_371283_.stopRiding();
                p_371774_.startRiding($$5);
            }
            if (p_371350_.keepEquipment()) {
                for (EquipmentSlot $$6 : EquipmentSlot.VALUES) {
                    ItemStack $$7 = p_371283_.getItemBySlot($$6);
                    if ($$7.isEmpty()) continue;
                    p_371774_.setItemSlot($$6, $$7.copyAndClear());
                    p_371774_.setDropChance($$6, p_371283_.getDropChances().byEquipment($$6));
                }
            }
            p_371774_.fallDistance = p_371283_.fallDistance;
            p_371774_.setSharedFlag(7, p_371283_.isFallFlying());
            p_371774_.lastHurtByPlayerMemoryTime = p_371283_.lastHurtByPlayerMemoryTime;
            p_371774_.hurtTime = p_371283_.hurtTime;
            p_371774_.yBodyRot = p_371283_.yBodyRot;
            p_371774_.setOnGround(p_371283_.onGround());
            p_371283_.getSleepingPos().ifPresent(p_371774_::setSleepingPos);
            Entity entity = p_371283_.getLeashHolder();
            if (entity != null) {
                p_371774_.setLeashedTo(entity, true);
            }
            this.convertCommon(p_371283_, p_371774_, p_371350_);
        }
    }
    ,
    SPLIT_ON_DEATH(false){

        @Override
        void convert(Mob p_371507_, Mob p_371702_, ConversionParams p_371413_) {
            Entity $$4;
            Entity $$3 = p_371507_.getFirstPassenger();
            if ($$3 != null) {
                $$3.stopRiding();
            }
            if (($$4 = p_371507_.getLeashHolder()) != null) {
                p_371507_.dropLeash();
            }
            this.convertCommon(p_371507_, p_371702_, p_371413_);
        }
    };

    private final boolean discardAfterConversion;

    ConversionType(boolean p_371905_) {
        this.discardAfterConversion = p_371905_;
    }

    public boolean shouldDiscardAfterConversion() {
        return this.discardAfterConversion;
    }

    abstract void convert(Mob var1, Mob var2, ConversionParams var3);

    void convertCommon(Mob p_371651_, Mob p_371777_, ConversionParams p_371814_) {
        Zombie $$9;
        p_371777_.setAbsorptionAmount(p_371651_.getAbsorptionAmount());
        for (MobEffectInstance $$3 : p_371651_.getActiveEffects()) {
            p_371777_.addEffect(new MobEffectInstance($$3));
        }
        if (p_371651_.isBaby()) {
            p_371777_.setBaby(true);
        }
        if (p_371651_ instanceof AgeableMob) {
            AgeableMob $$4 = (AgeableMob)p_371651_;
            if (p_371777_ instanceof AgeableMob) {
                AgeableMob $$5 = (AgeableMob)p_371777_;
                $$5.setAge($$4.getAge());
                $$5.forcedAge = $$4.forcedAge;
                $$5.forcedAgeTimer = $$4.forcedAgeTimer;
            }
        }
        Brain<UUID> $$6 = p_371651_.getBrain();
        Brain<?> $$7 = p_371777_.getBrain();
        if ($$6.checkMemory(MemoryModuleType.ANGRY_AT, MemoryStatus.REGISTERED) && $$6.hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
            $$7.setMemory(MemoryModuleType.ANGRY_AT, $$6.getMemory(MemoryModuleType.ANGRY_AT));
        }
        if (p_371814_.preserveCanPickUpLoot()) {
            p_371777_.setCanPickUpLoot(p_371651_.canPickUpLoot());
        }
        p_371777_.setLeftHanded(p_371651_.isLeftHanded());
        p_371777_.setNoAi(p_371651_.isNoAi());
        if (p_371651_.isPersistenceRequired()) {
            p_371777_.setPersistenceRequired();
        }
        if (p_371651_.hasCustomName()) {
            p_371777_.setCustomName(p_371651_.getCustomName());
            p_371777_.setCustomNameVisible(p_371651_.isCustomNameVisible());
        }
        p_371777_.setSharedFlagOnFire(p_371651_.isOnFire());
        p_371777_.setInvulnerable(p_371651_.isInvulnerable());
        p_371777_.setNoGravity(p_371651_.isNoGravity());
        p_371777_.setPortalCooldown(p_371651_.getPortalCooldown());
        p_371777_.setSilent(p_371651_.isSilent());
        p_371651_.getTags().forEach(p_371777_::addTag);
        if (p_371814_.team() != null) {
            Scoreboard $$8 = p_371777_.level().getScoreboard();
            $$8.addPlayerToTeam(p_371777_.getStringUUID(), p_371814_.team());
            if (p_371651_.getTeam() != null && p_371651_.getTeam() == p_371814_.team()) {
                $$8.removePlayerFromTeam(p_371651_.getStringUUID(), p_371651_.getTeam());
            }
        }
        if (p_371651_ instanceof Zombie && ($$9 = (Zombie)p_371651_).canBreakDoors() && p_371777_ instanceof Zombie) {
            Zombie $$10 = (Zombie)p_371777_;
            $$10.setCanBreakDoors(true);
        }
    }
}

