/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public final class EntitySelector {
    public static final Predicate<Entity> ENTITY_STILL_ALIVE = Entity::isAlive;
    public static final Predicate<Entity> LIVING_ENTITY_STILL_ALIVE = p_20442_ -> p_20442_.isAlive() && p_20442_ instanceof LivingEntity;
    public static final Predicate<Entity> ENTITY_NOT_BEING_RIDDEN = p_20440_ -> p_20440_.isAlive() && !p_20440_.isVehicle() && !p_20440_.isPassenger();
    public static final Predicate<Entity> CONTAINER_ENTITY_SELECTOR = p_20438_ -> p_20438_ instanceof Container && p_20438_.isAlive();
    public static final Predicate<Entity> NO_CREATIVE_OR_SPECTATOR = p_392971_ -> {
        if (!(p_392971_ instanceof Player)) return true;
        Player $$1 = (Player)p_392971_;
        if (p_392971_.isSpectator()) return false;
        if ($$1.isCreative()) return false;
        return true;
    };
    public static final Predicate<Entity> NO_SPECTATORS = p_20434_ -> !p_20434_.isSpectator();
    public static final Predicate<Entity> CAN_BE_COLLIDED_WITH = NO_SPECTATORS.and(Entity::canBeCollidedWith);
    public static final Predicate<Entity> CAN_BE_PICKED = NO_SPECTATORS.and(Entity::isPickable);

    private EntitySelector() {
    }

    public static Predicate<Entity> withinDistance(double p_20411_, double p_20412_, double p_20413_, double p_20414_) {
        double $$4 = p_20414_ * p_20414_;
        return p_20420_ -> p_20420_ != null && p_20420_.distanceToSqr(p_20411_, p_20412_, p_20413_) <= $$4;
    }

    public static Predicate<Entity> pushableBy(Entity p_20422_) {
        Team.CollisionRule $$2;
        PlayerTeam $$1 = p_20422_.getTeam();
        Team.CollisionRule collisionRule = $$2 = $$1 == null ? Team.CollisionRule.ALWAYS : ((Team)$$1).getCollisionRule();
        if ($$2 == Team.CollisionRule.NEVER) {
            return Predicates.alwaysFalse();
        }
        return NO_SPECTATORS.and(p_392970_ -> {
            boolean $$7;
            Team.CollisionRule $$6;
            Player $$4;
            if (!p_392970_.isPushable()) {
                return false;
            }
            if (!(!p_392967_.level().isClientSide || p_392970_ instanceof Player && ($$4 = (Player)p_392970_).isLocalPlayer())) {
                return false;
            }
            PlayerTeam $$5 = p_392970_.getTeam();
            Team.CollisionRule collisionRule = $$6 = $$5 == null ? Team.CollisionRule.ALWAYS : ((Team)$$5).getCollisionRule();
            if ($$6 == Team.CollisionRule.NEVER) {
                return false;
            }
            boolean bl = $$7 = $$1 != null && $$1.isAlliedTo($$5);
            if (($$2 == Team.CollisionRule.PUSH_OWN_TEAM || $$6 == Team.CollisionRule.PUSH_OWN_TEAM) && $$7) {
                return false;
            }
            return $$2 != Team.CollisionRule.PUSH_OTHER_TEAMS && $$6 != Team.CollisionRule.PUSH_OTHER_TEAMS || $$7;
        });
    }

    public static Predicate<Entity> notRiding(Entity p_20432_) {
        return p_20425_ -> {
            while (p_20425_.isPassenger()) {
                if ((p_20425_ = p_20425_.getVehicle()) != p_20432_) continue;
                return false;
            }
            return true;
        };
    }
}

