/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectType;

public interface InsideBlockEffectApplier {
    public static final InsideBlockEffectApplier NOOP = new InsideBlockEffectApplier(){

        @Override
        public void apply(InsideBlockEffectType p_404665_) {
        }

        @Override
        public void runBefore(InsideBlockEffectType p_404953_, Consumer<Entity> p_405551_) {
        }

        @Override
        public void runAfter(InsideBlockEffectType p_405305_, Consumer<Entity> p_405792_) {
        }
    };

    public void apply(InsideBlockEffectType var1);

    public void runBefore(InsideBlockEffectType var1, Consumer<Entity> var2);

    public void runAfter(InsideBlockEffectType var1, Consumer<Entity> var2);

    public static class StepBasedCollector
    implements InsideBlockEffectApplier {
        private static final InsideBlockEffectType[] APPLY_ORDER = InsideBlockEffectType.values();
        private static final int NO_STEP = -1;
        private final Set<InsideBlockEffectType> effectsInStep = EnumSet.noneOf(InsideBlockEffectType.class);
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> beforeEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, p_404793_ -> new ArrayList());
        private final Map<InsideBlockEffectType, List<Consumer<Entity>>> afterEffectsInStep = Util.makeEnumMap(InsideBlockEffectType.class, p_405667_ -> new ArrayList());
        private final List<Consumer<Entity>> finalEffects = new ArrayList<Consumer<Entity>>();
        private int lastStep = -1;

        public void advanceStep(int p_404672_) {
            if (this.lastStep != p_404672_) {
                this.lastStep = p_404672_;
                this.flushStep();
            }
        }

        public void applyAndClear(Entity p_405071_) {
            this.flushStep();
            for (Consumer<Entity> $$1 : this.finalEffects) {
                if (!p_405071_.isAlive()) break;
                $$1.accept(p_405071_);
            }
            this.finalEffects.clear();
            this.lastStep = -1;
        }

        private void flushStep() {
            for (InsideBlockEffectType $$0 : APPLY_ORDER) {
                List<Consumer<Entity>> $$1 = this.beforeEffectsInStep.get((Object)$$0);
                this.finalEffects.addAll($$1);
                $$1.clear();
                if (this.effectsInStep.remove((Object)$$0)) {
                    this.finalEffects.add($$0.effect());
                }
                List<Consumer<Entity>> $$2 = this.afterEffectsInStep.get((Object)$$0);
                this.finalEffects.addAll($$2);
                $$2.clear();
            }
        }

        @Override
        public void apply(InsideBlockEffectType p_405360_) {
            this.effectsInStep.add(p_405360_);
        }

        @Override
        public void runBefore(InsideBlockEffectType p_404988_, Consumer<Entity> p_405666_) {
            this.beforeEffectsInStep.get((Object)p_404988_).add(p_405666_);
        }

        @Override
        public void runAfter(InsideBlockEffectType p_405004_, Consumer<Entity> p_404845_) {
            this.afterEffectsInStep.get((Object)p_405004_).add(p_404845_);
        }
    }
}

