/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class InterpolationHandler {
    public static final int DEFAULT_INTERPOLATION_STEPS = 3;
    private final Entity entity;
    private int interpolationSteps;
    private final InterpolationData interpolationData = new InterpolationData(0, Vec3.ZERO, 0.0f, 0.0f);
    @Nullable
    private Vec3 previousTickPosition;
    @Nullable
    private Vec2 previousTickRot;
    @Nullable
    private final Consumer<InterpolationHandler> onInterpolationStart;

    public InterpolationHandler(Entity p_394439_) {
        this(p_394439_, 3, null);
    }

    public InterpolationHandler(Entity p_394433_, int p_394544_) {
        this(p_394433_, p_394544_, null);
    }

    public InterpolationHandler(Entity p_394101_, @Nullable Consumer<InterpolationHandler> p_394503_) {
        this(p_394101_, 3, p_394503_);
    }

    public InterpolationHandler(Entity p_393992_, int p_394386_, @Nullable Consumer<InterpolationHandler> p_393601_) {
        this.interpolationSteps = p_394386_;
        this.entity = p_393992_;
        this.onInterpolationStart = p_393601_;
    }

    public Vec3 position() {
        return this.interpolationData.steps > 0 ? this.interpolationData.position : this.entity.position();
    }

    public float yRot() {
        return this.interpolationData.steps > 0 ? this.interpolationData.yRot : this.entity.getYRot();
    }

    public float xRot() {
        return this.interpolationData.steps > 0 ? this.interpolationData.xRot : this.entity.getXRot();
    }

    public void interpolateTo(Vec3 p_393836_, float p_394255_, float p_393907_) {
        if (this.interpolationSteps == 0) {
            this.entity.snapTo(p_393836_, p_394255_, p_393907_);
            this.cancel();
            return;
        }
        this.interpolationData.steps = this.interpolationSteps;
        this.interpolationData.position = p_393836_;
        this.interpolationData.yRot = p_394255_;
        this.interpolationData.xRot = p_393907_;
        this.previousTickPosition = this.entity.position();
        this.previousTickRot = new Vec2(this.entity.getXRot(), this.entity.getYRot());
        if (this.onInterpolationStart != null) {
            this.onInterpolationStart.accept(this);
        }
    }

    public boolean hasActiveInterpolation() {
        return this.interpolationData.steps > 0;
    }

    public void setInterpolationLength(int p_393476_) {
        this.interpolationSteps = p_393476_;
    }

    public void interpolate() {
        if (!this.hasActiveInterpolation()) {
            this.cancel();
            return;
        }
        double $$0 = 1.0 / (double)this.interpolationData.steps;
        if (this.previousTickPosition != null) {
            Vec3 $$1 = this.entity.position().subtract(this.previousTickPosition);
            if (this.entity.level().noCollision(this.entity, this.entity.makeBoundingBox().move(this.interpolationData.position.add($$1)))) {
                this.interpolationData.addDelta($$1);
            }
        }
        if (this.previousTickRot != null) {
            float $$2 = this.entity.getYRot() - this.previousTickRot.y;
            float $$3 = this.entity.getXRot() - this.previousTickRot.x;
            this.interpolationData.addRotation($$2, $$3);
        }
        double $$4 = Mth.lerp($$0, this.entity.getX(), this.interpolationData.position.x);
        double $$5 = Mth.lerp($$0, this.entity.getY(), this.interpolationData.position.y);
        double $$6 = Mth.lerp($$0, this.entity.getZ(), this.interpolationData.position.z);
        Vec3 $$7 = new Vec3($$4, $$5, $$6);
        float $$8 = (float)Mth.rotLerp($$0, (double)this.entity.getYRot(), (double)this.interpolationData.yRot);
        float $$9 = (float)Mth.lerp($$0, (double)this.entity.getXRot(), (double)this.interpolationData.xRot);
        this.entity.setPos($$7);
        this.entity.setRot($$8, $$9);
        this.interpolationData.decrease();
        this.previousTickPosition = $$7;
        this.previousTickRot = new Vec2(this.entity.getXRot(), this.entity.getYRot());
    }

    public void cancel() {
        this.interpolationData.steps = 0;
        this.previousTickPosition = null;
        this.previousTickRot = null;
    }

    static class InterpolationData {
        protected int steps;
        Vec3 position;
        float yRot;
        float xRot;

        InterpolationData(int p_394434_, Vec3 p_393933_, float p_393655_, float p_393861_) {
            this.steps = p_394434_;
            this.position = p_393933_;
            this.yRot = p_393655_;
            this.xRot = p_393861_;
        }

        public void decrease() {
            --this.steps;
        }

        public void addDelta(Vec3 p_394401_) {
            this.position = this.position.add(p_394401_);
        }

        public void addRotation(float p_393925_, float p_393734_) {
            this.yRot += p_393925_;
            this.xRot += p_393734_;
        }
    }
}

