/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.ContainerSingleItem;

public abstract class Mob
extends LivingEntity
implements EquipmentUser,
Leashable,
Targeting {
    private static final EntityDataAccessor<Byte> DATA_MOB_FLAGS_ID = SynchedEntityData.defineId(Mob.class, EntityDataSerializers.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(1, 0, 1);
    private static final List<EquipmentSlot> EQUIPMENT_POPULATION_ORDER = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean DEFAULT_CAN_PICK_UP_LOOT = false;
    private static final boolean DEFAULT_PERSISTENCE_REQUIRED = false;
    private static final boolean DEFAULT_LEFT_HANDED = false;
    private static final boolean DEFAULT_NO_AI = false;
    protected static final ResourceLocation RANDOM_SPAWN_BONUS_ID = ResourceLocation.withDefaultNamespace("random_spawn_bonus");
    public int ambientSoundTime;
    protected int xpReward;
    protected LookControl lookControl;
    protected MoveControl moveControl;
    protected JumpControl jumpControl;
    private final BodyRotationControl bodyRotationControl;
    protected PathNavigation navigation;
    protected final GoalSelector goalSelector;
    protected final GoalSelector targetSelector;
    @Nullable
    private LivingEntity target;
    private final Sensing sensing;
    private DropChances dropChances = DropChances.DEFAULT;
    private boolean canPickUpLoot = false;
    private boolean persistenceRequired = false;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    private Optional<ResourceKey<LootTable>> lootTable = Optional.empty();
    private long lootTableSeed;
    @Nullable
    private Leashable.LeashData leashData;
    private BlockPos restrictCenter = BlockPos.ZERO;
    private float restrictRadius = -1.0f;

    protected Mob(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super((EntityType<? extends LivingEntity>)p_21368_, p_21369_);
        this.goalSelector = new GoalSelector();
        this.targetSelector = new GoalSelector();
        this.lookControl = new LookControl(this);
        this.moveControl = new MoveControl(this);
        this.jumpControl = new JumpControl(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(p_21369_);
        this.sensing = new Sensing(this);
        if (p_21369_ instanceof ServerLevel) {
            this.registerGoals();
        }
    }

    protected void registerGoals() {
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new GroundPathNavigation(this, p_21480_);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType p_326934_) {
        Mob $$3;
        Mob $$1;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob && ($$1 = (Mob)entity).shouldPassengersInheritMalus()) {
            Mob $$2 = $$1;
        } else {
            $$3 = this;
        }
        Float $$4 = $$3.pathfindingMalus.get((Object)p_326934_);
        return $$4 == null ? p_326934_.getMalus() : $$4.floatValue();
    }

    public void setPathfindingMalus(PathType p_326826_, float p_21443_) {
        this.pathfindingMalus.put(p_326826_, Float.valueOf(p_21443_));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this);
    }

    public LookControl getLookControl() {
        return this.lookControl;
    }

    public MoveControl getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob $$0 = (Mob)entity;
            return $$0.getMoveControl();
        }
        return this.moveControl;
    }

    public JumpControl getJumpControl() {
        return this.jumpControl;
    }

    public PathNavigation getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob $$0 = (Mob)entity;
            return $$0.getNavigation();
        }
        return this.navigation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity $$0 = this.getFirstPassenger();
        if (this.isNoAi()) return null;
        if (!($$0 instanceof Mob)) return null;
        Mob $$1 = (Mob)$$0;
        if (!$$0.canControlVehicle()) return null;
        Mob mob = $$1;
        return mob;
    }

    public Sensing getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Nullable
    protected final LivingEntity getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable LivingEntity p_21544_) {
        this.target = p_21544_;
    }

    @Override
    public boolean canAttackType(EntityType<?> p_21399_) {
        return p_21399_ != EntityType.GHAST;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem p_21430_) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        ProfilerFiller $$0 = Profiler.get();
        $$0.push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        $$0.pop();
    }

    @Override
    protected void playHurtSound(DamageSource p_21493_) {
        this.resetAmbientSoundTime();
        super.playHurtSound(p_21493_);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel p_376894_) {
        if (this.xpReward > 0) {
            int $$1 = this.xpReward;
            for (EquipmentSlot $$2 : EquipmentSlot.VALUES) {
                ItemStack $$3;
                if (!$$2.canIncreaseExperience() || ($$3 = this.getItemBySlot($$2)).isEmpty() || !(this.dropChances.byEquipment($$2) <= 1.0f)) continue;
                $$1 += 1 + this.random.nextInt(3);
            }
            return $$1;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            this.makePoofParticles();
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            this.updateControlFlags();
        }
    }

    protected void updateControlFlags() {
        boolean $$0 = !(this.getControllingPassenger() instanceof Mob);
        boolean $$1 = !(this.getVehicle() instanceof AbstractBoat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, $$0);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, $$0 && $$1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, $$0);
    }

    @Override
    protected void tickHeadTurn(float p_21538_) {
        this.bodyRotationControl.clientTick();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21484_) {
        super.addAdditionalSaveData(p_21484_);
        p_21484_.putBoolean("CanPickUpLoot", this.canPickUpLoot());
        p_21484_.putBoolean("PersistenceRequired", this.persistenceRequired);
        RegistryOps<Tag> $$1 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        if (!this.dropChances.equals(DropChances.DEFAULT)) {
            p_21484_.store("drop_chances", DropChances.CODEC, $$1, this.dropChances);
        }
        this.writeLeashData(p_21484_, this.leashData);
        p_21484_.putBoolean("LeftHanded", this.isLeftHanded());
        this.lootTable.ifPresent(p_404281_ -> p_21484_.store("DeathLootTable", LootTable.KEY_CODEC, p_404281_));
        if (this.lootTableSeed != 0L) {
            p_21484_.putLong("DeathLootTableSeed", this.lootTableSeed);
        }
        if (this.isNoAi()) {
            p_21484_.putBoolean("NoAI", this.isNoAi());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21450_) {
        super.readAdditionalSaveData(p_21450_);
        this.setCanPickUpLoot(p_21450_.getBooleanOr("CanPickUpLoot", false));
        this.persistenceRequired = p_21450_.getBooleanOr("PersistenceRequired", false);
        RegistryOps<Tag> $$1 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        this.dropChances = p_21450_.read("drop_chances", DropChances.CODEC, $$1).orElse(DropChances.DEFAULT);
        this.readLeashData(p_21450_);
        this.setLeftHanded(p_21450_.getBooleanOr("LeftHanded", false));
        this.lootTable = p_21450_.read("DeathLootTable", LootTable.KEY_CODEC);
        this.lootTableSeed = p_21450_.getLongOr("DeathLootTableSeed", 0L);
        this.setNoAi(p_21450_.getBooleanOr("NoAI", false));
    }

    @Override
    protected void dropFromLootTable(ServerLevel p_376326_, DamageSource p_21389_, boolean p_21390_) {
        super.dropFromLootTable(p_376326_, p_21389_, p_21390_);
        this.lootTable = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> getLootTable() {
        if (this.lootTable.isPresent()) {
            return this.lootTable;
        }
        return super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float p_21565_) {
        this.zza = p_21565_;
    }

    public void setYya(float p_21568_) {
        this.yya = p_21568_;
    }

    public void setXxa(float p_21571_) {
        this.xxa = p_21571_;
    }

    @Override
    public void setSpeed(float p_21556_) {
        super.setSpeed(p_21556_);
        this.setZza(p_21556_);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        ProfilerFiller $$0 = Profiler.get();
        $$0.push("looting");
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            if (this.canPickUpLoot() && this.isAlive() && !this.dead && $$1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                Vec3i $$2 = this.getPickupReach();
                List<ItemEntity> $$3 = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate($$2.getX(), $$2.getY(), $$2.getZ()));
                for (ItemEntity $$4 : $$3) {
                    if ($$4.isRemoved() || $$4.getItem().isEmpty() || $$4.hasPickUpDelay() || !this.wantsToPickUp($$1, $$4.getItem())) continue;
                    this.pickUpItem($$1, $$4);
                }
            }
        }
        $$0.pop();
    }

    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(ServerLevel p_376779_, ItemEntity p_21471_) {
        ItemStack $$2 = p_21471_.getItem();
        ItemStack $$3 = this.equipItemIfPossible(p_376779_, $$2.copy());
        if (!$$3.isEmpty()) {
            this.onItemPickup(p_21471_);
            this.take(p_21471_, $$3.getCount());
            $$2.shrink($$3.getCount());
            if ($$2.isEmpty()) {
                p_21471_.discard();
            }
        }
    }

    public ItemStack equipItemIfPossible(ServerLevel p_376644_, ItemStack p_255842_) {
        EquipmentSlot $$2 = this.getEquipmentSlotForItem(p_255842_);
        if (!this.isEquippableInSlot(p_255842_, $$2)) {
            return ItemStack.EMPTY;
        }
        ItemStack $$3 = this.getItemBySlot($$2);
        boolean $$4 = this.canReplaceCurrentItem(p_255842_, $$3, $$2);
        if ($$2.isArmor() && !$$4) {
            $$2 = EquipmentSlot.MAINHAND;
            $$3 = this.getItemBySlot($$2);
            $$4 = $$3.isEmpty();
        }
        if ($$4 && this.canHoldItem(p_255842_)) {
            double $$5 = this.dropChances.byEquipment($$2);
            if (!$$3.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < $$5) {
                this.spawnAtLocation(p_376644_, $$3);
            }
            ItemStack $$6 = $$2.limit(p_255842_);
            this.setItemSlotAndDropWhenKilled($$2, $$6);
            return $$6;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EquipmentSlot p_21469_, ItemStack p_21470_) {
        this.setItemSlot(p_21469_, p_21470_);
        this.setGuaranteedDrop(p_21469_);
        this.persistenceRequired = true;
    }

    public void setGuaranteedDrop(EquipmentSlot p_21509_) {
        this.dropChances = this.dropChances.withGuaranteedDrop(p_21509_);
    }

    protected boolean canReplaceCurrentItem(ItemStack p_21428_, ItemStack p_21429_, EquipmentSlot p_371540_) {
        if (p_21429_.isEmpty()) {
            return true;
        }
        if (p_371540_.isArmor()) {
            return this.compareArmor(p_21428_, p_21429_, p_371540_);
        }
        if (p_371540_ == EquipmentSlot.MAINHAND) {
            return this.compareWeapons(p_21428_, p_21429_, p_371540_);
        }
        return false;
    }

    private boolean compareArmor(ItemStack p_388622_, ItemStack p_388471_, EquipmentSlot p_386926_) {
        if (EnchantmentHelper.has(p_388471_, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        double $$3 = this.getApproximateAttributeWith(p_388622_, Attributes.ARMOR, p_386926_);
        double $$4 = this.getApproximateAttributeWith(p_388471_, Attributes.ARMOR, p_386926_);
        double $$5 = this.getApproximateAttributeWith(p_388622_, Attributes.ARMOR_TOUGHNESS, p_386926_);
        double $$6 = this.getApproximateAttributeWith(p_388471_, Attributes.ARMOR_TOUGHNESS, p_386926_);
        if ($$3 != $$4) {
            return $$3 > $$4;
        }
        if ($$5 != $$6) {
            return $$5 > $$6;
        }
        return this.canReplaceEqualItem(p_388622_, p_388471_);
    }

    private boolean compareWeapons(ItemStack p_386619_, ItemStack p_387764_, EquipmentSlot p_387859_) {
        double $$5;
        double $$4;
        TagKey<Item> $$3 = this.getPreferredWeaponType();
        if ($$3 != null) {
            if (p_387764_.is($$3) && !p_386619_.is($$3)) {
                return false;
            }
            if (!p_387764_.is($$3) && p_386619_.is($$3)) {
                return true;
            }
        }
        if (($$4 = this.getApproximateAttributeWith(p_386619_, Attributes.ATTACK_DAMAGE, p_387859_)) != ($$5 = this.getApproximateAttributeWith(p_387764_, Attributes.ATTACK_DAMAGE, p_387859_))) {
            return $$4 > $$5;
        }
        return this.canReplaceEqualItem(p_386619_, p_387764_);
    }

    private double getApproximateAttributeWith(ItemStack p_371461_, Holder<Attribute> p_371421_, EquipmentSlot p_371891_) {
        double $$3 = this.getAttributes().hasAttribute(p_371421_) ? this.getAttributeBaseValue(p_371421_) : 0.0;
        ItemAttributeModifiers $$4 = p_371461_.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return $$4.compute($$3, p_371891_);
    }

    public boolean canReplaceEqualItem(ItemStack p_21478_, ItemStack p_21479_) {
        int $$5;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> $$2 = p_21479_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> $$3 = p_21478_.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).entrySet();
        if ($$3.size() != $$2.size()) {
            return $$3.size() > $$2.size();
        }
        int $$4 = p_21478_.getDamageValue();
        if ($$4 != ($$5 = p_21479_.getDamageValue())) {
            return $$4 < $$5;
        }
        return p_21478_.has(DataComponents.CUSTOM_NAME) && !p_21479_.has(DataComponents.CUSTOM_NAME);
    }

    public boolean canHoldItem(ItemStack p_21545_) {
        return true;
    }

    public boolean wantsToPickUp(ServerLevel p_376139_, ItemStack p_21546_) {
        return this.canHoldItem(p_21546_);
    }

    @Nullable
    public TagKey<Item> getPreferredWeaponType() {
        return null;
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
            return;
        }
        if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
            this.noActionTime = 0;
            return;
        }
        Player $$0 = this.level().getNearestPlayer(this, -1.0);
        if ($$0 != null) {
            int $$2;
            int $$3;
            double $$1 = $$0.distanceToSqr(this);
            if ($$1 > (double)($$3 = ($$2 = this.getType().getCategory().getDespawnDistance()) * $$2) && this.removeWhenFarAway($$1)) {
                this.discard();
            }
            int $$4 = this.getType().getCategory().getNoDespawnDistance();
            int $$5 = $$4 * $$4;
            if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && $$1 > (double)$$5 && this.removeWhenFarAway($$1)) {
                this.discard();
            } else if ($$1 < (double)$$5) {
                this.noActionTime = 0;
            }
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        ProfilerFiller $$0 = Profiler.get();
        $$0.push("sensing");
        this.sensing.tick();
        $$0.pop();
        int $$1 = this.tickCount + this.getId();
        if ($$1 % 2 == 0 || this.tickCount <= 1) {
            $$0.push("targetSelector");
            this.targetSelector.tick();
            $$0.pop();
            $$0.push("goalSelector");
            this.goalSelector.tick();
            $$0.pop();
        } else {
            $$0.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            $$0.pop();
            $$0.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            $$0.pop();
        }
        $$0.push("navigation");
        this.navigation.tick();
        $$0.pop();
        $$0.push("mob tick");
        this.customServerAiStep((ServerLevel)this.level());
        $$0.pop();
        $$0.push("controls");
        $$0.push("move");
        this.moveControl.tick();
        $$0.popPush("look");
        this.lookControl.tick();
        $$0.popPush("jump");
        this.jumpControl.tick();
        $$0.pop();
        $$0.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        DebugPackets.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep(ServerLevel p_376725_) {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float $$0 = this.getMaxHeadYRot();
        float $$1 = this.getYHeadRot();
        float $$2 = Mth.wrapDegrees(this.yBodyRot - $$1);
        float $$3 = Mth.clamp(Mth.wrapDegrees(this.yBodyRot - $$1), -$$0, $$0);
        float $$4 = $$1 + $$2 - $$3;
        this.setYHeadRot($$4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity p_21392_, float p_21393_, float p_21394_) {
        double $$7;
        double $$3 = p_21392_.getX() - this.getX();
        double $$4 = p_21392_.getZ() - this.getZ();
        if (p_21392_ instanceof LivingEntity) {
            LivingEntity $$5 = (LivingEntity)p_21392_;
            double $$6 = $$5.getEyeY() - this.getEyeY();
        } else {
            $$7 = (p_21392_.getBoundingBox().minY + p_21392_.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double $$8 = Math.sqrt($$3 * $$3 + $$4 * $$4);
        float $$9 = (float)(Mth.atan2($$4, $$3) * 57.2957763671875) - 90.0f;
        float $$10 = (float)(-(Mth.atan2($$7, $$8) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), $$10, p_21394_));
        this.setYRot(this.rotlerp(this.getYRot(), $$9, p_21393_));
    }

    private float rotlerp(float p_21377_, float p_21378_, float p_21379_) {
        float $$3 = Mth.wrapDegrees(p_21378_ - p_21377_);
        if ($$3 > p_21379_) {
            $$3 = p_21379_;
        }
        if ($$3 < -p_21379_) {
            $$3 = -p_21379_;
        }
        return p_21377_ + $$3;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> p_217058_, LevelAccessor p_217059_, EntitySpawnReason p_365247_, BlockPos p_217061_, RandomSource p_217062_) {
        BlockPos $$5 = p_217061_.below();
        return EntitySpawnReason.isSpawner(p_365247_) || p_217059_.getBlockState($$5).isValidSpawn(p_217059_, $$5, p_217058_);
    }

    public boolean checkSpawnRules(LevelAccessor p_21431_, EntitySpawnReason p_360512_) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader p_21433_) {
        return !p_21433_.containsAnyLiquid(this.getBoundingBox()) && p_21433_.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int p_21489_) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int $$0 = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if (($$0 -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            $$0 = 0;
        }
        return this.getComfortableFallDistance($$0);
    }

    public ItemStack getBodyArmorItem() {
        return this.getItemBySlot(EquipmentSlot.BODY);
    }

    public boolean isSaddled() {
        return this.hasItemInSlot(EquipmentSlot.SADDLE);
    }

    public boolean isWearingBodyArmor() {
        return this.hasItemInSlot(EquipmentSlot.BODY);
    }

    public void setBodyArmorItem(ItemStack p_323721_) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.BODY, p_323721_);
    }

    public Container createEquipmentSlotContainer(final EquipmentSlot p_397086_) {
        return new ContainerSingleItem(){

            @Override
            public ItemStack getTheItem() {
                return Mob.this.getItemBySlot(p_397086_);
            }

            @Override
            public void setTheItem(ItemStack p_396982_) {
                Mob.this.setItemSlot(p_397086_, p_396982_);
                if (!p_396982_.isEmpty()) {
                    Mob.this.setGuaranteedDrop(p_397086_);
                    Mob.this.setPersistenceRequired();
                }
            }

            @Override
            public void setChanged() {
            }

            @Override
            public boolean stillValid(Player p_397156_) {
                return p_397156_.getVehicle() == Mob.this || p_397156_.canInteractWithEntity(Mob.this, 4.0);
            }
        };
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel p_348683_, DamageSource p_21385_, boolean p_21387_) {
        super.dropCustomDeathLoot(p_348683_, p_21385_, p_21387_);
        for (EquipmentSlot $$3 : EquipmentSlot.VALUES) {
            ItemStack $$4 = this.getItemBySlot($$3);
            float $$5 = this.dropChances.byEquipment($$3);
            if ($$5 == 0.0f) continue;
            boolean $$6 = this.dropChances.isPreserved($$3);
            Object object = p_21385_.getEntity();
            if (object instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)object;
                object = this.level();
                if (object instanceof ServerLevel) {
                    ServerLevel $$8 = (ServerLevel)object;
                    $$5 = EnchantmentHelper.processEquipmentDropChance($$8, $$7, p_21385_, $$5);
                }
            }
            if ($$4.isEmpty() || EnchantmentHelper.has($$4, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || !p_21387_ && !$$6 || !(this.random.nextFloat() < $$5)) continue;
            if (!$$6 && $$4.isDamageableItem()) {
                $$4.setDamageValue($$4.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max($$4.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation(p_348683_, $$4);
            this.setItemSlot($$3, ItemStack.EMPTY);
        }
    }

    public DropChances getDropChances() {
        return this.dropChances;
    }

    public void dropPreservedEquipment(ServerLevel p_376214_) {
        this.dropPreservedEquipment(p_376214_, p_352412_ -> true);
    }

    public Set<EquipmentSlot> dropPreservedEquipment(ServerLevel p_376128_, Predicate<ItemStack> p_352191_) {
        HashSet<EquipmentSlot> $$2 = new HashSet<EquipmentSlot>();
        for (EquipmentSlot $$3 : EquipmentSlot.VALUES) {
            ItemStack $$4 = this.getItemBySlot($$3);
            if ($$4.isEmpty()) continue;
            if (!p_352191_.test($$4)) {
                $$2.add($$3);
                continue;
            }
            if (!this.dropChances.isPreserved($$3)) continue;
            this.setItemSlot($$3, ItemStack.EMPTY);
            this.spawnAtLocation(p_376128_, $$4);
        }
        return $$2;
    }

    private LootParams createEquipmentParams(ServerLevel p_338758_) {
        return new LootParams.Builder(p_338758_).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.EQUIPMENT);
    }

    public void equip(EquipmentTable p_341198_) {
        this.equip(p_341198_.lootTable(), p_341198_.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> p_340912_, Map<EquipmentSlot, Float> p_340996_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            this.equip(p_340912_, this.createEquipmentParams($$2), p_340996_);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (p_217055_.nextFloat() < 0.15f * p_217056_.getSpecialMultiplier()) {
            float $$3;
            int $$2 = p_217055_.nextInt(2);
            float f = $$3 = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            boolean $$4 = true;
            for (EquipmentSlot $$5 : EQUIPMENT_POPULATION_ORDER) {
                Item $$7;
                ItemStack $$6 = this.getItemBySlot($$5);
                if (!$$4 && p_217055_.nextFloat() < $$3) break;
                $$4 = false;
                if (!$$6.isEmpty() || ($$7 = Mob.getEquipmentForSlot($$5, $$2)) == null) continue;
                this.setItemSlot($$5, new ItemStack($$7));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EquipmentSlot p_21413_, int p_21414_) {
        switch (p_21413_) {
            case HEAD: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_HELMET;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_BOOTS;
                }
                if (p_21414_ != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor p_348529_, RandomSource p_217063_, DifficultyInstance p_217064_) {
        this.enchantSpawnedWeapon(p_348529_, p_217063_, p_217064_);
        for (EquipmentSlot $$3 : EquipmentSlot.VALUES) {
            if ($$3.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.enchantSpawnedArmor(p_348529_, p_217063_, $$3, p_217064_);
        }
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor p_348685_, RandomSource p_217049_, DifficultyInstance p_348671_) {
        this.enchantSpawnedEquipment(p_348685_, EquipmentSlot.MAINHAND, p_217049_, 0.25f, p_348671_);
    }

    protected void enchantSpawnedArmor(ServerLevelAccessor p_348675_, RandomSource p_217052_, EquipmentSlot p_217054_, DifficultyInstance p_348681_) {
        this.enchantSpawnedEquipment(p_348675_, p_217054_, p_217052_, 0.5f, p_348681_);
    }

    private void enchantSpawnedEquipment(ServerLevelAccessor p_348676_, EquipmentSlot p_345506_, RandomSource p_345779_, float p_345423_, DifficultyInstance p_348488_) {
        ItemStack $$5 = this.getItemBySlot(p_345506_);
        if (!$$5.isEmpty() && p_345779_.nextFloat() < p_345423_ * p_348488_.getSpecialMultiplier()) {
            EnchantmentHelper.enchantItemFromProvider($$5, p_348676_.registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, p_348488_, p_345779_);
            this.setItemSlot(p_345506_, $$5);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_363352_, @Nullable SpawnGroupData p_21437_) {
        RandomSource $$4 = p_21434_.getRandom();
        AttributeInstance $$5 = Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE));
        if (!$$5.hasModifier(RANDOM_SPAWN_BONUS_ID)) {
            $$5.addPermanentModifier(new AttributeModifier(RANDOM_SPAWN_BONUS_ID, $$4.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        this.setLeftHanded($$4.nextFloat() < 0.05f);
        return p_21437_;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EquipmentSlot p_21410_, float p_21411_) {
        this.dropChances = this.dropChances.withEquipmentChance(p_21410_, p_21411_);
    }

    @Override
    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean p_21554_) {
        this.canPickUpLoot = p_21554_;
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371241_) {
        return this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final InteractionResult interact(Player p_21420_, InteractionHand p_21421_) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        InteractionResult $$2 = this.checkAndHandleImportantInteractions(p_21420_, p_21421_);
        if ($$2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return $$2;
        }
        InteractionResult $$3 = super.interact(p_21420_, p_21421_);
        if ($$3 != InteractionResult.PASS) {
            return $$3;
        }
        $$2 = this.mobInteract(p_21420_, p_21421_);
        if ($$2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return $$2;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult checkAndHandleImportantInteractions(Player p_21500_, InteractionHand p_21501_) {
        InteractionResult $$3;
        ItemStack $$2 = p_21500_.getItemInHand(p_21501_);
        if ($$2.is(Items.NAME_TAG) && ($$3 = $$2.interactLivingEntity(p_21500_, this, p_21501_)).consumesAction()) {
            return $$3;
        }
        if ($$2.getItem() instanceof SpawnEggItem) {
            if (this.level() instanceof ServerLevel) {
                SpawnEggItem $$4 = (SpawnEggItem)$$2.getItem();
                Optional<Mob> $$5 = $$4.spawnOffspringFromSpawnEgg(p_21500_, this, this.getType(), (ServerLevel)this.level(), this.position(), $$2);
                $$5.ifPresent(p_21476_ -> this.onOffspringSpawnedFromEgg(p_21500_, (Mob)p_21476_));
                if ($$5.isEmpty()) {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(Player p_21422_, Mob p_21423_) {
    }

    protected InteractionResult mobInteract(Player p_21472_, InteractionHand p_21473_) {
        return InteractionResult.PASS;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPos p_21445_) {
        if (this.restrictRadius == -1.0f) {
            return true;
        }
        return this.restrictCenter.distSqr(p_21445_) < (double)(this.restrictRadius * this.restrictRadius);
    }

    public void restrictTo(BlockPos p_21447_, int p_21448_) {
        this.restrictCenter = p_21447_;
        this.restrictRadius = p_21448_;
    }

    public BlockPos getRestrictCenter() {
        return this.restrictCenter;
    }

    public float getRestrictRadius() {
        return this.restrictRadius;
    }

    public void clearRestriction() {
        this.restrictRadius = -1.0f;
    }

    public boolean hasRestriction() {
        return this.restrictRadius != -1.0f;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> p_21407_, ConversionParams p_371709_, EntitySpawnReason p_371281_, ConversionParams.AfterConversion<T> p_371266_) {
        if (this.isRemoved()) {
            return null;
        }
        Mob $$4 = (Mob)p_21407_.create(this.level(), p_371281_);
        if ($$4 == null) {
            return null;
        }
        p_371709_.type().convert(this, $$4, p_371709_);
        p_371266_.finalizeConversion($$4);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)level;
            $$5.addFreshEntity($$4);
        }
        if (p_371709_.type().shouldDiscardAfterConversion()) {
            this.discard();
        }
        return (T)$$4;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> p_371496_, ConversionParams p_371476_, ConversionParams.AfterConversion<T> p_371861_) {
        return this.convertTo(p_371496_, p_371476_, EntitySpawnReason.CONVERSION, p_371861_);
    }

    @Override
    @Nullable
    public Leashable.LeashData getLeashData() {
        return this.leashData;
    }

    @Override
    public void setLeashData(@Nullable Leashable.LeashData p_352221_) {
        this.leashData = p_352221_;
    }

    @Override
    public void onLeashRemoved() {
        if (this.getLeashData() == null) {
            this.clearRestriction();
        }
    }

    @Override
    public void leashTooFarBehaviour() {
        Leashable.super.leashTooFarBehaviour();
        this.goalSelector.disableControlFlag(Goal.Flag.MOVE);
    }

    @Override
    public boolean canBeLeashed() {
        return !(this instanceof Enemy);
    }

    @Override
    public boolean startRiding(Entity p_21396_, boolean p_21397_) {
        boolean $$2 = super.startRiding(p_21396_, p_21397_);
        if ($$2 && this.isLeashed()) {
            this.dropLeash();
        }
        return $$2;
    }

    @Override
    public boolean canSimulateMovement() {
        return super.canSimulateMovement() && !this.isNoAi();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean p_21558_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21558_ ? (byte)($$1 | 1) : (byte)($$1 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean p_21560_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21560_ ? (byte)($$1 | 2) : (byte)($$1 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean p_21562_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21562_ ? (byte)($$1 | 4) : (byte)($$1 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean p_21451_) {
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity p_217067_) {
        return this.getAttackBoundingBox().intersects(p_217067_.getHitbox());
    }

    protected AABB getAttackBoundingBox() {
        AABB $$4;
        Entity $$0 = this.getVehicle();
        if ($$0 != null) {
            AABB $$1 = $$0.getBoundingBox();
            AABB $$2 = this.getBoundingBox();
            AABB $$3 = new AABB(Math.min($$2.minX, $$1.minX), $$2.minY, Math.min($$2.minZ, $$1.minZ), Math.max($$2.maxX, $$1.maxX), $$2.maxY, Math.max($$2.maxZ, $$1.maxZ));
        } else {
            $$4 = this.getBoundingBox();
        }
        return $$4.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(ServerLevel p_376642_, Entity p_21372_) {
        boolean $$5;
        float $$2 = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        ItemStack $$3 = this.getWeaponItem();
        DamageSource $$4 = Optional.ofNullable($$3.getItem().getDamageSource(this)).orElse(this.damageSources().mobAttack(this));
        $$2 = EnchantmentHelper.modifyDamage(p_376642_, $$3, p_21372_, $$4, $$2);
        if ($$5 = p_21372_.hurtServer(p_376642_, $$4, $$2 += $$3.getItem().getAttackDamageBonus(p_21372_, $$2, $$4))) {
            float $$6 = this.getKnockback(p_21372_, $$4);
            if ($$6 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)p_21372_;
                $$7.knockback($$6 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if (p_21372_ instanceof LivingEntity) {
                LivingEntity $$8 = (LivingEntity)p_21372_;
                $$3.hurtEnemy($$8, this);
            }
            EnchantmentHelper.doPostAttackEffects(p_376642_, p_21372_, $$4);
            this.setLastHurtMob(p_21372_);
            this.playAttackSound();
        }
        return $$5;
    }

    protected void playAttackSound() {
    }

    protected boolean isSunBurnTick() {
        if (this.level().isBrightOutside() && !this.level().isClientSide) {
            boolean $$2;
            float $$0 = this.getLightLevelDependentMagicValue();
            BlockPos $$1 = BlockPos.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = $$2 = this.isInWaterOrRain() || this.isInPowderSnow || this.wasInPowderSnow;
            if ($$0 > 0.5f && this.random.nextFloat() * 30.0f < ($$0 - 0.4f) * 2.0f && !$$2 && this.level().canSeeSky($$1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<Fluid> p_204045_) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(p_204045_);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(p_351790_ -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<Goal> p_262667_) {
        this.goalSelector.removeAllGoals(p_262667_);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        for (EquipmentSlot $$0 : EquipmentSlot.VALUES) {
            ItemStack $$1 = this.getItemBySlot($$0);
            if ($$1.isEmpty()) continue;
            $$1.setCount(0);
        }
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        SpawnEggItem $$0 = SpawnEggItem.byId(this.getType());
        if ($$0 == null) {
            return null;
        }
        return new ItemStack($$0);
    }

    @Override
    protected void onAttributeUpdated(Holder<Attribute> p_363635_) {
        super.onAttributeUpdated(p_363635_);
        if (p_363635_.is(Attributes.FOLLOW_RANGE) || p_363635_.is(Attributes.TEMPT_RANGE)) {
            this.getNavigation().updatePathfinderMaxVisitedNodes();
        }
    }
}

