/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface NeutralMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(CompoundTag p_21679_) {
        p_21679_.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        p_21679_.storeNullable(TAG_ANGRY_AT, UUIDUtil.CODEC, this.getPersistentAngerTarget());
    }

    /*
     * WARNING - void declaration
     */
    default public void readPersistentAngerSaveData(Level p_147286_, CompoundTag p_147287_) {
        void $$3;
        Entity $$5;
        this.setRemainingPersistentAngerTime(p_147287_.getIntOr(TAG_ANGER_TIME, 0));
        if (!(p_147286_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$2 = (ServerLevel)p_147286_;
        UUID $$4 = p_147287_.read(TAG_ANGRY_AT, UUIDUtil.CODEC).orElse(null);
        this.setPersistentAngerTarget($$4);
        Entity entity = $$5 = $$4 != null ? $$3.getEntity($$4) : null;
        if ($$5 instanceof LivingEntity) {
            LivingEntity $$6 = (LivingEntity)$$5;
            this.setTarget($$6);
        }
    }

    default public void updatePersistentAnger(ServerLevel p_21667_, boolean p_21668_) {
        LivingEntity $$2 = this.getTarget();
        UUID $$3 = this.getPersistentAngerTarget();
        if (($$2 == null || $$2.isDeadOrDying()) && $$3 != null && p_21667_.getEntity($$3) instanceof Mob) {
            this.stopBeingAngry();
            return;
        }
        if ($$2 != null && !Objects.equals($$3, $$2.getUUID())) {
            this.setPersistentAngerTarget($$2.getUUID());
            this.startPersistentAngerTimer();
        }
        if (!(this.getRemainingPersistentAngerTime() <= 0 || $$2 != null && $$2.getType() == EntityType.PLAYER && p_21668_)) {
            this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
            if (this.getRemainingPersistentAngerTime() == 0) {
                this.stopBeingAngry();
            }
        }
    }

    default public boolean isAngryAt(LivingEntity p_21675_, ServerLevel p_376199_) {
        if (!this.canAttack(p_21675_)) {
            return false;
        }
        if (p_21675_.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(p_376199_)) {
            return true;
        }
        return p_21675_.getUUID().equals(this.getPersistentAngerTarget());
    }

    default public boolean isAngryAtAllPlayers(ServerLevel p_376114_) {
        return p_376114_.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(ServerLevel p_376731_, Player p_21677_) {
        if (!p_376731_.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            return;
        }
        if (!p_21677_.getUUID().equals(this.getPersistentAngerTarget())) {
            return;
        }
        this.stopBeingAngry();
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean canAttack(LivingEntity var1);

    @Nullable
    public LivingEntity getTarget();
}

