/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.variant.MoonBrightnessCheck;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.entity.variant.StructureCheck;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface CatVariants {
    public static final ResourceKey<CatVariant> TABBY = CatVariants.createKey("tabby");
    public static final ResourceKey<CatVariant> BLACK = CatVariants.createKey("black");
    public static final ResourceKey<CatVariant> RED = CatVariants.createKey("red");
    public static final ResourceKey<CatVariant> SIAMESE = CatVariants.createKey("siamese");
    public static final ResourceKey<CatVariant> BRITISH_SHORTHAIR = CatVariants.createKey("british_shorthair");
    public static final ResourceKey<CatVariant> CALICO = CatVariants.createKey("calico");
    public static final ResourceKey<CatVariant> PERSIAN = CatVariants.createKey("persian");
    public static final ResourceKey<CatVariant> RAGDOLL = CatVariants.createKey("ragdoll");
    public static final ResourceKey<CatVariant> WHITE = CatVariants.createKey("white");
    public static final ResourceKey<CatVariant> JELLIE = CatVariants.createKey("jellie");
    public static final ResourceKey<CatVariant> ALL_BLACK = CatVariants.createKey("all_black");

    private static ResourceKey<CatVariant> createKey(String p_400052_) {
        return ResourceKey.create(Registries.CAT_VARIANT, ResourceLocation.withDefaultNamespace(p_400052_));
    }

    public static void bootstrap(BootstrapContext<CatVariant> p_399928_) {
        HolderGetter<Structure> $$1 = p_399928_.lookup(Registries.STRUCTURE);
        CatVariants.registerForAnyConditions(p_399928_, TABBY, "entity/cat/tabby");
        CatVariants.registerForAnyConditions(p_399928_, BLACK, "entity/cat/black");
        CatVariants.registerForAnyConditions(p_399928_, RED, "entity/cat/red");
        CatVariants.registerForAnyConditions(p_399928_, SIAMESE, "entity/cat/siamese");
        CatVariants.registerForAnyConditions(p_399928_, BRITISH_SHORTHAIR, "entity/cat/british_shorthair");
        CatVariants.registerForAnyConditions(p_399928_, CALICO, "entity/cat/calico");
        CatVariants.registerForAnyConditions(p_399928_, PERSIAN, "entity/cat/persian");
        CatVariants.registerForAnyConditions(p_399928_, RAGDOLL, "entity/cat/ragdoll");
        CatVariants.registerForAnyConditions(p_399928_, WHITE, "entity/cat/white");
        CatVariants.registerForAnyConditions(p_399928_, JELLIE, "entity/cat/jellie");
        CatVariants.register(p_399928_, ALL_BLACK, "entity/cat/all_black", new SpawnPrioritySelectors(List.of(new PriorityProvider.Selector(new StructureCheck($$1.getOrThrow(StructureTags.CATS_SPAWN_AS_BLACK)), 1), new PriorityProvider.Selector(new MoonBrightnessCheck(MinMaxBounds.Doubles.atLeast(0.9)), 0))));
    }

    private static void registerForAnyConditions(BootstrapContext<CatVariant> p_400050_, ResourceKey<CatVariant> p_400018_, String p_400303_) {
        CatVariants.register(p_400050_, p_400018_, p_400303_, SpawnPrioritySelectors.fallback(0));
    }

    private static void register(BootstrapContext<CatVariant> p_399892_, ResourceKey<CatVariant> p_399657_, String p_399991_, SpawnPrioritySelectors p_400099_) {
        p_399892_.register(p_399657_, new CatVariant(new ClientAsset(ResourceLocation.withDefaultNamespace(p_399991_)), p_400099_));
    }

    public static Optional<Holder.Reference<CatVariant>> selectVariantToSpawn(RandomSource p_399848_, RegistryAccess p_399748_, SpawnContext p_399931_) {
        return PriorityProvider.pick(p_399748_.lookupOrThrow(Registries.CAT_VARIANT).listElements(), Holder::value, p_399848_, p_399931_);
    }
}

