/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class MushroomCow
extends AbstractCow
implements Shearable {
    private static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.INT);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    private SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> p_28914_, Level p_28915_) {
        super((EntityType<? extends AbstractCow>)p_28914_, p_28915_);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_28933_, LevelReader p_28934_) {
        if (p_28934_.getBlockState(p_28933_.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return p_28934_.getPathfindingCostFromLightLevels(p_28933_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> p_218201_, LevelAccessor p_218202_, EntitySpawnReason p_360426_, BlockPos p_218204_, RandomSource p_218205_) {
        return p_218202_.getBlockState(p_218204_.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn(p_218202_, p_218204_);
    }

    @Override
    public void thunderHit(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID $$2 = p_28922_.getUUID();
        if (!$$2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
            this.lastLightningBoltUUID = $$2;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326279_) {
        super.defineSynchedData(p_326279_);
        p_326279_.define(DATA_TYPE, Variant.DEFAULT.id);
    }

    @Override
    public InteractionResult mobInteract(Player p_28941_, InteractionHand p_28942_) {
        ItemStack $$2 = p_28941_.getItemInHand(p_28942_);
        if ($$2.is(Items.BOWL) && !this.isBaby()) {
            SoundEvent $$8;
            ItemStack $$5;
            boolean $$3 = false;
            if (this.stewEffects != null) {
                $$3 = true;
                ItemStack $$4 = new ItemStack(Items.SUSPICIOUS_STEW);
                $$4.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                $$5 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack $$6 = ItemUtils.createFilledResult($$2, p_28941_, $$5, false);
            p_28941_.setItemInHand(p_28942_, $$6);
            if ($$3) {
                SoundEvent $$7 = SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY;
            } else {
                $$8 = SoundEvents.MOOSHROOM_MILK;
            }
            this.playSound($$8, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if ($$2.is(Items.SHEARS) && this.readyForShearing()) {
            Level $$3 = this.level();
            if ($$3 instanceof ServerLevel) {
                ServerLevel $$9 = (ServerLevel)$$3;
                this.shear($$9, SoundSource.PLAYERS, $$2);
                this.gameEvent(GameEvent.SHEAR, p_28941_);
                $$2.hurtAndBreak(1, p_28941_, MushroomCow.getSlotForHand(p_28942_));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == Variant.BROWN) {
            Optional<SuspiciousStewEffects> $$10 = this.getEffectsFromItemStack($$2);
            if ($$10.isEmpty()) {
                return super.mobInteract(p_28941_, p_28942_);
            }
            if (this.stewEffects != null) {
                for (int $$11 = 0; $$11 < 2; ++$$11) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                $$2.consume(1, p_28941_);
                for (int $$12 = 0; $$12 < 4; ++$$12) {
                    this.level().addParticle(ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = $$10.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_28941_, p_28942_);
    }

    @Override
    public void shear(ServerLevel p_376375_, SoundSource p_28924_, ItemStack p_373092_) {
        p_376375_.playSound(null, this, SoundEvents.MOOSHROOM_SHEAR, p_28924_, 1.0f, 1.0f);
        this.convertTo(EntityType.COW, ConversionParams.single(this, false, false), p_409325_ -> {
            p_376375_.sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(p_376375_, BuiltInLootTables.SHEAR_MOOSHROOM, p_373092_, (p_409321_, p_409322_) -> {
                for (int $$2 = 0; $$2 < p_409322_.getCount(); ++$$2) {
                    p_409321_.addFreshEntity(new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), p_409322_.copyWithCount(1)));
                }
            });
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_28944_) {
        super.addAdditionalSaveData(p_28944_);
        p_28944_.store("Type", Variant.CODEC, this.getVariant());
        p_28944_.storeNullable(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC, this.stewEffects);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_28936_) {
        super.readAdditionalSaveData(p_28936_);
        this.setVariant(p_28936_.read("Type", Variant.CODEC).orElse(Variant.DEFAULT));
        this.stewEffects = p_28936_.read(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC).orElse(null);
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack p_298333_) {
        SuspiciousEffectHolder $$1 = SuspiciousEffectHolder.tryGet(p_298333_.getItem());
        if ($$1 != null) {
            return Optional.of($$1.getSuspiciousEffects());
        }
        return Optional.empty();
    }

    private void setVariant(Variant p_360882_) {
        this.entityData.set(DATA_TYPE, p_360882_.id);
    }

    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_397806_) {
        if (p_397806_ == DataComponents.MOOSHROOM_VARIANT) {
            return MushroomCow.castComponentValue(p_397806_, this.getVariant());
        }
        return super.get(p_397806_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397987_) {
        this.applyImplicitComponentIfPresent(p_397987_, DataComponents.MOOSHROOM_VARIANT);
        super.applyImplicitComponents(p_397987_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_397577_, T p_397544_) {
        if (p_397577_ == DataComponents.MOOSHROOM_VARIANT) {
            this.setVariant(MushroomCow.castComponentValue(DataComponents.MOOSHROOM_VARIANT, p_397544_));
            return true;
        }
        return super.applyImplicitComponent(p_397577_, p_397544_);
    }

    @Override
    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel p_148942_, AgeableMob p_148943_) {
        MushroomCow $$2 = EntityType.MOOSHROOM.create(p_148942_, EntitySpawnReason.BREEDING);
        if ($$2 != null) {
            $$2.setVariant(this.getOffspringVariant((MushroomCow)p_148943_));
        }
        return $$2;
    }

    private Variant getOffspringVariant(MushroomCow p_28931_) {
        Variant $$4;
        Variant $$2;
        Variant $$1 = this.getVariant();
        if ($$1 == ($$2 = p_28931_.getVariant()) && this.random.nextInt(1024) == 0) {
            Variant $$3 = $$1 == Variant.BROWN ? Variant.RED : Variant.BROWN;
        } else {
            $$4 = this.random.nextBoolean() ? $$1 : $$2;
        }
        return $$4;
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    public static enum Variant implements StringRepresentable
    {
        RED("red", 0, Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", 1, Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final Variant DEFAULT;
        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String type;
        final int id;
        private final BlockState blockState;

        private Variant(String p_363362_, int p_397374_, BlockState p_365388_) {
            this.type = p_363362_;
            this.id = p_397374_;
            this.blockState = p_365388_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        private int id() {
            return this.id;
        }

        static Variant byId(int p_397937_) {
            return BY_ID.apply(p_397937_);
        }

        static {
            DEFAULT = RED;
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::id, Variant.values(), ByIdMap.OutOfBoundsStrategy.CLAMP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::id);
        }
    }
}

