/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHorse
extends Animal
implements HasCustomInventoryScreen,
OwnableEntity,
PlayerRideableJumping {
    public static final int CHEST_SLOT_OFFSET = 499;
    public static final int INVENTORY_SLOT_OFFSET = 500;
    public static final double BREEDING_CROSS_FACTOR = 0.15;
    private static final float MIN_MOVEMENT_SPEED = (float)AbstractHorse.generateSpeed(() -> 0.0);
    private static final float MAX_MOVEMENT_SPEED = (float)AbstractHorse.generateSpeed(() -> 1.0);
    private static final float MIN_JUMP_STRENGTH = (float)AbstractHorse.generateJumpStrength(() -> 0.0);
    private static final float MAX_JUMP_STRENGTH = (float)AbstractHorse.generateJumpStrength(() -> 1.0);
    private static final float MIN_HEALTH = AbstractHorse.generateMaxHealth(p_272505_ -> 0);
    private static final float MAX_HEALTH = AbstractHorse.generateMaxHealth(p_272504_ -> p_272504_ - 1);
    private static final float BACKWARDS_MOVE_SPEED_FACTOR = 0.25f;
    private static final float SIDEWAYS_MOVE_SPEED_FACTOR = 0.5f;
    private static final TargetingConditions.Selector PARENT_HORSE_SELECTOR = (p_375849_, p_375850_) -> {
        AbstractHorse $$2;
        return p_375849_ instanceof AbstractHorse && ($$2 = (AbstractHorse)p_375849_).isBred();
    };
    private static final TargetingConditions MOMMY_TARGETING = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().selector(PARENT_HORSE_SELECTOR);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(AbstractHorse.class, EntityDataSerializers.BYTE);
    private static final int FLAG_TAME = 2;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    public static final int INVENTORY_ROWS = 3;
    private static final int DEFAULT_TEMPER = 0;
    private static final boolean DEFAULT_EATING_HAYSTACK = false;
    private static final boolean DEFAULT_BRED = false;
    private static final boolean DEFAULT_TAME = false;
    private int eatingCounter;
    private int mouthCounter;
    private int standCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean isJumping;
    protected SimpleContainer inventory;
    protected int temper = 0;
    protected float playerJumpPendingScale;
    protected boolean allowStandSliding;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    @Nullable
    private EntityReference<LivingEntity> owner;

    protected AbstractHorse(EntityType<? extends AbstractHorse> p_30531_, Level p_30532_) {
        super((EntityType<? extends Animal>)p_30531_, p_30532_);
        this.createInventory();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.2));
        this.goalSelector.addGoal(1, new RunAroundLikeCrazyGoal(this, 1.2));
        this.goalSelector.addGoal(2, new BreedGoal(this, 1.0, AbstractHorse.class));
        this.goalSelector.addGoal(4, new FollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(6, new WaterAvoidingRandomStrollGoal(this, 0.7));
        this.goalSelector.addGoal(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        if (this.canPerformRearing()) {
            this.goalSelector.addGoal(9, new RandomStandGoal(this));
        }
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(3, new TemptGoal(this, 1.25, p_335269_ -> p_335269_.is(ItemTags.HORSE_TEMPT_ITEMS), false));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326254_) {
        super.defineSynchedData(p_326254_);
        p_326254_.define(DATA_ID_FLAGS, (byte)0);
    }

    protected boolean getFlag(int p_30648_) {
        return (this.entityData.get(DATA_ID_FLAGS) & p_30648_) != 0;
    }

    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte $$2 = this.entityData.get(DATA_ID_FLAGS);
        if (p_30599_) {
            this.entityData.set(DATA_ID_FLAGS, (byte)($$2 | p_30598_));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)($$2 & ~p_30598_));
        }
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Override
    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity p_393827_) {
        this.owner = p_393827_ != null ? new EntityReference<LivingEntity>(p_393827_) : null;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setTamed(boolean p_30652_) {
        this.setFlag(2, p_30652_);
    }

    public void setIsJumping(boolean p_30656_) {
        this.isJumping = p_30656_;
    }

    @Override
    public boolean handleLeashAtDistance(Entity p_352072_, float p_352350_) {
        if (p_352350_ > 6.0f && this.isEating()) {
            this.setEating(false);
        }
        return true;
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean p_30658_) {
        this.setFlag(8, p_30658_);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_397737_) {
        if (p_397737_ == EquipmentSlot.SADDLE) {
            return this.isAlive() && !this.isBaby() && this.isTamed();
        }
        return super.canUseSlot(p_397737_);
    }

    public void equipBodyArmor(Player p_324210_, ItemStack p_323522_) {
        if (this.isEquippableInSlot(p_323522_, EquipmentSlot.BODY)) {
            this.setBodyArmorItem(p_323522_.consumeAndReturn(1, p_324210_));
        }
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371599_) {
        return (p_371599_ == EquipmentSlot.BODY || p_371599_ == EquipmentSlot.SADDLE) && this.isTamed() || super.canDispenserEquipIntoSlot(p_371599_);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int p_30650_) {
        this.temper = p_30650_;
    }

    public int modifyTemper(int p_30654_) {
        int $$1 = Mth.clamp(this.getTemper() + p_30654_, 0, this.getMaxTemper());
        this.setTemper($$1);
        return $$1;
    }

    @Override
    public boolean isPushable() {
        return !this.isVehicle();
    }

    private void eating() {
        SoundEvent $$0;
        this.openMouth();
        if (!this.isSilent() && ($$0 = this.getEatingSound()) != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), $$0, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean causeFallDamage(double p_397025_, float p_149499_, DamageSource p_149501_) {
        int $$3;
        if (p_397025_ > 1.0) {
            this.playSound(SoundEvents.HORSE_LAND, 0.4f, 1.0f);
        }
        if (($$3 = this.calculateFallDamage(p_397025_, p_149499_)) <= 0) {
            return false;
        }
        this.hurt(p_149501_, $$3);
        this.propagateFallToPassengers(p_397025_, p_149499_, p_149501_);
        this.playBlockFallSound();
        return true;
    }

    public final int getInventorySize() {
        return AbstractHorse.getInventorySize(this.getInventoryColumns());
    }

    public static int getInventorySize(int p_352314_) {
        return p_352314_ * 3;
    }

    protected void createInventory() {
        SimpleContainer $$0 = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if ($$0 != null) {
            int $$1 = Math.min($$0.getContainerSize(), this.inventory.getContainerSize());
            for (int $$2 = 0; $$2 < $$1; ++$$2) {
                ItemStack $$3 = $$0.getItem($$2);
                if ($$3.isEmpty()) continue;
                this.inventory.setItem($$2, $$3.copy());
            }
        }
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot p_397157_, ItemStack p_397978_, Equippable p_397221_) {
        if (p_397157_ == EquipmentSlot.SADDLE) {
            return SoundEvents.HORSE_SADDLE;
        }
        return super.getEquipSound(p_397157_, p_397978_, p_397221_);
    }

    @Override
    public boolean hurtServer(ServerLevel p_376833_, DamageSource p_376090_, float p_376270_) {
        boolean $$3 = super.hurtServer(p_376833_, p_376090_, p_376270_);
        if ($$3 && this.random.nextInt(3) == 0) {
            this.standIfPossible();
        }
        return $$3;
    }

    protected boolean canPerformRearing() {
        return true;
    }

    @Nullable
    protected SoundEvent getEatingSound() {
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        return null;
    }

    @Override
    protected void playStepSound(BlockPos p_30584_, BlockState p_30585_) {
        if (p_30585_.liquid()) {
            return;
        }
        BlockState $$2 = this.level().getBlockState(p_30584_.above());
        SoundType $$3 = p_30585_.getSoundType();
        if ($$2.is(Blocks.SNOW)) {
            $$3 = $$2.getSoundType();
        }
        if (this.isVehicle() && this.canGallop) {
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                this.playGallopSound($$3);
            } else if (this.gallopSoundCounter <= 5) {
                this.playSound(SoundEvents.HORSE_STEP_WOOD, $$3.getVolume() * 0.15f, $$3.getPitch());
            }
        } else if (this.isWoodSoundType($$3)) {
            this.playSound(SoundEvents.HORSE_STEP_WOOD, $$3.getVolume() * 0.15f, $$3.getPitch());
        } else {
            this.playSound(SoundEvents.HORSE_STEP, $$3.getVolume() * 0.15f, $$3.getPitch());
        }
    }

    private boolean isWoodSoundType(SoundType p_278280_) {
        return p_278280_ == SoundType.WOOD || p_278280_ == SoundType.NETHER_WOOD || p_278280_ == SoundType.STEM || p_278280_ == SoundType.CHERRY_WOOD || p_278280_ == SoundType.BAMBOO_WOOD;
    }

    protected void playGallopSound(SoundType p_30560_) {
        this.playSound(SoundEvents.HORSE_GALLOP, p_30560_.getVolume() * 0.15f, p_30560_.getPitch());
    }

    public static AttributeSupplier.Builder createBaseHorseAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.JUMP_STRENGTH, 0.7).add(Attributes.MAX_HEALTH, 53.0).add(Attributes.MOVEMENT_SPEED, 0.225f).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.SAFE_FALL_DISTANCE, 6.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.5);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 400;
    }

    @Override
    public void openCustomInventoryScreen(Player p_218808_) {
        if (!this.level().isClientSide && (!this.isVehicle() || this.hasPassenger(p_218808_)) && this.isTamed()) {
            p_218808_.openHorseInventory(this, this.inventory);
        }
    }

    public InteractionResult fedFood(Player p_30581_, ItemStack p_30582_) {
        boolean $$2 = this.handleEating(p_30581_, p_30582_);
        if ($$2) {
            p_30582_.consume(1, p_30581_);
        }
        return $$2 || this.level().isClientSide ? InteractionResult.SUCCESS_SERVER : InteractionResult.PASS;
    }

    protected boolean handleEating(Player p_30593_, ItemStack p_30594_) {
        boolean $$2 = false;
        float $$3 = 0.0f;
        int $$4 = 0;
        int $$5 = 0;
        if (p_30594_.is(Items.WHEAT)) {
            $$3 = 2.0f;
            $$4 = 20;
            $$5 = 3;
        } else if (p_30594_.is(Items.SUGAR)) {
            $$3 = 1.0f;
            $$4 = 30;
            $$5 = 3;
        } else if (p_30594_.is(Blocks.HAY_BLOCK.asItem())) {
            $$3 = 20.0f;
            $$4 = 180;
        } else if (p_30594_.is(Items.APPLE)) {
            $$3 = 3.0f;
            $$4 = 60;
            $$5 = 3;
        } else if (p_30594_.is(Items.GOLDEN_CARROT)) {
            $$3 = 4.0f;
            $$4 = 60;
            $$5 = 5;
            if (!this.level().isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                $$2 = true;
                this.setInLove(p_30593_);
            }
        } else if (p_30594_.is(Items.GOLDEN_APPLE) || p_30594_.is(Items.ENCHANTED_GOLDEN_APPLE)) {
            $$3 = 10.0f;
            $$4 = 240;
            $$5 = 10;
            if (!this.level().isClientSide && this.isTamed() && this.getAge() == 0 && !this.isInLove()) {
                $$2 = true;
                this.setInLove(p_30593_);
            }
        }
        if (this.getHealth() < this.getMaxHealth() && $$3 > 0.0f) {
            this.heal($$3);
            $$2 = true;
        }
        if (this.isBaby() && $$4 > 0) {
            this.level().addParticle(ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide) {
                this.ageUp($$4);
                $$2 = true;
            }
        }
        if (!($$5 <= 0 || !$$2 && this.isTamed() || this.getTemper() >= this.getMaxTemper() || this.level().isClientSide)) {
            this.modifyTemper($$5);
            $$2 = true;
        }
        if ($$2) {
            this.eating();
            this.gameEvent(GameEvent.EAT);
        }
        return $$2;
    }

    protected void doPlayerRide(Player p_30634_) {
        this.setEating(false);
        this.setStanding(false);
        if (!this.level().isClientSide) {
            p_30634_.setYRot(this.getYRot());
            p_30634_.setXRot(this.getXRot());
            p_30634_.startRiding(this);
        }
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() && this.isVehicle() && this.isSaddled() || this.isEating() || this.isStanding();
    }

    @Override
    public boolean isFood(ItemStack p_30644_) {
        return p_30644_.is(ItemTags.HORSE_FOOD);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    protected void dropEquipment(ServerLevel p_376591_) {
        super.dropEquipment(p_376591_);
        if (this.inventory == null) {
            return;
        }
        for (int $$1 = 0; $$1 < this.inventory.getContainerSize(); ++$$1) {
            ItemStack $$2 = this.inventory.getItem($$1);
            if ($$2.isEmpty() || EnchantmentHelper.has($$2, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(p_376591_, $$2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void aiStep() {
        void $$1;
        block9: {
            block8: {
                if (this.random.nextInt(200) == 0) {
                    this.moveTail();
                }
                super.aiStep();
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block8;
                ServerLevel $$0 = (ServerLevel)level;
                if (this.isAlive()) break block9;
            }
            return;
        }
        if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
            this.heal(1.0f);
        }
        if (this.canEatGrass()) {
            if (!this.isEating() && !this.isVehicle() && this.random.nextInt(300) == 0 && $$1.getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                this.setEating(true);
            }
            if (this.isEating() && ++this.eatingCounter > 50) {
                this.eatingCounter = 0;
                this.setEating(false);
            }
        }
        this.followMommy((ServerLevel)$$1);
    }

    protected void followMommy(ServerLevel p_376517_) {
        AbstractHorse $$1;
        if (this.isBred() && this.isBaby() && !this.isEating() && ($$1 = p_376517_.getNearestEntity(AbstractHorse.class, MOMMY_TARGETING, this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(16.0))) != null && this.distanceToSqr($$1) > 4.0) {
            this.navigation.createPath($$1, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
            this.setFlag(64, false);
        }
        if (this.isEffectiveAi() && this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
            this.setStanding(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.eatAnimO = this.eatAnim;
        if (this.isEating()) {
            this.eatAnim += (1.0f - this.eatAnim) * 0.4f + 0.05f;
            if (this.eatAnim > 1.0f) {
                this.eatAnim = 1.0f;
            }
        } else {
            this.eatAnim += (0.0f - this.eatAnim) * 0.4f - 0.05f;
            if (this.eatAnim < 0.0f) {
                this.eatAnim = 0.0f;
            }
        }
        this.standAnimO = this.standAnim;
        if (this.isStanding()) {
            this.eatAnimO = this.eatAnim = 0.0f;
            this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
            if (this.standAnim > 1.0f) {
                this.standAnim = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
            if (this.standAnim < 0.0f) {
                this.standAnim = 0.0f;
            }
        }
        this.mouthAnimO = this.mouthAnim;
        if (this.getFlag(64)) {
            this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
            if (this.mouthAnim > 1.0f) {
                this.mouthAnim = 1.0f;
            }
        } else {
            this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
            if (this.mouthAnim < 0.0f) {
                this.mouthAnim = 0.0f;
            }
        }
    }

    @Override
    public InteractionResult mobInteract(Player p_252289_, InteractionHand p_248927_) {
        if (this.isVehicle() || this.isBaby()) {
            return super.mobInteract(p_252289_, p_248927_);
        }
        if (this.isTamed() && p_252289_.isSecondaryUseActive()) {
            this.openCustomInventoryScreen(p_252289_);
            return InteractionResult.SUCCESS;
        }
        ItemStack $$2 = p_252289_.getItemInHand(p_248927_);
        if (!$$2.isEmpty()) {
            InteractionResult $$3 = $$2.interactLivingEntity(p_252289_, this, p_248927_);
            if ($$3.consumesAction()) {
                return $$3;
            }
            if (this.isEquippableInSlot($$2, EquipmentSlot.BODY) && !this.isWearingBodyArmor()) {
                this.equipBodyArmor(p_252289_, $$2);
                return InteractionResult.SUCCESS;
            }
        }
        this.doPlayerRide(p_252289_);
        return InteractionResult.SUCCESS;
    }

    private void openMouth() {
        if (!this.level().isClientSide) {
            this.mouthCounter = 1;
            this.setFlag(64, true);
        }
    }

    public void setEating(boolean p_30662_) {
        this.setFlag(16, p_30662_);
    }

    public void setStanding(boolean p_30666_) {
        if (p_30666_) {
            this.setEating(false);
        }
        this.setFlag(32, p_30666_);
    }

    @Nullable
    public SoundEvent getAmbientStandSound() {
        return this.getAmbientSound();
    }

    public void standIfPossible() {
        if (this.canPerformRearing() && this.isEffectiveAi()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    public void makeMad() {
        if (!this.isStanding()) {
            this.standIfPossible();
            this.makeSound(this.getAngrySound());
        }
    }

    public boolean tameWithName(Player p_30638_) {
        this.setOwner(p_30638_);
        this.setTamed(true);
        if (p_30638_ instanceof ServerPlayer) {
            CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)p_30638_, this);
        }
        this.level().broadcastEntityEvent(this, (byte)7);
        return true;
    }

    @Override
    protected void tickRidden(Player p_278233_, Vec3 p_275693_) {
        super.tickRidden(p_278233_, p_275693_);
        Vec2 $$2 = this.getRiddenRotation(p_278233_);
        this.setRot($$2.y, $$2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        if (this.isLocalInstanceAuthoritative()) {
            if (p_275693_.z <= 0.0) {
                this.gallopSoundCounter = 0;
            }
            if (this.onGround()) {
                this.setIsJumping(false);
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                    this.executeRidersJump(this.playerJumpPendingScale, p_275693_);
                }
                this.playerJumpPendingScale = 0.0f;
            }
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity p_275502_) {
        return new Vec2(p_275502_.getXRot() * 0.5f, p_275502_.getYRot());
    }

    @Override
    protected Vec3 getRiddenInput(Player p_278278_, Vec3 p_275506_) {
        if (this.onGround() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
            return Vec3.ZERO;
        }
        float $$2 = p_278278_.xxa * 0.5f;
        float $$3 = p_278278_.zza;
        if ($$3 <= 0.0f) {
            $$3 *= 0.25f;
        }
        return new Vec3($$2, 0.0, $$3);
    }

    @Override
    protected float getRiddenSpeed(Player p_278336_) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double $$2 = this.getJumpPower(p_248808_);
        Vec3 $$3 = this.getDeltaMovement();
        this.setDeltaMovement($$3.x, $$2, $$3.z);
        this.setIsJumping(true);
        this.hasImpulse = true;
        if (p_275435_.z > 0.0) {
            float $$4 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float $$5 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            this.setDeltaMovement(this.getDeltaMovement().add(-0.4f * $$4 * p_248808_, 0.0, 0.4f * $$5 * p_248808_));
        }
    }

    protected void playJumpSound() {
        this.playSound(SoundEvents.HORSE_JUMP, 0.4f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_30589_) {
        super.addAdditionalSaveData(p_30589_);
        p_30589_.putBoolean("EatingHaystack", this.isEating());
        p_30589_.putBoolean("Bred", this.isBred());
        p_30589_.putInt("Temper", this.getTemper());
        p_30589_.putBoolean("Tame", this.isTamed());
        if (this.owner != null) {
            this.owner.store(p_30589_, "Owner");
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_30565_) {
        super.readAdditionalSaveData(p_30565_);
        this.setEating(p_30565_.getBooleanOr("EatingHaystack", false));
        this.setBred(p_30565_.getBooleanOr("Bred", false));
        this.setTemper(p_30565_.getIntOr("Temper", 0));
        this.setTamed(p_30565_.getBooleanOr("Tame", false));
        this.owner = EntityReference.readWithOldOwnerConversion(p_30565_, "Owner", this.level());
    }

    @Override
    public boolean canMate(Animal p_30553_) {
        return false;
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && this.isTamed() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149506_, AgeableMob p_149507_) {
        return null;
    }

    protected void setOffspringAttributes(AgeableMob p_149509_, AbstractHorse p_149510_) {
        this.setOffspringAttribute(p_149509_, p_149510_, Attributes.MAX_HEALTH, MIN_HEALTH, MAX_HEALTH);
        this.setOffspringAttribute(p_149509_, p_149510_, Attributes.JUMP_STRENGTH, MIN_JUMP_STRENGTH, MAX_JUMP_STRENGTH);
        this.setOffspringAttribute(p_149509_, p_149510_, Attributes.MOVEMENT_SPEED, MIN_MOVEMENT_SPEED, MAX_MOVEMENT_SPEED);
    }

    private void setOffspringAttribute(AgeableMob p_273163_, AbstractHorse p_273784_, Holder<Attribute> p_316573_, double p_272663_, double p_273405_) {
        double $$5 = AbstractHorse.createOffspringAttribute(this.getAttributeBaseValue(p_316573_), p_273163_.getAttributeBaseValue(p_316573_), p_272663_, p_273405_, this.random);
        p_273784_.getAttribute(p_316573_).setBaseValue($$5);
    }

    static double createOffspringAttribute(double p_272685_, double p_273709_, double p_273376_, double p_273030_, RandomSource p_272743_) {
        double $$8;
        if (p_273030_ <= p_273376_) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        p_272685_ = Mth.clamp(p_272685_, p_273376_, p_273030_);
        p_273709_ = Mth.clamp(p_273709_, p_273376_, p_273030_);
        double $$5 = 0.15 * (p_273030_ - p_273376_);
        double $$7 = (p_272685_ + p_273709_) / 2.0;
        double $$6 = Math.abs(p_272685_ - p_273709_) + $$5 * 2.0;
        double $$9 = $$7 + $$6 * ($$8 = (p_272743_.nextDouble() + p_272743_.nextDouble() + p_272743_.nextDouble()) / 3.0 - 0.5);
        if ($$9 > p_273030_) {
            double $$10 = $$9 - p_273030_;
            return p_273030_ - $$10;
        }
        if ($$9 < p_273376_) {
            double $$11 = p_273376_ - $$9;
            return p_273376_ + $$11;
        }
        return $$9;
    }

    public float getEatAnim(float p_30664_) {
        return Mth.lerp(p_30664_, this.eatAnimO, this.eatAnim);
    }

    public float getStandAnim(float p_30668_) {
        return Mth.lerp(p_30668_, this.standAnimO, this.standAnim);
    }

    public float getMouthAnim(float p_30534_) {
        return Mth.lerp(p_30534_, this.mouthAnimO, this.mouthAnim);
    }

    @Override
    public void onPlayerJump(int p_30591_) {
        if (!this.isSaddled()) {
            return;
        }
        if (p_30591_ < 0) {
            p_30591_ = 0;
        } else {
            this.allowStandSliding = true;
            this.standIfPossible();
        }
        this.playerJumpPendingScale = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
    }

    @Override
    public boolean canJump() {
        return this.isSaddled();
    }

    @Override
    public void handleStartJump(int p_30574_) {
        this.allowStandSliding = true;
        this.standIfPossible();
        this.playJumpSound();
    }

    @Override
    public void handleStopJump() {
    }

    protected void spawnTamingParticles(boolean p_30670_) {
        SimpleParticleType $$1 = p_30670_ ? ParticleTypes.HEART : ParticleTypes.SMOKE;
        for (int $$2 = 0; $$2 < 7; ++$$2) {
            double $$3 = this.random.nextGaussian() * 0.02;
            double $$4 = this.random.nextGaussian() * 0.02;
            double $$5 = this.random.nextGaussian() * 0.02;
            this.level().addParticle($$1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), $$3, $$4, $$5);
        }
    }

    @Override
    public void handleEntityEvent(byte p_30541_) {
        if (p_30541_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_30541_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(p_30541_);
        }
    }

    @Override
    protected void positionRider(Entity p_289569_, Entity.MoveFunction p_289558_) {
        super.positionRider(p_289569_, p_289558_);
        if (p_289569_ instanceof LivingEntity) {
            ((LivingEntity)p_289569_).yBodyRot = this.yBodyRot;
        }
    }

    protected static float generateMaxHealth(IntUnaryOperator p_272695_) {
        return 15.0f + (float)p_272695_.applyAsInt(8) + (float)p_272695_.applyAsInt(9);
    }

    protected static double generateJumpStrength(DoubleSupplier p_272718_) {
        return (double)0.4f + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2;
    }

    protected static double generateSpeed(DoubleSupplier p_273691_) {
        return ((double)0.45f + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public SlotAccess getSlot(int p_149514_) {
        int $$1 = p_149514_ - 500;
        if ($$1 >= 0 && $$1 < this.inventory.getContainerSize()) {
            return SlotAccess.forContainer(this.inventory, $$1);
        }
        return super.getSlot(p_149514_);
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player $$0 = (Player)entity;
            return $$0;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 p_30562_, LivingEntity p_30563_) {
        double $$2 = this.getX() + p_30562_.x;
        double $$3 = this.getBoundingBox().minY;
        double $$4 = this.getZ() + p_30562_.z;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        block0: for (Pose $$6 : p_30563_.getDismountPoses()) {
            $$5.set($$2, $$3, $$4);
            double $$7 = this.getBoundingBox().maxY + 0.75;
            do {
                double $$8 = this.level().getBlockFloorHeight($$5);
                if ((double)$$5.getY() + $$8 > $$7) continue block0;
                if (DismountHelper.isBlockFloorValid($$8)) {
                    AABB $$9 = p_30563_.getLocalBoundsForPose($$6);
                    Vec3 $$10 = new Vec3($$2, (double)$$5.getY() + $$8, $$4);
                    if (DismountHelper.canDismountTo(this.level(), p_30563_, $$9.move($$10))) {
                        p_30563_.setPose($$6);
                        return $$10;
                    }
                }
                $$5.move(Direction.UP);
            } while ((double)$$5.getY() < $$7);
        }
        return null;
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity p_30576_) {
        Vec3 $$1 = AbstractHorse.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_30576_.getBbWidth(), this.getYRot() + (p_30576_.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f));
        Vec3 $$2 = this.getDismountLocationInDirection($$1, p_30576_);
        if ($$2 != null) {
            return $$2;
        }
        Vec3 $$3 = AbstractHorse.getCollisionHorizontalEscapeVector(this.getBbWidth(), p_30576_.getBbWidth(), this.getYRot() + (p_30576_.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f));
        Vec3 $$4 = this.getDismountLocationInDirection($$3, p_30576_);
        if ($$4 != null) {
            return $$4;
        }
        return this.position();
    }

    protected void randomizeAttributes(RandomSource p_218804_) {
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_30555_, DifficultyInstance p_30556_, EntitySpawnReason p_363523_, @Nullable SpawnGroupData p_30558_) {
        if (p_30558_ == null) {
            p_30558_ = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        this.randomizeAttributes(p_30555_.getRandom());
        return super.finalizeSpawn(p_30555_, p_30556_, p_363523_, p_30558_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public int getAmbientStandInterval() {
        return this.getAmbientSoundInterval();
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity p_295612_, EntityDimensions p_296023_, float p_295509_) {
        return super.getPassengerAttachmentPoint(p_295612_, p_296023_, p_295509_).add(new Vec3(0.0, 0.15 * (double)this.standAnimO * (double)p_295509_, -0.7 * (double)this.standAnimO * (double)p_295509_).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    public int getInventoryColumns() {
        return 0;
    }
}

