/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;

public abstract class HangingEntity
extends BlockAttachedEntity {
    protected static final Predicate<Entity> HANGING_ENTITY = p_31734_ -> p_31734_ instanceof HangingEntity;
    protected Direction direction = Direction.SOUTH;

    protected HangingEntity(EntityType<? extends HangingEntity> p_31703_, Level p_31704_) {
        super((EntityType<? extends BlockAttachedEntity>)p_31703_, p_31704_);
    }

    protected HangingEntity(EntityType<? extends HangingEntity> p_31706_, Level p_31707_, BlockPos p_31708_) {
        this(p_31706_, p_31707_);
        this.pos = p_31708_;
    }

    protected void setDirection(Direction p_31728_) {
        Objects.requireNonNull(p_31728_);
        Validate.isTrue((boolean)p_31728_.getAxis().isHorizontal());
        this.direction = p_31728_;
        this.setYRot(this.direction.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected final void recalculateBoundingBox() {
        if (this.direction == null) {
            return;
        }
        AABB $$0 = this.calculateBoundingBox(this.pos, this.direction);
        Vec3 $$1 = $$0.getCenter();
        this.setPosRaw($$1.x, $$1.y, $$1.z);
        this.setBoundingBox($$0);
    }

    protected abstract AABB calculateBoundingBox(BlockPos var1, Direction var2);

    @Override
    public boolean survives() {
        if (!this.level().noCollision(this)) {
            return false;
        }
        boolean $$0 = BlockPos.betweenClosedStream(this.calculateSupportBox()).allMatch(p_409354_ -> {
            BlockState $$1 = this.level().getBlockState((BlockPos)p_409354_);
            return $$1.isSolid() || DiodeBlock.isDiode($$1);
        });
        if (!$$0) {
            return false;
        }
        return this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    protected AABB calculateSupportBox() {
        return this.getBoundingBox().move(this.direction.step().mul(-0.5f)).deflate(1.0E-7);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public abstract void playPlacementSound();

    @Override
    public ItemEntity spawnAtLocation(ServerLevel p_376865_, ItemStack p_31722_, float p_31723_) {
        ItemEntity $$3 = new ItemEntity(this.level(), this.getX() + (double)((float)this.direction.getStepX() * 0.15f), this.getY() + (double)p_31723_, this.getZ() + (double)((float)this.direction.getStepZ() * 0.15f), p_31722_);
        $$3.setDefaultPickUpDelay();
        this.level().addFreshEntity($$3);
        return $$3;
    }

    @Override
    public float rotate(Rotation p_31727_) {
        if (this.direction.getAxis() != Direction.Axis.Y) {
            switch (p_31727_) {
                case CLOCKWISE_180: {
                    this.direction = this.direction.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.direction = this.direction.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    this.direction = this.direction.getClockWise();
                    break;
                }
            }
        }
        float $$1 = Mth.wrapDegrees(this.getYRot());
        return switch (p_31727_) {
            case Rotation.CLOCKWISE_180 -> $$1 + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> $$1 + 90.0f;
            case Rotation.CLOCKWISE_90 -> $$1 + 270.0f;
            default -> $$1;
        };
    }

    @Override
    public float mirror(Mirror p_31725_) {
        return this.rotate(p_31725_.getRotation(this.direction));
    }
}

