/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Inventory
implements Container,
Nameable {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    public static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final Int2ObjectMap<EquipmentSlot> EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap(Map.of(EquipmentSlot.FEET.getIndex(36), EquipmentSlot.FEET, EquipmentSlot.LEGS.getIndex(36), EquipmentSlot.LEGS, EquipmentSlot.CHEST.getIndex(36), EquipmentSlot.CHEST, EquipmentSlot.HEAD.getIndex(36), EquipmentSlot.HEAD, 40, EquipmentSlot.OFFHAND));
    private final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    private int selected;
    public final Player player;
    private final EntityEquipment equipment;
    private int timesChanged;

    public Inventory(Player p_35983_, EntityEquipment p_401828_) {
        this.player = p_35983_;
        this.equipment = p_401828_;
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int p_401904_) {
        if (!Inventory.isHotbarSlot(p_401904_)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.selected = p_401904_;
    }

    public ItemStack getSelectedItem() {
        return this.items.get(this.selected);
    }

    public ItemStack setSelectedItem(ItemStack p_401838_) {
        return this.items.set(this.selected, p_401838_);
    }

    public static int getSelectionSize() {
        return 9;
    }

    public NonNullList<ItemStack> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(ItemStack p_36015_, ItemStack p_36016_) {
        return !p_36015_.isEmpty() && ItemStack.isSameItemSameComponents(p_36015_, p_36016_) && p_36015_.isStackable() && p_36015_.getCount() < this.getMaxStackSize(p_36015_);
    }

    public int getFreeSlot() {
        for (int $$0 = 0; $$0 < this.items.size(); ++$$0) {
            if (!this.items.get($$0).isEmpty()) continue;
            return $$0;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack p_383009_) {
        int $$1;
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        if (!this.items.get(this.selected).isEmpty() && ($$1 = this.getFreeSlot()) != -1) {
            this.items.set($$1, this.items.get(this.selected));
        }
        this.items.set(this.selected, p_383009_);
    }

    public void pickSlot(int p_36039_) {
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        ItemStack $$1 = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(p_36039_));
        this.items.set(p_36039_, $$1);
    }

    public static boolean isHotbarSlot(int p_36046_) {
        return p_36046_ >= 0 && p_36046_ < 9;
    }

    public int findSlotMatchingItem(ItemStack p_36031_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (this.items.get($$1).isEmpty() || !ItemStack.isSameItemSameComponents(p_36031_, this.items.get($$1))) continue;
            return $$1;
        }
        return -1;
    }

    public static boolean isUsableForCrafting(ItemStack p_365004_) {
        return !p_365004_.isDamaged() && !p_365004_.isEnchanted() && !p_365004_.has(DataComponents.CUSTOM_NAME);
    }

    public int findSlotMatchingCraftingIngredient(Holder<Item> p_363103_, ItemStack p_390604_) {
        for (int $$2 = 0; $$2 < this.items.size(); ++$$2) {
            ItemStack $$3 = this.items.get($$2);
            if ($$3.isEmpty() || !$$3.is(p_363103_) || !Inventory.isUsableForCrafting($$3) || !p_390604_.isEmpty() && !ItemStack.isSameItemSameComponents(p_390604_, $$3)) continue;
            return $$2;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        for (int $$0 = 0; $$0 < 9; ++$$0) {
            int $$1 = (this.selected + $$0) % 9;
            if (!this.items.get($$1).isEmpty()) continue;
            return $$1;
        }
        for (int $$2 = 0; $$2 < 9; ++$$2) {
            int $$3 = (this.selected + $$2) % 9;
            if (this.items.get($$3).isEnchanted()) continue;
            return $$3;
        }
        return this.selected;
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> p_36023_, int p_36024_, Container p_36025_) {
        int $$3 = 0;
        boolean $$4 = p_36024_ == 0;
        $$3 += ContainerHelper.clearOrCountMatchingItems(this, p_36023_, p_36024_ - $$3, $$4);
        $$3 += ContainerHelper.clearOrCountMatchingItems(p_36025_, p_36023_, p_36024_ - $$3, $$4);
        ItemStack $$5 = this.player.containerMenu.getCarried();
        $$3 += ContainerHelper.clearOrCountMatchingItems($$5, p_36023_, p_36024_ - $$3, $$4);
        if ($$5.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return $$3;
    }

    private int addResource(ItemStack p_36067_) {
        int $$1 = this.getSlotWithRemainingSpace(p_36067_);
        if ($$1 == -1) {
            $$1 = this.getFreeSlot();
        }
        if ($$1 == -1) {
            return p_36067_.getCount();
        }
        return this.addResource($$1, p_36067_);
    }

    private int addResource(int p_36048_, ItemStack p_36049_) {
        int $$4;
        int $$5;
        int $$2 = p_36049_.getCount();
        ItemStack $$3 = this.getItem(p_36048_);
        if ($$3.isEmpty()) {
            $$3 = p_36049_.copyWithCount(0);
            this.setItem(p_36048_, $$3);
        }
        if (($$5 = Math.min($$2, $$4 = this.getMaxStackSize($$3) - $$3.getCount())) == 0) {
            return $$2;
        }
        $$3.grow($$5);
        $$3.setPopTime(5);
        return $$2 -= $$5;
    }

    public int getSlotWithRemainingSpace(ItemStack p_36051_) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), p_36051_)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), p_36051_)) {
            return 40;
        }
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (!this.hasRemainingSpaceForItem(this.items.get($$1), p_36051_)) continue;
            return $$1;
        }
        return -1;
    }

    public void tick() {
        for (int $$0 = 0; $$0 < this.items.size(); ++$$0) {
            ItemStack $$1 = this.getItem($$0);
            if ($$1.isEmpty()) continue;
            $$1.inventoryTick(this.player.level(), this.player, $$0 == this.selected ? EquipmentSlot.MAINHAND : null);
        }
    }

    public boolean add(ItemStack p_36055_) {
        return this.add(-1, p_36055_);
    }

    public boolean add(int p_36041_, ItemStack p_36042_) {
        if (p_36042_.isEmpty()) {
            return false;
        }
        try {
            if (!p_36042_.isDamaged()) {
                int $$2;
                do {
                    $$2 = p_36042_.getCount();
                    if (p_36041_ == -1) {
                        p_36042_.setCount(this.addResource(p_36042_));
                        continue;
                    }
                    p_36042_.setCount(this.addResource(p_36041_, p_36042_));
                } while (!p_36042_.isEmpty() && p_36042_.getCount() < $$2);
                if (p_36042_.getCount() == $$2 && this.player.hasInfiniteMaterials()) {
                    p_36042_.setCount(0);
                    return true;
                }
                return p_36042_.getCount() < $$2;
            }
            if (p_36041_ == -1) {
                p_36041_ = this.getFreeSlot();
            }
            if (p_36041_ >= 0) {
                this.items.set(p_36041_, p_36042_.copyAndClear());
                this.items.get(p_36041_).setPopTime(5);
                return true;
            }
            if (this.player.hasInfiniteMaterials()) {
                p_36042_.setCount(0);
                return true;
            }
            return false;
        }
        catch (Throwable $$3) {
            CrashReport $$4 = CrashReport.forThrowable($$3, "Adding item to inventory");
            CrashReportCategory $$5 = $$4.addCategory("Item being added");
            $$5.setDetail("Item ID", Item.getId(p_36042_.getItem()));
            $$5.setDetail("Item data", p_36042_.getDamageValue());
            $$5.setDetail("Item name", () -> p_36042_.getHoverName().getString());
            throw new ReportedException($$4);
        }
    }

    public void placeItemBackInInventory(ItemStack p_150080_) {
        this.placeItemBackInInventory(p_150080_, true);
    }

    public void placeItemBackInInventory(ItemStack p_150077_, boolean p_150078_) {
        while (!p_150077_.isEmpty()) {
            Player player;
            int $$2 = this.getSlotWithRemainingSpace(p_150077_);
            if ($$2 == -1) {
                $$2 = this.getFreeSlot();
            }
            if ($$2 == -1) {
                this.player.drop(p_150077_, false);
                break;
            }
            int $$3 = p_150077_.getMaxStackSize() - this.getItem($$2).getCount();
            if (!this.add($$2, p_150077_.split($$3)) || !p_150078_ || !((player = this.player) instanceof ServerPlayer)) continue;
            ServerPlayer $$4 = (ServerPlayer)player;
            $$4.connection.send(this.createInventoryUpdatePacket($$2));
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int p_365327_) {
        return new ClientboundSetPlayerInventoryPacket(p_365327_, this.getItem(p_365327_).copy());
    }

    @Override
    public ItemStack removeItem(int p_35993_, int p_35994_) {
        ItemStack $$3;
        if (p_35993_ < this.items.size()) {
            return ContainerHelper.removeItem(this.items, p_35993_, p_35994_);
        }
        EquipmentSlot $$2 = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(p_35993_);
        if ($$2 != null && !($$3 = this.equipment.get($$2)).isEmpty()) {
            return $$3.split(p_35994_);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack p_36058_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (this.items.get($$1) != p_36058_) continue;
            this.items.set($$1, ItemStack.EMPTY);
            return;
        }
        for (EquipmentSlot $$2 : EQUIPMENT_SLOT_MAPPING.values()) {
            ItemStack $$3 = this.equipment.get($$2);
            if ($$3 != p_36058_) continue;
            this.equipment.set($$2, ItemStack.EMPTY);
            return;
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int p_36029_) {
        if (p_36029_ < this.items.size()) {
            ItemStack $$1 = this.items.get(p_36029_);
            this.items.set(p_36029_, ItemStack.EMPTY);
            return $$1;
        }
        EquipmentSlot $$2 = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(p_36029_);
        if ($$2 != null) {
            return this.equipment.set($$2, ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int p_35999_, ItemStack p_36000_) {
        EquipmentSlot $$2;
        if (p_35999_ < this.items.size()) {
            this.items.set(p_35999_, p_36000_);
        }
        if (($$2 = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(p_35999_)) != null) {
            this.equipment.set($$2, p_36000_);
        }
    }

    public ListTag save(ListTag p_36027_) {
        for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
            if (this.items.get($$1).isEmpty()) continue;
            CompoundTag $$2 = new CompoundTag();
            $$2.putByte("Slot", (byte)$$1);
            p_36027_.add(this.items.get($$1).save(this.player.registryAccess(), $$2));
        }
        return p_36027_;
    }

    public void load(ListTag p_36036_) {
        this.items.clear();
        for (int $$1 = 0; $$1 < p_36036_.size(); ++$$1) {
            CompoundTag $$2 = p_36036_.getCompoundOrEmpty($$1);
            int $$3 = $$2.getByteOr("Slot", (byte)0) & 0xFF;
            ItemStack $$4 = ItemStack.parse(this.player.registryAccess(), $$2).orElse(ItemStack.EMPTY);
            if ($$3 >= this.items.size()) continue;
            this.setItem($$3, $$4);
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack $$0 : this.items) {
            if ($$0.isEmpty()) continue;
            return false;
        }
        for (EquipmentSlot $$1 : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.get($$1).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int p_35991_) {
        if (p_35991_ < this.items.size()) {
            return this.items.get(p_35991_);
        }
        EquipmentSlot $$1 = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(p_35991_);
        if ($$1 != null) {
            return this.equipment.get($$1);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Component getName() {
        return Component.translatable("container.inventory");
    }

    public void dropAll() {
        for (int $$0 = 0; $$0 < this.items.size(); ++$$0) {
            ItemStack $$1 = this.items.get($$0);
            if ($$1.isEmpty()) continue;
            this.player.drop($$1, true, false);
            this.items.set($$0, ItemStack.EMPTY);
        }
        this.equipment.dropAll(this.player);
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(Player p_36009_) {
        return true;
    }

    public boolean contains(ItemStack p_36064_) {
        for (ItemStack $$1 : this) {
            if ($$1.isEmpty() || !ItemStack.isSameItemSameComponents($$1, p_36064_)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TagKey<Item> p_204076_) {
        for (ItemStack $$1 : this) {
            if ($$1.isEmpty() || !$$1.is(p_204076_)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> p_316260_) {
        for (ItemStack $$1 : this) {
            if (!p_316260_.test($$1)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(Inventory p_36007_) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            this.setItem($$1, p_36007_.getItem($$1));
        }
        this.setSelectedSlot(p_36007_.getSelectedSlot());
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.equipment.clear();
    }

    public void fillStackedContents(StackedItemContents p_360737_) {
        for (ItemStack $$1 : this.items) {
            p_360737_.accountSimpleStack($$1);
        }
    }

    public ItemStack removeFromSelected(boolean p_182404_) {
        ItemStack $$1 = this.getSelectedItem();
        if ($$1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.removeItem(this.selected, p_182404_ ? $$1.getCount() : 1);
    }
}

