/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ID_FIREWORKS_ITEM = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<OptionalInt> DATA_ATTACHED_TO_TARGET = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<Boolean> DATA_SHOT_AT_ANGLE = SynchedEntityData.defineId(FireworkRocketEntity.class, EntityDataSerializers.BOOLEAN);
    private static final int DEFAULT_LIFE = 0;
    private static final int DEFAULT_LIFE_TIME = 0;
    private static final boolean DEFAULT_SHOT_AT_ANGLE = false;
    private int life = 0;
    private int lifetime = 0;
    @Nullable
    private LivingEntity attachedToEntity;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> p_37027_, Level p_37028_) {
        super((EntityType<? extends Projectile>)p_37027_, p_37028_);
    }

    public FireworkRocketEntity(Level p_37030_, double p_37031_, double p_37032_, double p_37033_, ItemStack p_37034_) {
        super((EntityType<? extends Projectile>)EntityType.FIREWORK_ROCKET, p_37030_);
        this.life = 0;
        this.setPos(p_37031_, p_37032_, p_37033_);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, p_37034_.copy());
        int $$5 = 1;
        Fireworks $$6 = p_37034_.get(DataComponents.FIREWORKS);
        if ($$6 != null) {
            $$5 += $$6.flightDuration();
        }
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 10 * $$5 + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public FireworkRocketEntity(Level p_37036_, @Nullable Entity p_37037_, double p_37038_, double p_37039_, double p_37040_, ItemStack p_37041_) {
        this(p_37036_, p_37038_, p_37039_, p_37040_, p_37041_);
        this.setOwner(p_37037_);
    }

    public FireworkRocketEntity(Level p_37058_, ItemStack p_37059_, LivingEntity p_37060_) {
        this(p_37058_, p_37060_, p_37060_.getX(), p_37060_.getY(), p_37060_.getZ(), p_37059_);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, OptionalInt.of(p_37060_.getId()));
        this.attachedToEntity = p_37060_;
    }

    public FireworkRocketEntity(Level p_37043_, ItemStack p_37044_, double p_37045_, double p_37046_, double p_37047_, boolean p_37048_) {
        this(p_37043_, p_37045_, p_37046_, p_37047_, p_37044_);
        this.entityData.set(DATA_SHOT_AT_ANGLE, p_37048_);
    }

    public FireworkRocketEntity(Level p_37050_, ItemStack p_37051_, Entity p_37052_, double p_37053_, double p_37054_, double p_37055_, boolean p_37056_) {
        this(p_37050_, p_37051_, p_37053_, p_37054_, p_37055_, p_37056_);
        this.setOwner(p_37052_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326171_) {
        p_326171_.define(DATA_ID_FIREWORKS_ITEM, FireworkRocketEntity.getDefaultItem());
        p_326171_.define(DATA_ATTACHED_TO_TARGET, OptionalInt.empty());
        p_326171_.define(DATA_SHOT_AT_ANGLE, false);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_37065_) {
        return p_37065_ < 4096.0 && !this.isAttachedToEntity();
    }

    @Override
    public boolean shouldRender(double p_37083_, double p_37084_, double p_37085_) {
        return super.shouldRender(p_37083_, p_37084_, p_37085_) && !this.isAttachedToEntity();
    }

    @Override
    public void tick() {
        Level level;
        HitResult $$9;
        super.tick();
        if (this.isAttachedToEntity()) {
            if (this.attachedToEntity == null) {
                this.entityData.get(DATA_ATTACHED_TO_TARGET).ifPresent(p_409398_ -> {
                    Entity $$1 = this.level().getEntity(p_409398_);
                    if ($$1 instanceof LivingEntity) {
                        this.attachedToEntity = (LivingEntity)$$1;
                    }
                });
            }
            if (this.attachedToEntity != null) {
                Vec3 $$5;
                if (this.attachedToEntity.isFallFlying()) {
                    Vec3 $$0 = this.attachedToEntity.getLookAngle();
                    double $$1 = 1.5;
                    double $$2 = 0.1;
                    Vec3 $$3 = this.attachedToEntity.getDeltaMovement();
                    this.attachedToEntity.setDeltaMovement($$3.add($$0.x * 0.1 + ($$0.x * 1.5 - $$3.x) * 0.5, $$0.y * 0.1 + ($$0.y * 1.5 - $$3.y) * 0.5, $$0.z * 0.1 + ($$0.z * 1.5 - $$3.z) * 0.5));
                    Vec3 $$4 = this.attachedToEntity.getHandHoldingItemAngle(Items.FIREWORK_ROCKET);
                } else {
                    $$5 = Vec3.ZERO;
                }
                this.setPos(this.attachedToEntity.getX() + $$5.x, this.attachedToEntity.getY() + $$5.y, this.attachedToEntity.getZ() + $$5.z);
                this.setDeltaMovement(this.attachedToEntity.getDeltaMovement());
            }
            HitResult $$6 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        } else {
            if (!this.isShotAtAngle()) {
                double $$7 = this.horizontalCollision ? 1.0 : 1.15;
                this.setDeltaMovement(this.getDeltaMovement().multiply($$7, 1.0, $$7).add(0.0, 0.04, 0.0));
            }
            Vec3 $$8 = this.getDeltaMovement();
            $$9 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
            this.move(MoverType.SELF, $$8);
            this.applyEffectsFromBlocks();
            this.setDeltaMovement($$8);
        }
        if (!this.noPhysics && this.isAlive() && $$9.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$9);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level().isClientSide && this.life % 2 < 2) {
            this.level().addParticle(ParticleTypes.FIREWORK, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (this.life > this.lifetime && (level = this.level()) instanceof ServerLevel) {
            ServerLevel $$10 = (ServerLevel)level;
            this.explode($$10);
        }
    }

    private void explode(ServerLevel p_376529_) {
        p_376529_.broadcastEntityEvent(this, (byte)17);
        this.gameEvent(GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage(p_376529_);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37071_) {
        super.onHitEntity(p_37071_);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            this.explode($$1);
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult p_37069_) {
        BlockPos $$1 = new BlockPos(p_37069_.getBlockPos());
        this.level().getBlockState($$1).entityInside(this.level(), $$1, this, InsideBlockEffectApplier.NOOP);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            if (this.hasExplosion()) {
                this.explode($$2);
            }
        }
        super.onHitBlock(p_37069_);
    }

    private boolean hasExplosion() {
        return !this.getExplosions().isEmpty();
    }

    private void dealExplosionDamage(ServerLevel p_376666_) {
        float $$1 = 0.0f;
        List<FireworkExplosion> $$2 = this.getExplosions();
        if (!$$2.isEmpty()) {
            $$1 = 5.0f + (float)($$2.size() * 2);
        }
        if ($$1 > 0.0f) {
            if (this.attachedToEntity != null) {
                this.attachedToEntity.hurtServer(p_376666_, this.damageSources().fireworks(this, this.getOwner()), 5.0f + (float)($$2.size() * 2));
            }
            double $$3 = 5.0;
            Vec3 $$4 = this.position();
            List<LivingEntity> $$5 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(5.0));
            for (LivingEntity $$6 : $$5) {
                if ($$6 == this.attachedToEntity || this.distanceToSqr($$6) > 25.0) continue;
                boolean $$7 = false;
                for (int $$8 = 0; $$8 < 2; ++$$8) {
                    Vec3 $$9 = new Vec3($$6.getX(), $$6.getY(0.5 * (double)$$8), $$6.getZ());
                    BlockHitResult $$10 = this.level().clip(new ClipContext($$4, $$9, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
                    if (((HitResult)$$10).getType() != HitResult.Type.MISS) continue;
                    $$7 = true;
                    break;
                }
                if (!$$7) continue;
                float $$11 = $$1 * (float)Math.sqrt((5.0 - (double)this.distanceTo($$6)) / 5.0);
                $$6.hurtServer(p_376666_, this.damageSources().fireworks(this, this.getOwner()), $$11);
            }
        }
    }

    private boolean isAttachedToEntity() {
        return this.entityData.get(DATA_ATTACHED_TO_TARGET).isPresent();
    }

    public boolean isShotAtAngle() {
        return this.entityData.get(DATA_SHOT_AT_ANGLE);
    }

    @Override
    public void handleEntityEvent(byte p_37063_) {
        if (p_37063_ == 17 && this.level().isClientSide) {
            Vec3 $$1 = this.getDeltaMovement();
            this.level().createFireworks(this.getX(), this.getY(), this.getZ(), $$1.x, $$1.y, $$1.z, this.getExplosions());
        }
        super.handleEntityEvent(p_37063_);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_37075_) {
        super.addAdditionalSaveData(p_37075_);
        p_37075_.putInt("Life", this.life);
        p_37075_.putInt("LifeTime", this.lifetime);
        RegistryOps<Tag> $$1 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        p_37075_.store("FireworksItem", ItemStack.CODEC, $$1, this.getItem());
        p_37075_.putBoolean("ShotAtAngle", this.entityData.get(DATA_SHOT_AT_ANGLE));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_37073_) {
        super.readAdditionalSaveData(p_37073_);
        this.life = p_37073_.getIntOr("Life", 0);
        this.lifetime = p_37073_.getIntOr("LifeTime", 0);
        RegistryOps<Tag> $$1 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, p_37073_.read("FireworksItem", ItemStack.CODEC, $$1).orElse(FireworkRocketEntity.getDefaultItem()));
        this.entityData.set(DATA_SHOT_AT_ANGLE, p_37073_.getBooleanOr("ShotAtAngle", false));
    }

    private List<FireworkExplosion> getExplosions() {
        ItemStack $$0 = this.entityData.get(DATA_ID_FIREWORKS_ITEM);
        Fireworks $$1 = $$0.get(DataComponents.FIREWORKS);
        return $$1 != null ? $$1.explosions() : List.of();
    }

    @Override
    public ItemStack getItem() {
        return this.entityData.get(DATA_ID_FIREWORKS_ITEM);
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity p_345239_, DamageSource p_345155_) {
        double $$2 = p_345239_.position().x - this.position().x;
        double $$3 = p_345239_.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }
}

