/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class Projectile
extends Entity
implements TraceableEntity {
    private static final boolean DEFAULT_LEFT_OWNER = false;
    private static final boolean DEFAULT_HAS_BEEN_SHOT = false;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner = false;
    private boolean hasBeenShot = false;
    @Nullable
    private Entity lastDeflectedBy;

    Projectile(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    public void setOwner(@Nullable Entity p_37263_) {
        if (p_37263_ != null) {
            this.ownerUUID = p_37263_.getUUID();
            this.cachedOwner = p_37263_;
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.findOwner(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @Nullable
    protected Entity findOwner(UUID p_362372_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            return $$1.getEntity(p_362372_);
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_37265_) {
        p_37265_.storeNullable("Owner", UUIDUtil.CODEC, this.ownerUUID);
        if (this.leftOwner) {
            p_37265_.putBoolean("LeftOwner", true);
        }
        p_37265_.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity p_150172_) {
        return p_150172_.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_37262_) {
        this.setOwnerThroughUUID(p_37262_.read("Owner", UUIDUtil.CODEC).orElse(null));
        this.leftOwner = p_37262_.getBooleanOr("LeftOwner", false);
        this.hasBeenShot = p_37262_.getBooleanOr("HasBeenShot", false);
    }

    protected void setOwnerThroughUUID(@Nullable UUID p_372906_) {
        if (!Objects.equals(this.ownerUUID, p_372906_)) {
            this.ownerUUID = p_372906_;
            this.cachedOwner = p_372906_ != null ? this.findOwner(p_372906_) : null;
        }
    }

    @Override
    public void restoreFrom(Entity p_305838_) {
        super.restoreFrom(p_305838_);
        if (p_305838_ instanceof Projectile) {
            Projectile $$1 = (Projectile)p_305838_;
            this.ownerUUID = $$1.ownerUUID;
            this.cachedOwner = $$1.cachedOwner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity $$0 = this.getOwner();
        if ($$0 != null) {
            AABB $$1 = this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0);
            return $$0.getRootVehicle().getSelfAndPassengers().filter(EntitySelector.CAN_BE_PICKED).noneMatch(p_359972_ -> $$1.intersects(p_359972_.getBoundingBox()));
        }
        return true;
    }

    public Vec3 getMovementToShoot(double p_338345_, double p_338731_, double p_338427_, float p_338430_, float p_338697_) {
        return new Vec3(p_338345_, p_338731_, p_338427_).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)p_338697_), this.random.triangle(0.0, 0.0172275 * (double)p_338697_), this.random.triangle(0.0, 0.0172275 * (double)p_338697_)).scale(p_338430_);
    }

    public void shoot(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        Vec3 $$5 = this.getMovementToShoot(p_37266_, p_37267_, p_37268_, p_37269_, p_37270_);
        this.setDeltaMovement($$5);
        this.hasImpulse = true;
        double $$6 = $$5.horizontalDistance();
        this.setYRot((float)(Mth.atan2($$5.x, $$5.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2($$5.y, $$6) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity p_37252_, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        float $$6 = -Mth.sin(p_37254_ * ((float)Math.PI / 180)) * Mth.cos(p_37253_ * ((float)Math.PI / 180));
        float $$7 = -Mth.sin((p_37253_ + p_37255_) * ((float)Math.PI / 180));
        float $$8 = Mth.cos(p_37254_ * ((float)Math.PI / 180)) * Mth.cos(p_37253_ * ((float)Math.PI / 180));
        this.shoot($$6, $$7, $$8, p_37256_, p_37257_);
        Vec3 $$9 = p_37252_.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add($$9.x, p_37252_.onGround() ? 0.0 : $$9.y, $$9.z));
    }

    @Override
    public void onAboveBubbleColumn(boolean p_400117_, BlockPos p_400267_) {
        double $$2 = p_400117_ ? -0.03 : 0.1;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, $$2, 0.0));
        Projectile.sendBubbleColumnParticles(this.level(), p_400267_);
    }

    @Override
    public void onInsideBubbleColumn(boolean p_399932_) {
        double $$1 = p_399932_ ? -0.03 : 0.06;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, $$1, 0.0));
        this.resetFallDistance();
    }

    public static <T extends Projectile> T spawnProjectileFromRotation(ProjectileFactory<T> p_364847_, ServerLevel p_364917_, ItemStack p_361900_, LivingEntity p_364717_, float p_360563_, float p_361014_, float p_365444_) {
        return (T)Projectile.spawnProjectile(p_364847_.create(p_364917_, p_364717_, p_361900_), p_364917_, p_361900_, p_409403_ -> p_409403_.shootFromRotation(p_364717_, p_364717_.getXRot(), p_364717_.getYRot(), p_360563_, p_361014_, p_365444_));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(ProjectileFactory<T> p_363835_, ServerLevel p_361870_, ItemStack p_365211_, LivingEntity p_361058_, double p_362249_, double p_362086_, double p_360421_, float p_363492_, float p_363425_) {
        return (T)Projectile.spawnProjectile(p_363835_.create(p_361870_, p_361058_, p_365211_), p_361870_, p_365211_, p_359978_ -> p_359978_.shoot(p_362249_, p_362086_, p_360421_, p_363492_, p_363425_));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(T p_363444_, ServerLevel p_365046_, ItemStack p_365439_, double p_364920_, double p_362460_, double p_365302_, float p_364445_, float p_360615_) {
        return (T)Projectile.spawnProjectile(p_363444_, p_365046_, p_365439_, p_359970_ -> p_363444_.shoot(p_364920_, p_362460_, p_365302_, p_364445_, p_360615_));
    }

    public static <T extends Projectile> T spawnProjectile(T p_363460_, ServerLevel p_362469_, ItemStack p_364790_) {
        return (T)Projectile.spawnProjectile(p_363460_, p_362469_, p_364790_, p_359984_ -> {});
    }

    public static <T extends Projectile> T spawnProjectile(T p_360642_, ServerLevel p_360523_, ItemStack p_364956_, Consumer<T> p_364362_) {
        p_364362_.accept(p_360642_);
        p_360523_.addFreshEntity(p_360642_);
        p_360642_.applyOnProjectileSpawned(p_360523_, p_364956_);
        return p_360642_;
    }

    public void applyOnProjectileSpawned(ServerLevel p_361488_, ItemStack p_360952_) {
        AbstractArrow $$2;
        ItemStack $$3;
        EnchantmentHelper.onProjectileSpawned(p_361488_, p_360952_, this, p_359985_ -> {});
        Projectile projectile = this;
        if (projectile instanceof AbstractArrow && ($$3 = ($$2 = (AbstractArrow)projectile).getWeaponItem()) != null && !$$3.isEmpty() && !p_360952_.getItem().equals($$3.getItem())) {
            EnchantmentHelper.onProjectileSpawned(p_361488_, $$3, this, $$2::onItemBreak);
        }
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult p_341949_) {
        ProjectileDeflection $$5;
        BlockHitResult $$4;
        if (p_341949_.getType() == HitResult.Type.ENTITY) {
            EntityHitResult $$1 = (EntityHitResult)p_341949_;
            Entity $$2 = $$1.getEntity();
            ProjectileDeflection $$3 = $$2.deflection(this);
            if ($$3 != ProjectileDeflection.NONE) {
                if ($$2 != this.lastDeflectedBy && this.deflect($$3, $$2, this.getOwner(), false)) {
                    this.lastDeflectedBy = $$2;
                }
                return $$3;
            }
        } else if (this.shouldBounceOnWorldBorder() && p_341949_ instanceof BlockHitResult && ($$4 = (BlockHitResult)p_341949_).isWorldBorderHit() && this.deflect($$5 = ProjectileDeflection.REVERSE, null, this.getOwner(), false)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            return $$5;
        }
        this.onHit(p_341949_);
        return ProjectileDeflection.NONE;
    }

    protected boolean shouldBounceOnWorldBorder() {
        return false;
    }

    public boolean deflect(ProjectileDeflection p_341900_, @Nullable Entity p_341912_, @Nullable Entity p_341932_, boolean p_341948_) {
        p_341900_.deflect(this, p_341912_, this.random);
        if (!this.level().isClientSide) {
            this.setOwner(p_341932_);
            this.onDeflection(p_341912_, p_341948_);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity p_341918_, boolean p_341907_) {
    }

    protected void onItemBreak(Item p_361691_) {
    }

    protected void onHit(HitResult p_37260_) {
        HitResult.Type $$1 = p_37260_.getType();
        if ($$1 == HitResult.Type.ENTITY) {
            EntityHitResult $$2 = (EntityHitResult)p_37260_;
            Entity $$3 = $$2.getEntity();
            if ($$3.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && $$3 instanceof Projectile) {
                Projectile $$4 = (Projectile)$$3;
                $$4.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity($$2);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, p_37260_.getLocation(), GameEvent.Context.of(this, null));
        } else if ($$1 == HitResult.Type.BLOCK) {
            BlockHitResult $$5 = (BlockHitResult)p_37260_;
            this.onHitBlock($$5);
            BlockPos $$6 = $$5.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, $$6, GameEvent.Context.of(this, this.level().getBlockState($$6)));
        }
    }

    protected void onHitEntity(EntityHitResult p_37259_) {
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        BlockState $$1 = this.level().getBlockState(p_37258_.getBlockPos());
        $$1.onProjectileHit(this.level(), $$1, p_37258_, this);
    }

    protected boolean canHitEntity(Entity p_37250_) {
        if (!p_37250_.canBeHitByProjectile()) {
            return false;
        }
        Entity $$1 = this.getOwner();
        return $$1 == null || this.leftOwner || !$$1.isPassengerOfSameVehicle(p_37250_);
    }

    protected void updateRotation() {
        Vec3 $$0 = this.getDeltaMovement();
        double $$1 = $$0.horizontalDistance();
        this.setXRot(Projectile.lerpRotation(this.xRotO, (float)(Mth.atan2($$0.y, $$1) * 57.2957763671875)));
        this.setYRot(Projectile.lerpRotation(this.yRotO, (float)(Mth.atan2($$0.x, $$0.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.lerp(0.2f, p_37274_, p_37275_);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352459_) {
        Entity $$1 = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, p_352459_, $$1 == null ? 0 : $$1.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150170_) {
        super.recreateFromPacket(p_150170_);
        Entity $$1 = this.level().getEntity(p_150170_.getData());
        if ($$1 != null) {
            this.setOwner($$1);
        }
    }

    @Override
    public boolean mayInteract(ServerLevel p_376318_, BlockPos p_150168_) {
        Entity $$2 = this.getOwner();
        if ($$2 instanceof Player) {
            return $$2.mayInteract(p_376318_, p_150168_);
        }
        return $$2 == null || p_376318_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(ServerLevel p_376471_) {
        return this.getType().is(EntityTypeTags.IMPACT_PROJECTILES) && p_376471_.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity p_344992_, DamageSource p_345905_) {
        double $$2 = this.getDeltaMovement().x;
        double $$3 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)$$2, (double)$$3);
    }

    @Override
    public int getDimensionChangingDelay() {
        return 2;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376191_, DamageSource p_376581_, float p_376638_) {
        if (!this.isInvulnerableToBase(p_376581_)) {
            this.markHurt();
        }
        return false;
    }

    @FunctionalInterface
    public static interface ProjectileFactory<T extends Projectile> {
        public T create(ServerLevel var1, LivingEntity var2, ItemStack var3);
    }
}

