/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ThrownSplashPotion
extends AbstractThrownPotion {
    public ThrownSplashPotion(EntityType<? extends ThrownSplashPotion> p_400190_, Level p_399722_) {
        super((EntityType<? extends AbstractThrownPotion>)p_400190_, p_399722_);
    }

    public ThrownSplashPotion(Level p_399777_, LivingEntity p_400264_, ItemStack p_400186_) {
        super(EntityType.SPLASH_POTION, p_399777_, p_400264_, p_400186_);
    }

    public ThrownSplashPotion(Level p_400144_, double p_400061_, double p_400032_, double p_399549_, ItemStack p_400218_) {
        super(EntityType.SPLASH_POTION, p_400144_, p_400061_, p_400032_, p_399549_, p_400218_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel p_399483_, ItemStack p_400156_, @Nullable Entity p_400094_) {
        PotionContents $$3 = p_400156_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        float $$4 = p_400156_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffectInstance> $$5 = $$3.getAllEffects();
        AABB $$6 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$7 = this.level().getEntitiesOfClass(LivingEntity.class, $$6);
        if (!$$7.isEmpty()) {
            Entity $$8 = this.getEffectSource();
            for (LivingEntity $$9 : $$7) {
                double $$12;
                double $$10;
                if (!$$9.isAffectedByPotions() || !(($$10 = this.distanceToSqr($$9)) < 16.0)) continue;
                if ($$9 == p_400094_) {
                    double $$11 = 1.0;
                } else {
                    $$12 = 1.0 - Math.sqrt($$10) / 4.0;
                }
                for (MobEffectInstance $$13 : $$5) {
                    Holder<MobEffect> $$14 = $$13.getEffect();
                    if ($$14.value().isInstantenous()) {
                        $$14.value().applyInstantenousEffect(p_399483_, this, this.getOwner(), $$9, $$13.getAmplifier(), $$12);
                        continue;
                    }
                    int $$15 = $$13.mapDuration(p_400103_ -> (int)($$12 * (double)p_400103_ * (double)$$4 + 0.5));
                    MobEffectInstance $$16 = new MobEffectInstance($$14, $$15, $$13.getAmplifier(), $$13.isAmbient(), $$13.isVisible());
                    if ($$16.endsWithin(20)) continue;
                    $$9.addEffect($$16, $$8);
                }
            }
        }
    }
}

