/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = SpawnPlacements.getPlacementType(EntityType.RAVAGER);
    public static final MapCodec<Raid> MAP_CODEC = RecordCodecBuilder.mapCodec(p_400925_ -> p_400925_.group((App)Codec.BOOL.fieldOf("started").forGetter(p_400913_ -> p_400913_.started), (App)Codec.BOOL.fieldOf("active").forGetter(p_400917_ -> p_400917_.active), (App)Codec.LONG.fieldOf("ticks_active").forGetter(p_400918_ -> p_400918_.ticksActive), (App)Codec.INT.fieldOf("raid_omen_level").forGetter(p_400924_ -> p_400924_.raidOmenLevel), (App)Codec.INT.fieldOf("groups_spawned").forGetter(p_400921_ -> p_400921_.groupsSpawned), (App)Codec.INT.fieldOf("cooldown_ticks").forGetter(p_400926_ -> p_400926_.raidCooldownTicks), (App)Codec.INT.fieldOf("post_raid_ticks").forGetter(p_400914_ -> p_400914_.postRaidTicks), (App)Codec.FLOAT.fieldOf("total_health").forGetter(p_400919_ -> Float.valueOf(p_400919_.totalHealth)), (App)Codec.INT.fieldOf("group_count").forGetter(p_400915_ -> p_400915_.numGroups), (App)RaidStatus.CODEC.fieldOf("status").forGetter(p_400927_ -> p_400927_.status), (App)BlockPos.CODEC.fieldOf("center").forGetter(p_400923_ -> p_400923_.center), (App)UUIDUtil.CODEC_SET.fieldOf("heroes_of_the_village").forGetter(p_400920_ -> p_400920_.heroesOfTheVillage)).apply((Applicative)p_400925_, Raid::new));
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final Component OMINOUS_BANNER_PATTERN_NAME = Component.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.translatable("event.minecraft.raid");
    private static final Component RAID_BAR_VICTORY_COMPONENT = Component.translatable("event.minecraft.raid.victory.full");
    private static final Component RAID_BAR_DEFEAT_COMPONENT = Component.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, Raider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<Raider>> groupRaiderMap = Maps.newHashMap();
    private final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    private long ticksActive;
    private BlockPos center;
    private boolean started;
    private float totalHealth;
    private int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final ServerBossEvent raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    private final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos = Optional.empty();

    public Raid(BlockPos p_401301_, Difficulty p_401426_) {
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = p_401301_;
        this.numGroups = this.getNumGroups(p_401426_);
        this.status = RaidStatus.ONGOING;
    }

    private Raid(boolean p_401323_, boolean p_401294_, long p_401064_, int p_37692_, int p_401428_, int p_401382_, int p_401117_, float p_401178_, int p_401042_, RaidStatus p_401122_, BlockPos p_37694_, Set<UUID> p_401136_) {
        this.started = p_401323_;
        this.active = p_401294_;
        this.ticksActive = p_401064_;
        this.raidOmenLevel = p_37692_;
        this.groupsSpawned = p_401428_;
        this.raidCooldownTicks = p_401382_;
        this.postRaidTicks = p_401117_;
        this.totalHealth = p_401178_;
        this.center = p_37694_;
        this.numGroups = p_401042_;
        this.status = p_401122_;
        this.heroesOfTheVillage.addAll(p_401136_);
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<Raider> getAllRaiders() {
        HashSet $$0 = Sets.newHashSet();
        for (Set<Raider> $$1 : this.groupRaiderMap.values()) {
            $$0.addAll($$1);
        }
        return $$0;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return p_409408_ -> {
            BlockPos $$1 = p_409408_.blockPosition();
            return p_409408_.isAlive() && p_409408_.serverLevel().getRaidAt($$1) == this;
        };
    }

    private void updatePlayers(ServerLevel p_401212_) {
        HashSet $$1 = Sets.newHashSet(this.raidEvent.getPlayers());
        List<ServerPlayer> $$2 = p_401212_.getPlayers(this.validPlayer());
        for (ServerPlayer $$3 : $$2) {
            if ($$1.contains($$3)) continue;
            this.raidEvent.addPlayer($$3);
        }
        for (ServerPlayer $$4 : $$1) {
            if ($$2.contains($$4)) continue;
            this.raidEvent.removePlayer($$4);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int p_338727_) {
        this.raidOmenLevel = p_338727_;
    }

    public boolean absorbRaidOmen(ServerPlayer p_338621_) {
        MobEffectInstance $$1 = p_338621_.getEffect(MobEffects.RAID_OMEN);
        if ($$1 == null) {
            return false;
        }
        this.raidOmenLevel += $$1.getAmplifier() + 1;
        this.raidOmenLevel = Mth.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            p_338621_.awardStat(Stats.RAID_TRIGGER);
            CriteriaTriggers.RAID_OMEN.trigger(p_338621_);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = RaidStatus.STOPPED;
    }

    public void tick(ServerLevel p_401322_) {
        if (this.isStopped()) {
            return;
        }
        if (this.status == RaidStatus.ONGOING) {
            boolean $$1 = this.active;
            this.active = p_401322_.hasChunkAt(this.center);
            if (p_401322_.getDifficulty() == Difficulty.PEACEFUL) {
                this.stop();
                return;
            }
            if ($$1 != this.active) {
                this.raidEvent.setVisible(this.active);
            }
            if (!this.active) {
                return;
            }
            if (!p_401322_.isVillage(this.center)) {
                this.moveRaidCenterToNearbyVillageSection(p_401322_);
            }
            if (!p_401322_.isVillage(this.center)) {
                if (this.groupsSpawned > 0) {
                    this.status = RaidStatus.LOSS;
                } else {
                    this.stop();
                }
            }
            ++this.ticksActive;
            if (this.ticksActive >= 48000L) {
                this.stop();
                return;
            }
            int $$2 = this.getTotalRaidersAlive();
            if ($$2 == 0 && this.hasMoreWaves()) {
                if (this.raidCooldownTicks > 0) {
                    boolean $$4;
                    boolean $$3 = this.waveSpawnPos.isPresent();
                    boolean bl = $$4 = !$$3 && this.raidCooldownTicks % 5 == 0;
                    if ($$3 && !p_401322_.isPositionEntityTicking(this.waveSpawnPos.get())) {
                        $$4 = true;
                    }
                    if ($$4) {
                        this.waveSpawnPos = this.getValidSpawnPos(p_401322_);
                    }
                    if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                        this.updatePlayers(p_401322_);
                    }
                    --this.raidCooldownTicks;
                    this.raidEvent.setProgress(Mth.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                    this.raidCooldownTicks = 300;
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                    return;
                }
            }
            if (this.ticksActive % 20L == 0L) {
                this.updatePlayers(p_401322_);
                this.updateRaiders(p_401322_);
                if ($$2 > 0) {
                    if ($$2 <= 2) {
                        this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(Component.translatable(RAIDERS_REMAINING, $$2)));
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                } else {
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                }
            }
            boolean $$5 = false;
            int $$6 = 0;
            while (this.shouldSpawnGroup()) {
                BlockPos $$7 = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(p_401322_, 20));
                if ($$7 != null) {
                    this.started = true;
                    this.spawnGroup(p_401322_, $$7);
                    if (!$$5) {
                        this.playSound(p_401322_, $$7);
                        $$5 = true;
                    }
                } else {
                    ++$$6;
                }
                if ($$6 <= 5) continue;
                this.stop();
                break;
            }
            if (this.isStarted() && !this.hasMoreWaves() && $$2 == 0) {
                if (this.postRaidTicks < 40) {
                    ++this.postRaidTicks;
                } else {
                    this.status = RaidStatus.VICTORY;
                    for (UUID $$8 : this.heroesOfTheVillage) {
                        Entity $$9 = p_401322_.getEntity($$8);
                        if (!($$9 instanceof LivingEntity)) continue;
                        LivingEntity $$10 = (LivingEntity)$$9;
                        if ($$9.isSpectator()) continue;
                        $$10.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                        if (!($$10 instanceof ServerPlayer)) continue;
                        ServerPlayer $$11 = (ServerPlayer)$$10;
                        $$11.awardStat(Stats.RAID_WIN);
                        CriteriaTriggers.RAID_WIN.trigger($$11);
                    }
                }
            }
            this.setDirty(p_401322_);
        } else if (this.isOver()) {
            ++this.celebrationTicks;
            if (this.celebrationTicks >= 600) {
                this.stop();
                return;
            }
            if (this.celebrationTicks % 20 == 0) {
                this.updatePlayers(p_401322_);
                this.raidEvent.setVisible(true);
                if (this.isVictory()) {
                    this.raidEvent.setProgress(0.0f);
                    this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                } else {
                    this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection(ServerLevel p_401058_) {
        Stream<SectionPos> $$1 = SectionPos.cube(SectionPos.of(this.center), 2);
        $$1.filter(p_401058_::isVillage).map(SectionPos::center).min(Comparator.comparingDouble(p_37766_ -> p_37766_.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos(ServerLevel p_401254_) {
        BlockPos $$1 = this.findRandomSpawnPos(p_401254_, 8);
        if ($$1 != null) {
            return Optional.of($$1);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        if (this.hasBonusWave()) {
            return !this.hasSpawnedBonusWave();
        }
        return !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders(ServerLevel p_401225_) {
        Iterator<Set<Raider>> $$1 = this.groupRaiderMap.values().iterator();
        HashSet $$2 = Sets.newHashSet();
        while ($$1.hasNext()) {
            Set<Raider> $$3 = $$1.next();
            for (Raider $$4 : $$3) {
                BlockPos $$5 = $$4.blockPosition();
                if ($$4.isRemoved() || $$4.level().dimension() != p_401225_.dimension() || this.center.distSqr($$5) >= 12544.0) {
                    $$2.add($$4);
                    continue;
                }
                if ($$4.tickCount <= 600) continue;
                if (p_401225_.getEntity($$4.getUUID()) == null) {
                    $$2.add($$4);
                }
                if (!p_401225_.isVillage($$5) && $$4.getNoActionTime() > 2400) {
                    $$4.setTicksOutsideRaid($$4.getTicksOutsideRaid() + 1);
                }
                if ($$4.getTicksOutsideRaid() < 30) continue;
                $$2.add($$4);
            }
        }
        for (Raider $$6 : $$2) {
            this.removeFromRaid(p_401225_, $$6, true);
            if (!$$6.isPatrolLeader()) continue;
            this.removeLeader($$6.getWave());
        }
    }

    private void playSound(ServerLevel p_401069_, BlockPos p_37744_) {
        float $$2 = 13.0f;
        int $$3 = 64;
        Collection<ServerPlayer> $$4 = this.raidEvent.getPlayers();
        long $$5 = this.random.nextLong();
        for (ServerPlayer $$6 : p_401069_.players()) {
            Vec3 $$7 = $$6.position();
            Vec3 $$8 = Vec3.atCenterOf(p_37744_);
            double $$9 = Math.sqrt(($$8.x - $$7.x) * ($$8.x - $$7.x) + ($$8.z - $$7.z) * ($$8.z - $$7.z));
            double $$10 = $$7.x + 13.0 / $$9 * ($$8.x - $$7.x);
            double $$11 = $$7.z + 13.0 / $$9 * ($$8.z - $$7.z);
            if (!($$9 <= 64.0) && !$$4.contains($$6)) continue;
            $$6.connection.send(new ClientboundSoundPacket(SoundEvents.RAID_HORN, SoundSource.NEUTRAL, $$10, $$6.getY(), $$11, 64.0f, 1.0f, $$5));
        }
    }

    private void spawnGroup(ServerLevel p_401196_, BlockPos p_37756_) {
        boolean $$2 = false;
        int $$3 = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance $$4 = p_401196_.getCurrentDifficultyAt(p_37756_);
        boolean $$5 = this.shouldSpawnBonusGroup();
        for (RaiderType $$6 : RaiderType.VALUES) {
            Raider $$10;
            int $$7 = this.getDefaultNumSpawns($$6, $$3, $$5) + this.getPotentialBonusSpawns($$6, this.random, $$3, $$4, $$5);
            int $$8 = 0;
            for (int $$9 = 0; $$9 < $$7 && ($$10 = $$6.entityType.create(p_401196_, EntitySpawnReason.EVENT)) != null; ++$$9) {
                if (!$$2 && $$10.canBeLeader()) {
                    $$10.setPatrolLeader(true);
                    this.setLeader($$3, $$10);
                    $$2 = true;
                }
                this.joinRaid(p_401196_, $$3, $$10, p_37756_, false);
                if ($$6.entityType != EntityType.RAVAGER) continue;
                Raider $$11 = null;
                if ($$3 == this.getNumGroups(Difficulty.NORMAL)) {
                    $$11 = EntityType.PILLAGER.create(p_401196_, EntitySpawnReason.EVENT);
                } else if ($$3 >= this.getNumGroups(Difficulty.HARD)) {
                    $$11 = $$8 == 0 ? (Raider)EntityType.EVOKER.create(p_401196_, EntitySpawnReason.EVENT) : (Raider)EntityType.VINDICATOR.create(p_401196_, EntitySpawnReason.EVENT);
                }
                ++$$8;
                if ($$11 == null) continue;
                this.joinRaid(p_401196_, $$3, $$11, p_37756_, false);
                $$11.snapTo(p_37756_, 0.0f, 0.0f);
                $$11.startRiding($$10);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty(p_401196_);
    }

    public void joinRaid(ServerLevel p_401149_, int p_37714_, Raider p_37715_, @Nullable BlockPos p_37716_, boolean p_37717_) {
        boolean $$5 = this.addWaveMob(p_401149_, p_37714_, p_37715_);
        if ($$5) {
            p_37715_.setCurrentRaid(this);
            p_37715_.setWave(p_37714_);
            p_37715_.setCanJoinRaid(true);
            p_37715_.setTicksOutsideRaid(0);
            if (!p_37717_ && p_37716_ != null) {
                p_37715_.setPos((double)p_37716_.getX() + 0.5, (double)p_37716_.getY() + 1.0, (double)p_37716_.getZ() + 0.5);
                p_37715_.finalizeSpawn(p_401149_, p_401149_.getCurrentDifficultyAt(p_37716_), EntitySpawnReason.EVENT, null);
                p_37715_.applyRaidBuffs(p_401149_, p_37714_, false);
                p_37715_.setOnGround(true);
                p_401149_.addFreshEntityWithPassengers(p_37715_);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(Mth.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float $$0 = 0.0f;
        for (Set<Raider> $$1 : this.groupRaiderMap.values()) {
            for (Raider $$2 : $$1) {
                $$0 += $$2.getHealth();
            }
        }
        return $$0;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(ServerLevel p_401317_, Raider p_37741_, boolean p_37742_) {
        boolean $$4;
        Set<Raider> $$3 = this.groupRaiderMap.get(p_37741_.getWave());
        if ($$3 != null && ($$4 = $$3.remove(p_37741_))) {
            if (p_37742_) {
                this.totalHealth -= p_37741_.getHealth();
            }
            p_37741_.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty(p_401317_);
        }
    }

    private void setDirty(ServerLevel p_401185_) {
        p_401185_.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<BannerPattern> p_361191_) {
        ItemStack $$1 = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers $$2 = new BannerPatternLayers.Builder().addIfRegistered(p_361191_, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.CYAN).addIfRegistered(p_361191_, BannerPatterns.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.STRIPE_CENTER, DyeColor.GRAY).addIfRegistered(p_361191_, BannerPatterns.BORDER, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.STRIPE_MIDDLE, DyeColor.BLACK).addIfRegistered(p_361191_, BannerPatterns.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).addIfRegistered(p_361191_, BannerPatterns.BORDER, DyeColor.BLACK).build();
        $$1.set(DataComponents.BANNER_PATTERNS, $$2);
        $$1.set(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT.withHidden(DataComponents.BANNER_PATTERNS, true));
        $$1.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        $$1.set(DataComponents.RARITY, Rarity.UNCOMMON);
        return $$1;
    }

    @Nullable
    public Raider getLeader(int p_37751_) {
        return this.groupToLeaderMap.get(p_37751_);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(ServerLevel p_401052_, int p_37708_) {
        int $$2 = this.raidCooldownTicks / 20;
        float $$3 = 0.22f * (float)$$2 - 0.24f;
        BlockPos.MutableBlockPos $$4 = new BlockPos.MutableBlockPos();
        float $$5 = p_401052_.random.nextFloat() * ((float)Math.PI * 2);
        for (int $$6 = 0; $$6 < p_37708_; ++$$6) {
            int $$9;
            float $$7 = $$5 + (float)Math.PI * (float)$$6 / 8.0f;
            int $$8 = this.center.getX() + Mth.floor(Mth.cos($$7) * 32.0f * $$3) + p_401052_.random.nextInt(3) * Mth.floor($$3);
            int $$10 = p_401052_.getHeight(Heightmap.Types.WORLD_SURFACE, $$8, $$9 = this.center.getZ() + Mth.floor(Mth.sin($$7) * 32.0f * $$3) + p_401052_.random.nextInt(3) * Mth.floor($$3));
            if (Mth.abs($$10 - this.center.getY()) > 96) continue;
            $$4.set($$8, $$10, $$9);
            if (p_401052_.isVillage($$4) && $$2 > 7) continue;
            int $$11 = 10;
            if (!p_401052_.hasChunksAt($$4.getX() - 10, $$4.getZ() - 10, $$4.getX() + 10, $$4.getZ() + 10) || !p_401052_.isPositionEntityTicking($$4) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(p_401052_, $$4, EntityType.RAVAGER) && (!p_401052_.getBlockState((BlockPos)$$4.below()).is(Blocks.SNOW) || !p_401052_.getBlockState($$4).isAir())) continue;
            return $$4;
        }
        return null;
    }

    private boolean addWaveMob(ServerLevel p_401172_, int p_37753_, Raider p_37754_) {
        return this.addWaveMob(p_401172_, p_37753_, p_37754_, true);
    }

    public boolean addWaveMob(ServerLevel p_401410_, int p_37719_, Raider p_37720_, boolean p_37721_) {
        this.groupRaiderMap.computeIfAbsent(p_37719_, p_37746_ -> Sets.newHashSet());
        Set<Raider> $$4 = this.groupRaiderMap.get(p_37719_);
        Raider $$5 = null;
        for (Raider $$6 : $$4) {
            if (!$$6.getUUID().equals(p_37720_.getUUID())) continue;
            $$5 = $$6;
            break;
        }
        if ($$5 != null) {
            $$4.remove($$5);
            $$4.add(p_37720_);
        }
        $$4.add(p_37720_);
        if (p_37721_) {
            this.totalHealth += p_37720_.getHealth();
        }
        this.updateBossbar();
        this.setDirty(p_401410_);
        return true;
    }

    public void setLeader(int p_37711_, Raider p_37712_) {
        this.groupToLeaderMap.put(p_37711_, p_37712_);
        p_37712_.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(p_37712_.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        p_37712_.setDropChance(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int p_37759_) {
        this.groupToLeaderMap.remove(p_37759_);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos p_37761_) {
        this.center = p_37761_;
    }

    private int getDefaultNumSpawns(RaiderType p_37731_, int p_37732_, boolean p_37733_) {
        return p_37733_ ? p_37731_.spawnsPerWaveBeforeBonus[this.numGroups] : p_37731_.spawnsPerWaveBeforeBonus[p_37732_];
    }

    /*
     * WARNING - void declaration
     */
    private int getPotentialBonusSpawns(RaiderType p_219829_, RandomSource p_219830_, int p_219831_, DifficultyInstance p_219832_, boolean p_219833_) {
        void $$13;
        Difficulty $$5 = p_219832_.getDifficulty();
        boolean $$6 = $$5 == Difficulty.EASY;
        boolean $$7 = $$5 == Difficulty.NORMAL;
        switch (p_219829_.ordinal()) {
            case 3: {
                if (!$$6 && p_219831_ > 2 && p_219831_ != 4) {
                    boolean $$8 = true;
                    break;
                }
                return 0;
            }
            case 0: 
            case 2: {
                if ($$6) {
                    int $$9 = p_219830_.nextInt(2);
                    break;
                }
                if ($$7) {
                    boolean $$10 = true;
                    break;
                }
                int $$11 = 2;
                break;
            }
            case 4: {
                boolean $$12 = !$$6 && p_219833_;
                break;
            }
            default: {
                return 0;
            }
        }
        return $$13 > 0 ? p_219830_.nextInt((int)($$13 + true)) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getNumGroups(Difficulty p_37725_) {
        return switch (p_37725_) {
            default -> throw new MatchException(null, null);
            case Difficulty.PEACEFUL -> 0;
            case Difficulty.EASY -> 3;
            case Difficulty.NORMAL -> 5;
            case Difficulty.HARD -> 7;
        };
    }

    public float getEnchantOdds() {
        int $$0 = this.getRaidOmenLevel();
        if ($$0 == 2) {
            return 0.1f;
        }
        if ($$0 == 3) {
            return 0.25f;
        }
        if ($$0 == 4) {
            return 0.5f;
        }
        if ($$0 == 5) {
            return 0.75f;
        }
        return 0.0f;
    }

    public void addHeroOfTheVillage(Entity p_37727_) {
        this.heroesOfTheVillage.add(p_37727_.getUUID());
    }

    static enum RaidStatus implements StringRepresentable
    {
        ONGOING("ongoing"),
        VICTORY("victory"),
        LOSS("loss"),
        STOPPED("stopped");

        public static final Codec<RaidStatus> CODEC;
        private final String name;

        private RaidStatus(String p_401044_) {
            this.name = p_401044_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RaidStatus::values);
        }
    }

    static enum RaiderType {
        VINDICATOR(EntityType.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final RaiderType[] VALUES;
        final EntityType<? extends Raider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType<? extends Raider> p_37821_, int[] p_37822_) {
            this.entityType = p_37821_;
            this.spawnsPerWaveBeforeBonus = p_37822_;
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

