/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_ID_CUSTOM_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private static final boolean DEFAULT_FLIPPED_ROTATION = false;
    private boolean onRails;
    private boolean flipped = false;
    private final MinecartBehavior behavior;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Maps.newEnumMap((Map)((Map)Util.make(() -> {
        Vec3i $$0 = Direction.WEST.getUnitVec3i();
        Vec3i $$1 = Direction.EAST.getUnitVec3i();
        Vec3i $$2 = Direction.NORTH.getUnitVec3i();
        Vec3i $$3 = Direction.SOUTH.getUnitVec3i();
        Vec3i $$4 = $$0.below();
        Vec3i $$5 = $$1.below();
        Vec3i $$6 = $$2.below();
        Vec3i $$7 = $$3.below();
        return ImmutableMap.of((Object)RailShape.NORTH_SOUTH, (Object)Pair.of((Object)$$2, (Object)$$3), (Object)RailShape.EAST_WEST, (Object)Pair.of((Object)$$0, (Object)$$1), (Object)RailShape.ASCENDING_EAST, (Object)Pair.of((Object)$$4, (Object)$$1), (Object)RailShape.ASCENDING_WEST, (Object)Pair.of((Object)$$0, (Object)$$5), (Object)RailShape.ASCENDING_NORTH, (Object)Pair.of((Object)$$2, (Object)$$7), (Object)RailShape.ASCENDING_SOUTH, (Object)Pair.of((Object)$$6, (Object)$$3), (Object)RailShape.SOUTH_EAST, (Object)Pair.of((Object)$$3, (Object)$$1), (Object)RailShape.SOUTH_WEST, (Object)Pair.of((Object)$$3, (Object)$$0), (Object)RailShape.NORTH_WEST, (Object)Pair.of((Object)$$2, (Object)$$0), (Object)RailShape.NORTH_EAST, (Object)Pair.of((Object)$$2, (Object)$$1));
    })));

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.blocksBuilding = true;
        this.behavior = AbstractMinecart.useExperimentalMovement(p_38088_) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.setInitialPos(p_38092_, p_38093_, p_38094_);
    }

    public void setInitialPos(double p_374451_, double p_374374_, double p_374085_) {
        this.setPos(p_374451_, p_374374_, p_374085_);
        this.xo = p_374451_;
        this.yo = p_374374_;
        this.zo = p_374085_;
    }

    @Nullable
    public static <T extends AbstractMinecart> T createMinecart(Level p_366408_, double p_38121_, double p_38122_, double p_38123_, EntityType<T> p_374583_, EntitySpawnReason p_374412_, ItemStack p_305892_, @Nullable Player p_306203_) {
        AbstractMinecart $$8 = (AbstractMinecart)p_374583_.create(p_366408_, p_374412_);
        if ($$8 != null) {
            $$8.setInitialPos(p_38121_, p_38122_, p_38123_);
            EntityType.createDefaultStackConfig(p_366408_, p_305892_, p_306203_).accept($$8);
            MinecartBehavior minecartBehavior = $$8.getBehavior();
            if (minecartBehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior $$9 = (NewMinecartBehavior)minecartBehavior;
                BlockPos $$10 = $$8.getCurrentBlockPosOrRailBelow();
                BlockState $$11 = p_366408_.getBlockState($$10);
                $$9.adjustToRails($$10, $$11, true);
            }
        }
        return (T)$$8;
    }

    public MinecartBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326247_) {
        super.defineSynchedData(p_326247_);
        p_326247_.define(DATA_ID_CUSTOM_DISPLAY_BLOCK, Optional.empty());
        p_326247_.define(DATA_ID_DISPLAY_OFFSET, this.getDefaultDisplayOffset());
    }

    @Override
    public boolean canCollideWith(Entity p_38168_) {
        return AbstractBoat.canVehicleCollide(this, p_38168_);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_38132_, p_38133_));
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity p_294753_, EntityDimensions p_295251_, float p_296054_) {
        boolean $$3;
        boolean bl = $$3 = p_294753_ instanceof Villager || p_294753_ instanceof WanderingTrader;
        if ($$3) {
            return LOWERED_PASSENGER_ATTACHMENT;
        }
        return super.getPassengerAttachmentPoint(p_294753_, p_295251_, p_296054_);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity p_38145_) {
        Direction $$1 = this.getMotionDirection();
        if ($$1.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_38145_);
        }
        int[][] $$2 = DismountHelper.offsetsForDirection($$1);
        BlockPos $$3 = this.blockPosition();
        BlockPos.MutableBlockPos $$4 = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> $$5 = p_38145_.getDismountPoses();
        for (Pose $$6 : $$5) {
            EntityDimensions $$7 = p_38145_.getDimensions($$6);
            float $$8 = Math.min($$7.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)$$6)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int $$9 = (Integer)unmodifiableIterator.next();
                for (int[] $$10 : $$2) {
                    $$4.set($$3.getX() + $$10[0], $$3.getY() + $$9, $$3.getZ() + $$10[1]);
                    double $$11 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level(), $$4), () -> DismountHelper.nonClimbableShape(this.level(), (BlockPos)$$4.below()));
                    if (!DismountHelper.isBlockFloorValid($$11)) continue;
                    AABB $$12 = new AABB(-$$8, 0.0, -$$8, $$8, $$7.height(), $$8);
                    Vec3 $$13 = Vec3.upFromBottomCenterOf($$4, $$11);
                    if (!DismountHelper.canDismountTo(this.level(), p_38145_, $$12.move($$13))) continue;
                    p_38145_.setPose($$6);
                    return $$13;
                }
            }
        }
        double $$14 = this.getBoundingBox().maxY;
        $$4.set((double)$$3.getX(), $$14, (double)$$3.getZ());
        for (Pose $$15 : $$5) {
            int $$17;
            double $$18;
            double $$16 = p_38145_.getDimensions($$15).height();
            if (!($$14 + $$16 <= ($$18 = DismountHelper.findCeilingFrom($$4, $$17 = Mth.ceil($$14 - (double)$$4.getY() + $$16), p_409417_ -> this.level().getBlockState((BlockPos)p_409417_).getCollisionShape(this.level(), (BlockPos)p_409417_))))) continue;
            p_38145_.setPose($$15);
            break;
        }
        return super.getDismountLocationForPassenger(p_38145_);
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState $$0 = this.level().getBlockState(this.blockPosition());
        if ($$0.is(BlockTags.RAILS)) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float p_265349_) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    public static Pair<Vec3i, Vec3i> exits(RailShape p_38126_) {
        return EXITS.get(p_38126_);
    }

    @Override
    public Direction getMotionDirection() {
        return this.behavior.getMotionDirection();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handlePortal();
        this.behavior.tick();
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaIgnite();
            this.lavaHurt();
            this.fallDistance *= 0.5;
        }
        this.firstTick = false;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public BlockPos getCurrentBlockPosOrRailBelow() {
        int $$0 = Mth.floor(this.getX());
        int $$1 = Mth.floor(this.getY());
        int $$2 = Mth.floor(this.getZ());
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            double $$3 = this.getY() - 0.1 - (double)1.0E-5f;
            if (this.level().getBlockState(BlockPos.containing($$0, $$3, $$2)).is(BlockTags.RAILS)) {
                $$1 = Mth.floor($$3);
            }
        } else if (this.level().getBlockState(new BlockPos($$0, $$1 - 1, $$2)).is(BlockTags.RAILS)) {
            --$$1;
        }
        return new BlockPos($$0, $$1, $$2);
    }

    protected double getMaxSpeed(ServerLevel p_376848_) {
        return this.behavior.getMaxSpeed(p_376848_);
    }

    public void activateMinecart(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    @Override
    public void lerpPositionAndRotationStep(int p_364572_, double p_364337_, double p_362183_, double p_362957_, double p_363121_, double p_365178_) {
        super.lerpPositionAndRotationStep(p_364572_, p_364337_, p_362183_, p_362957_, p_363121_, p_365178_);
    }

    @Override
    public void applyGravity() {
        super.applyGravity();
    }

    @Override
    public void reapplyPosition() {
        super.reapplyPosition();
    }

    @Override
    public boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    @Override
    public Vec3 getKnownMovement() {
        return this.behavior.getKnownMovement(super.getKnownMovement());
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.behavior.getInterpolation();
    }

    @Override
    public void lerpMotion(double p_38171_, double p_38172_, double p_38173_) {
        this.behavior.lerpMotion(p_38171_, p_38172_, p_38173_);
    }

    protected void moveAlongTrack(ServerLevel p_376546_) {
        this.behavior.moveAlongTrack(p_376546_);
    }

    protected void comeOffTrack(ServerLevel p_376696_) {
        double $$1 = this.getMaxSpeed(p_376696_);
        Vec3 $$2 = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp($$2.x, -$$1, $$1), $$2.y, Mth.clamp($$2.z, -$$1, $$1));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected double makeStepAlongTrack(BlockPos p_365229_, RailShape p_363321_, double p_364439_) {
        return this.behavior.stepAlongTrack(p_365229_, p_363321_, p_364439_);
    }

    @Override
    public void move(MoverType p_362087_, Vec3 p_363190_) {
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 $$2 = this.position().add(p_363190_);
            super.move(p_362087_, p_363190_);
            boolean $$3 = this.behavior.pushAndPickupEntities();
            if ($$3) {
                super.move(p_362087_, $$2.subtract(this.position()));
            }
            if (p_362087_.equals((Object)MoverType.PISTON)) {
                this.onRails = false;
            }
        } else {
            super.move(p_362087_, p_363190_);
            this.applyEffectsFromBlocks();
        }
    }

    @Override
    public void applyEffectsFromBlocks() {
        if (!AbstractMinecart.useExperimentalMovement(this.level())) {
            this.applyEffectsFromBlocks(this.position(), this.position());
        } else {
            super.applyEffectsFromBlocks();
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    public void setOnRails(boolean p_365128_) {
        this.onRails = p_365128_;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean p_364443_) {
        this.flipped = p_364443_;
    }

    public Vec3 getRedstoneDirection(BlockPos p_361470_) {
        BlockState $$1 = this.level().getBlockState(p_361470_);
        if (!$$1.is(Blocks.POWERED_RAIL) || !$$1.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            return Vec3.ZERO;
        }
        RailShape $$2 = $$1.getValue(((BaseRailBlock)$$1.getBlock()).getShapeProperty());
        if ($$2 == RailShape.EAST_WEST) {
            if (this.isRedstoneConductor(p_361470_.west())) {
                return new Vec3(1.0, 0.0, 0.0);
            }
            if (this.isRedstoneConductor(p_361470_.east())) {
                return new Vec3(-1.0, 0.0, 0.0);
            }
        } else if ($$2 == RailShape.NORTH_SOUTH) {
            if (this.isRedstoneConductor(p_361470_.north())) {
                return new Vec3(0.0, 0.0, 1.0);
            }
            if (this.isRedstoneConductor(p_361470_.south())) {
                return new Vec3(0.0, 0.0, -1.0);
            }
        }
        return Vec3.ZERO;
    }

    public boolean isRedstoneConductor(BlockPos p_38130_) {
        return this.level().getBlockState(p_38130_).isRedstoneConductor(this.level(), p_38130_);
    }

    protected Vec3 applyNaturalSlowdown(Vec3 p_362705_) {
        double $$1 = this.behavior.getSlowdownFactor();
        Vec3 $$2 = p_362705_.multiply($$1, 0.0, $$1);
        if (this.isInWater()) {
            $$2 = $$2.scale(0.95f);
        }
        return $$2;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_38137_) {
        RegistryOps<Tag> $$1 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
        this.setCustomDisplayBlockState(p_38137_.read("DisplayState", BlockState.CODEC, $$1));
        this.setDisplayOffset(p_38137_.getIntOr("DisplayOffset", this.getDefaultDisplayOffset()));
        this.flipped = p_38137_.getBooleanOr("FlippedRotation", false);
        this.firstTick = p_38137_.getBooleanOr("HasTicked", false);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_38151_) {
        this.getCustomDisplayBlockState().ifPresent(p_409416_ -> {
            RegistryOps<Tag> $$2 = this.registryAccess().createSerializationContext(NbtOps.INSTANCE);
            p_38151_.store("DisplayState", BlockState.CODEC, $$2, p_409416_);
        });
        int $$1 = this.getDisplayOffset();
        if ($$1 != this.getDefaultDisplayOffset()) {
            p_38151_.putInt("DisplayOffset", $$1);
        }
        p_38151_.putBoolean("FlippedRotation", this.flipped);
        p_38151_.putBoolean("HasTicked", this.firstTick);
    }

    @Override
    public void push(Entity p_38165_) {
        double $$2;
        if (this.level().isClientSide) {
            return;
        }
        if (p_38165_.noPhysics || this.noPhysics) {
            return;
        }
        if (this.hasPassenger(p_38165_)) {
            return;
        }
        double $$1 = p_38165_.getX() - this.getX();
        double $$3 = $$1 * $$1 + ($$2 = p_38165_.getZ() - this.getZ()) * $$2;
        if ($$3 >= (double)1.0E-4f) {
            $$3 = Math.sqrt($$3);
            $$1 /= $$3;
            $$2 /= $$3;
            double $$4 = 1.0 / $$3;
            if ($$4 > 1.0) {
                $$4 = 1.0;
            }
            $$1 *= $$4;
            $$2 *= $$4;
            $$1 *= (double)0.1f;
            $$2 *= (double)0.1f;
            $$1 *= 0.5;
            $$2 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                AbstractMinecart $$5 = (AbstractMinecart)p_38165_;
                this.pushOtherMinecart($$5, $$1, $$2);
            } else {
                this.push(-$$1, 0.0, -$$2);
                p_38165_.push($$1 / 4.0, 0.0, $$2 / 4.0);
            }
        }
    }

    private void pushOtherMinecart(AbstractMinecart p_374524_, double p_374304_, double p_374378_) {
        double $$6;
        double $$5;
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            double $$3 = this.getDeltaMovement().x;
            double $$4 = this.getDeltaMovement().z;
        } else {
            $$5 = p_374524_.getX() - this.getX();
            $$6 = p_374524_.getZ() - this.getZ();
        }
        Vec3 $$7 = new Vec3($$5, 0.0, $$6).normalize();
        Vec3 $$8 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize();
        double $$9 = Math.abs($$7.dot($$8));
        if ($$9 < (double)0.8f && !AbstractMinecart.useExperimentalMovement(this.level())) {
            return;
        }
        Vec3 $$10 = this.getDeltaMovement();
        Vec3 $$11 = p_374524_.getDeltaMovement();
        if (p_374524_.isFurnace() && !this.isFurnace()) {
            this.setDeltaMovement($$10.multiply(0.2, 1.0, 0.2));
            this.push($$11.x - p_374304_, 0.0, $$11.z - p_374378_);
            p_374524_.setDeltaMovement($$11.multiply(0.95, 1.0, 0.95));
        } else if (!p_374524_.isFurnace() && this.isFurnace()) {
            p_374524_.setDeltaMovement($$11.multiply(0.2, 1.0, 0.2));
            p_374524_.push($$10.x + p_374304_, 0.0, $$10.z + p_374378_);
            this.setDeltaMovement($$10.multiply(0.95, 1.0, 0.95));
        } else {
            double $$12 = ($$11.x + $$10.x) / 2.0;
            double $$13 = ($$11.z + $$10.z) / 2.0;
            this.setDeltaMovement($$10.multiply(0.2, 1.0, 0.2));
            this.push($$12 - p_374304_, 0.0, $$13 - p_374378_);
            p_374524_.setDeltaMovement($$11.multiply(0.2, 1.0, 0.2));
            p_374524_.push($$12 + p_374304_, 0.0, $$13 + p_374378_);
        }
    }

    public BlockState getDisplayBlockState() {
        return this.getCustomDisplayBlockState().orElseGet(this::getDefaultDisplayBlockState);
    }

    private Optional<BlockState> getCustomDisplayBlockState() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY_BLOCK);
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return this.getEntityData().get(DATA_ID_DISPLAY_OFFSET);
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setCustomDisplayBlockState(Optional<BlockState> p_404908_) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY_BLOCK, p_404908_);
    }

    public void setDisplayOffset(int p_38175_) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, p_38175_);
    }

    public static boolean useExperimentalMovement(Level p_360970_) {
        return p_360970_.enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS);
    }

    @Override
    public abstract ItemStack getPickResult();

    public boolean isRideable() {
        return false;
    }

    public boolean isFurnace() {
        return false;
    }
}

