/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantingTableBlock;

public class EnchantmentMenu
extends AbstractContainerMenu {
    static final ResourceLocation EMPTY_SLOT_LAPIS_LAZULI = ResourceLocation.withDefaultNamespace("container/slot/lapis_lazuli");
    private final Container enchantSlots = new SimpleContainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            EnchantmentMenu.this.slotsChanged(this);
        }
    };
    private final ContainerLevelAccess access;
    private final RandomSource random = RandomSource.create();
    private final DataSlot enchantmentSeed = DataSlot.standalone();
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};

    public EnchantmentMenu(int p_39454_, Inventory p_39455_) {
        this(p_39454_, p_39455_, ContainerLevelAccess.NULL);
    }

    public EnchantmentMenu(int p_39457_, Inventory p_39458_, ContainerLevelAccess p_39459_) {
        super(MenuType.ENCHANTMENT, p_39457_);
        this.access = p_39459_;
        this.addSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(ItemStack p_39517_) {
                return p_39517_.is(Items.LAPIS_LAZULI);
            }

            @Override
            public ResourceLocation getNoItemIcon() {
                return EMPTY_SLOT_LAPIS_LAZULI;
            }
        });
        this.addStandardInventorySlots(p_39458_, 8, 84);
        this.addDataSlot(DataSlot.shared(this.costs, 0));
        this.addDataSlot(DataSlot.shared(this.costs, 1));
        this.addDataSlot(DataSlot.shared(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(p_39458_.player.getEnchantmentSeed());
        this.addDataSlot(DataSlot.shared(this.enchantClue, 0));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 1));
        this.addDataSlot(DataSlot.shared(this.enchantClue, 2));
        this.addDataSlot(DataSlot.shared(this.levelClue, 0));
        this.addDataSlot(DataSlot.shared(this.levelClue, 1));
        this.addDataSlot(DataSlot.shared(this.levelClue, 2));
    }

    @Override
    public void slotsChanged(Container p_39461_) {
        if (p_39461_ == this.enchantSlots) {
            ItemStack $$1 = p_39461_.getItem(0);
            if ($$1.isEmpty() || !$$1.isEnchantable()) {
                for (int $$2 = 0; $$2 < 3; ++$$2) {
                    this.costs[$$2] = 0;
                    this.enchantClue[$$2] = -1;
                    this.levelClue[$$2] = -1;
                }
            } else {
                this.access.execute((p_344366_, p_344367_) -> {
                    IdMap<Holder<Holder<Enchantment>>> $$3 = p_344366_.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    int $$4 = 0;
                    for (BlockPos $$5 : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                        if (!EnchantingTableBlock.isValidBookShelf(p_344366_, p_344367_, $$5)) continue;
                        ++$$4;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    for (int $$6 = 0; $$6 < 3; ++$$6) {
                        this.costs[$$6] = EnchantmentHelper.getEnchantmentCost(this.random, $$6, $$4, $$1);
                        this.enchantClue[$$6] = -1;
                        this.levelClue[$$6] = -1;
                        if (this.costs[$$6] >= $$6 + 1) continue;
                        this.costs[$$6] = 0;
                    }
                    for (int $$7 = 0; $$7 < 3; ++$$7) {
                        List<EnchantmentInstance> $$8;
                        if (this.costs[$$7] <= 0 || ($$8 = this.getEnchantmentList(p_344366_.registryAccess(), $$1, $$7, this.costs[$$7])) == null || $$8.isEmpty()) continue;
                        EnchantmentInstance $$9 = $$8.get(this.random.nextInt($$8.size()));
                        this.enchantClue[$$7] = $$3.getId($$9.enchantment());
                        this.levelClue[$$7] = $$9.level();
                    }
                    this.broadcastChanges();
                });
            }
        }
    }

    @Override
    public boolean clickMenuButton(Player p_39465_, int p_39466_) {
        if (p_39466_ < 0 || p_39466_ >= this.costs.length) {
            Util.logAndPauseIfInIde(String.valueOf(p_39465_.getName()) + " pressed invalid button id: " + p_39466_);
            return false;
        }
        ItemStack $$2 = this.enchantSlots.getItem(0);
        ItemStack $$3 = this.enchantSlots.getItem(1);
        int $$4 = p_39466_ + 1;
        if (($$3.isEmpty() || $$3.getCount() < $$4) && !p_39465_.hasInfiniteMaterials()) {
            return false;
        }
        if (this.costs[p_39466_] > 0 && !$$2.isEmpty() && (p_39465_.experienceLevel >= $$4 && p_39465_.experienceLevel >= this.costs[p_39466_] || p_39465_.hasInfiniteMaterials())) {
            this.access.execute((p_347276_, p_347277_) -> {
                ItemStack $$7 = $$2;
                List<EnchantmentInstance> $$8 = this.getEnchantmentList(p_347276_.registryAccess(), $$7, p_39466_, this.costs[p_39466_]);
                if (!$$8.isEmpty()) {
                    p_39465_.onEnchantmentPerformed($$7, $$4);
                    if ($$7.is(Items.BOOK)) {
                        $$7 = $$2.transmuteCopy(Items.ENCHANTED_BOOK);
                        this.enchantSlots.setItem(0, $$7);
                    }
                    for (EnchantmentInstance $$9 : $$8) {
                        $$7.enchant($$9.enchantment(), $$9.level());
                    }
                    $$3.consume($$4, p_39465_);
                    if ($$3.isEmpty()) {
                        this.enchantSlots.setItem(1, ItemStack.EMPTY);
                    }
                    p_39465_.awardStat(Stats.ENCHANT_ITEM);
                    if (p_39465_ instanceof ServerPlayer) {
                        CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)p_39465_, $$7, $$4);
                    }
                    this.enchantSlots.setChanged();
                    this.enchantmentSeed.set(p_39465_.getEnchantmentSeed());
                    this.slotsChanged(this.enchantSlots);
                    p_347276_.playSound(null, (BlockPos)p_347277_, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, p_347276_.random.nextFloat() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(RegistryAccess p_345264_, ItemStack p_39472_, int p_39473_, int p_39474_) {
        this.random.setSeed(this.enchantmentSeed.get() + p_39473_);
        Optional $$4 = p_345264_.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        if ($$4.isEmpty()) {
            return List.of();
        }
        List<EnchantmentInstance> $$5 = EnchantmentHelper.selectEnchantment(this.random, p_39472_, p_39474_, ((HolderSet.Named)$$4.get()).stream());
        if (p_39472_.is(Items.BOOK) && $$5.size() > 1) {
            $$5.remove(this.random.nextInt($$5.size()));
        }
        return $$5;
    }

    public int getGoldCount() {
        ItemStack $$0 = this.enchantSlots.getItem(1);
        if ($$0.isEmpty()) {
            return 0;
        }
        return $$0.getCount();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(Player p_39488_) {
        super.removed(p_39488_);
        this.access.execute((p_39469_, p_39470_) -> this.clearContainer(p_39488_, this.enchantSlots));
    }

    @Override
    public boolean stillValid(Player p_39463_) {
        return EnchantmentMenu.stillValid(this.access, p_39463_, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39490_, int p_39491_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39491_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            if (p_39491_ == 0) {
                if (!this.moveItemStackTo($$4, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (p_39491_ == 1) {
                if (!this.moveItemStackTo($$4, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if ($$4.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo($$4, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!((Slot)this.slots.get(0)).hasItem() && ((Slot)this.slots.get(0)).mayPlace($$4)) {
                ItemStack $$5 = $$4.copyWithCount(1);
                $$4.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer($$5);
            } else {
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
            if ($$4.getCount() == $$2.getCount()) {
                return ItemStack.EMPTY;
            }
            $$3.onTake(p_39490_, $$4);
        }
        return $$2;
    }
}

