/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SmithingMenu
extends ItemCombinerMenu {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final Level level;
    private final RecipePropertySet baseItemTest;
    private final RecipePropertySet templateItemTest;
    private final RecipePropertySet additionItemTest;
    private final DataSlot hasRecipeError = DataSlot.standalone();

    public SmithingMenu(int p_40245_, Inventory p_40246_) {
        this(p_40245_, p_40246_, ContainerLevelAccess.NULL);
    }

    public SmithingMenu(int p_40248_, Inventory p_40249_, ContainerLevelAccess p_40250_) {
        this(p_40248_, p_40249_, p_40250_, p_40249_.player.level());
    }

    private SmithingMenu(int p_379902_, Inventory p_379577_, ContainerLevelAccess p_379989_, Level p_379924_) {
        super(MenuType.SMITHING, p_379902_, p_379577_, p_379989_, SmithingMenu.createInputSlotDefinitions(p_379924_.recipeAccess()));
        this.level = p_379924_;
        this.baseItemTest = p_379924_.recipeAccess().propertySet(RecipePropertySet.SMITHING_BASE);
        this.templateItemTest = p_379924_.recipeAccess().propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        this.additionItemTest = p_379924_.recipeAccess().propertySet(RecipePropertySet.SMITHING_ADDITION);
        this.addDataSlot(this.hasRecipeError).set(0);
    }

    private static ItemCombinerMenuSlotDefinition createInputSlotDefinitions(RecipeAccess p_379456_) {
        RecipePropertySet $$1 = p_379456_.propertySet(RecipePropertySet.SMITHING_BASE);
        RecipePropertySet $$2 = p_379456_.propertySet(RecipePropertySet.SMITHING_TEMPLATE);
        RecipePropertySet $$3 = p_379456_.propertySet(RecipePropertySet.SMITHING_ADDITION);
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 8, 48, $$2::test).withSlot(1, 26, 48, $$1::test).withSlot(2, 44, 48, $$3::test).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(BlockState p_40266_) {
        return p_40266_.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected void onTake(Player p_150663_, ItemStack p_150664_) {
        p_150664_.onCraftedBy(p_150663_, p_150664_.getCount());
        this.resultSlots.awardUsedRecipes(p_150663_, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((p_40263_, p_40264_) -> p_40263_.levelEvent(1044, (BlockPos)p_40264_, 0));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private SmithingRecipeInput createRecipeInput() {
        return new SmithingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private void shrinkStackInSlot(int p_40271_) {
        ItemStack $$1 = this.inputSlots.getItem(p_40271_);
        if (!$$1.isEmpty()) {
            $$1.shrink(1);
            this.inputSlots.setItem(p_40271_, $$1);
        }
    }

    @Override
    public void slotsChanged(Container p_381709_) {
        super.slotsChanged(p_381709_);
        if (this.level instanceof ServerLevel) {
            boolean $$1 = this.getSlot(0).hasItem() && this.getSlot(1).hasItem() && this.getSlot(2).hasItem() && !this.getSlot(this.getResultSlot()).hasItem();
            this.hasRecipeError.set($$1 ? 1 : 0);
        }
    }

    @Override
    public void createResult() {
        Optional<RecipeHolder> $$3;
        SmithingRecipeInput $$0 = this.createRecipeInput();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            Optional<RecipeHolder<SmithingRecipe>> $$2 = $$1.recipeAccess().getRecipeFor(RecipeType.SMITHING, $$0, $$1);
        } else {
            $$3 = Optional.empty();
        }
        $$3.ifPresentOrElse(p_379190_ -> {
            ItemStack $$2 = ((SmithingRecipe)p_379190_.value()).assemble($$0, this.level.registryAccess());
            this.resultSlots.setRecipeUsed((RecipeHolder<?>)p_379190_);
            this.resultSlots.setItem(0, $$2);
        }, () -> {
            this.resultSlots.setRecipeUsed(null);
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack p_40257_, Slot p_40258_) {
        return p_40258_.container != this.resultSlots && super.canTakeItemForPickAll(p_40257_, p_40258_);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack p_266846_) {
        if (this.templateItemTest.test(p_266846_) && !this.getSlot(0).hasItem()) {
            return true;
        }
        if (this.baseItemTest.test(p_266846_) && !this.getSlot(1).hasItem()) {
            return true;
        }
        return this.additionItemTest.test(p_266846_) && !this.getSlot(2).hasItem();
    }

    public boolean hasRecipeError() {
        return this.hasRecipeError.get() > 0;
    }
}

