/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoatItem
extends Item {
    private final EntityType<? extends AbstractBoat> entityType;

    public BoatItem(EntityType<? extends AbstractBoat> p_376667_, Item.Properties p_220015_) {
        super(p_220015_);
        this.entityType = p_376667_;
    }

    @Override
    public InteractionResult use(Level p_40622_, Player p_40623_, InteractionHand p_40624_) {
        ItemStack $$3 = p_40623_.getItemInHand(p_40624_);
        BlockHitResult $$4 = BoatItem.getPlayerPOVHitResult(p_40622_, p_40623_, ClipContext.Fluid.ANY);
        if (((HitResult)$$4).getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 $$5 = p_40623_.getViewVector(1.0f);
        double $$6 = 5.0;
        List<Entity> $$7 = p_40622_.getEntities(p_40623_, p_40623_.getBoundingBox().expandTowards($$5.scale(5.0)).inflate(1.0), EntitySelector.CAN_BE_PICKED);
        if (!$$7.isEmpty()) {
            Vec3 $$8 = p_40623_.getEyePosition();
            for (Entity $$9 : $$7) {
                AABB $$10 = $$9.getBoundingBox().inflate($$9.getPickRadius());
                if (!$$10.contains($$8)) continue;
                return InteractionResult.PASS;
            }
        }
        if (((HitResult)$$4).getType() == HitResult.Type.BLOCK) {
            AbstractBoat $$11 = this.getBoat(p_40622_, $$4, $$3, p_40623_);
            if ($$11 == null) {
                return InteractionResult.FAIL;
            }
            $$11.setYRot(p_40623_.getYRot());
            if (!p_40622_.noCollision($$11, $$11.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            if (!p_40622_.isClientSide) {
                p_40622_.addFreshEntity($$11);
                p_40622_.gameEvent((Entity)p_40623_, GameEvent.ENTITY_PLACE, $$4.getLocation());
                $$3.consume(1, p_40623_);
            }
            p_40623_.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private AbstractBoat getBoat(Level p_220017_, HitResult p_220018_, ItemStack p_305852_, Player p_306127_) {
        AbstractBoat $$4 = this.entityType.create(p_220017_, EntitySpawnReason.SPAWN_ITEM_USE);
        if ($$4 != null) {
            Vec3 $$5 = p_220018_.getLocation();
            $$4.setInitialPos($$5.x, $$5.y, $$5.z);
            if (p_220017_ instanceof ServerLevel) {
                ServerLevel $$6 = (ServerLevel)p_220017_;
                EntityType.createDefaultStackConfig($$6, p_305852_, p_306127_).accept($$4);
            }
        }
        return $$4;
    }
}

