/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BottleItem
extends Item {
    public BottleItem(Item.Properties p_40648_) {
        super(p_40648_);
    }

    @Override
    public InteractionResult use(Level p_40656_, Player p_40657_, InteractionHand p_40658_) {
        List<AreaEffectCloud> $$3 = p_40656_.getEntitiesOfClass(AreaEffectCloud.class, p_40657_.getBoundingBox().inflate(2.0), p_409423_ -> p_409423_ != null && p_409423_.isAlive() && p_409423_.getOwner() instanceof EnderDragon);
        ItemStack $$4 = p_40657_.getItemInHand(p_40658_);
        if (!$$3.isEmpty()) {
            AreaEffectCloud $$5 = $$3.get(0);
            $$5.setRadius($$5.getRadius() - 0.5f);
            p_40656_.playSound(null, p_40657_.getX(), p_40657_.getY(), p_40657_.getZ(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            p_40656_.gameEvent((Entity)p_40657_, GameEvent.FLUID_PICKUP, p_40657_.position());
            if (p_40657_ instanceof ServerPlayer) {
                ServerPlayer $$6 = (ServerPlayer)p_40657_;
                CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger($$6, $$4, $$5);
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem($$4, p_40657_, new ItemStack(Items.DRAGON_BREATH)));
        }
        BlockHitResult $$7 = BottleItem.getPlayerPOVHitResult(p_40656_, p_40657_, ClipContext.Fluid.SOURCE_ONLY);
        if ($$7.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if ($$7.getType() == HitResult.Type.BLOCK) {
            BlockPos $$8 = $$7.getBlockPos();
            if (!p_40656_.mayInteract(p_40657_, $$8)) {
                return InteractionResult.PASS;
            }
            if (p_40656_.getFluidState($$8).is(FluidTags.WATER)) {
                p_40656_.playSound((Entity)p_40657_, p_40657_.getX(), p_40657_.getY(), p_40657_.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                p_40656_.gameEvent((Entity)p_40657_, GameEvent.FLUID_PICKUP, $$8);
                return InteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem($$4, p_40657_, PotionContents.createItemStack(Items.POTION, Potions.WATER)));
            }
        }
        return InteractionResult.PASS;
    }

    protected ItemStack turnBottleIntoItem(ItemStack p_40652_, Player p_40653_, ItemStack p_40654_) {
        p_40653_.awardStat(Stats.ITEM_USED.get(this));
        return ItemUtils.createFilledResult(p_40652_, p_40653_, p_40654_);
    }
}

