/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties p_41180_) {
        super(p_41180_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_41182_) {
        BlockPos $$2;
        Level $$1 = p_41182_.getLevel();
        BlockState $$3 = $$1.getBlockState($$2 = p_41182_.getClickedPos());
        if (!$$3.is(Blocks.END_PORTAL_FRAME) || $$3.getValue(EndPortalFrameBlock.HAS_EYE).booleanValue()) {
            return InteractionResult.PASS;
        }
        if ($$1.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState $$4 = (BlockState)$$3.setValue(EndPortalFrameBlock.HAS_EYE, true);
        Block.pushEntitiesUp($$3, $$4, $$1, $$2);
        $$1.setBlock($$2, $$4, 2);
        $$1.updateNeighbourForOutputSignal($$2, Blocks.END_PORTAL_FRAME);
        p_41182_.getItemInHand().shrink(1);
        $$1.levelEvent(1503, $$2, 0);
        BlockPattern.BlockPatternMatch $$5 = EndPortalFrameBlock.getOrCreatePortalShape().find($$1, $$2);
        if ($$5 != null) {
            BlockPos $$6 = $$5.getFrontTopLeft().offset(-3, 0, -3);
            for (int $$7 = 0; $$7 < 3; ++$$7) {
                for (int $$8 = 0; $$8 < 3; ++$$8) {
                    BlockPos $$9 = $$6.offset($$7, 0, $$8);
                    $$1.destroyBlock($$9, true, null);
                    $$1.setBlock($$9, Blocks.END_PORTAL.defaultBlockState(), 2);
                }
            }
            $$1.globalLevelEvent(1038, $$6.offset(1, 0, 1), 0);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getUseDuration(ItemStack p_326954_, LivingEntity p_346241_) {
        return 0;
    }

    @Override
    public InteractionResult use(Level p_41184_, Player p_41185_, InteractionHand p_41186_) {
        ItemStack $$3 = p_41185_.getItemInHand(p_41186_);
        BlockHitResult $$4 = EnderEyeItem.getPlayerPOVHitResult(p_41184_, p_41185_, ClipContext.Fluid.NONE);
        if ($$4.getType() == HitResult.Type.BLOCK && p_41184_.getBlockState($$4.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResult.PASS;
        }
        p_41185_.startUsingItem(p_41186_);
        if (p_41184_ instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)p_41184_;
            BlockPos $$6 = $$5.findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, p_41185_.blockPosition(), 100, false);
            if ($$6 == null) {
                return InteractionResult.CONSUME;
            }
            EyeOfEnder $$7 = new EyeOfEnder(p_41184_, p_41185_.getX(), p_41185_.getY(0.5), p_41185_.getZ());
            $$7.setItem($$3);
            $$7.signalTo($$6);
            p_41184_.gameEvent(GameEvent.PROJECTILE_SHOOT, $$7.position(), GameEvent.Context.of(p_41185_));
            p_41184_.addFreshEntity($$7);
            if (p_41185_ instanceof ServerPlayer) {
                ServerPlayer $$8 = (ServerPlayer)p_41185_;
                CriteriaTriggers.USED_ENDER_EYE.trigger($$8, $$6);
            }
            float $$9 = Mth.lerp(p_41184_.random.nextFloat(), 0.33f, 0.5f);
            p_41184_.playSound(null, p_41185_.getX(), p_41185_.getY(), p_41185_.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 1.0f, $$9);
            $$3.consume(1, p_41185_);
            p_41185_.awardStat(Stats.ITEM_USED.get(this));
        }
        return InteractionResult.SUCCESS_SERVER;
    }
}

