/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShovelItem
extends Item {
    protected static final Map<Block, BlockState> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public ShovelItem(ToolMaterial p_361048_, float p_360325_, float p_364346_, Item.Properties p_43117_) {
        super(p_43117_.shovel(p_361048_, p_360325_, p_364346_));
    }

    @Override
    public InteractionResult useOn(UseOnContext p_43119_) {
        Level $$1 = p_43119_.getLevel();
        BlockPos $$2 = p_43119_.getClickedPos();
        BlockState $$3 = $$1.getBlockState($$2);
        if (p_43119_.getClickedFace() != Direction.DOWN) {
            Player $$4 = p_43119_.getPlayer();
            BlockState $$5 = FLATTENABLES.get($$3.getBlock());
            BlockState $$6 = null;
            if ($$5 != null && $$1.getBlockState($$2.above()).isAir()) {
                $$1.playSound((Entity)$$4, $$2, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                $$6 = $$5;
            } else if ($$3.getBlock() instanceof CampfireBlock && $$3.getValue(CampfireBlock.LIT).booleanValue()) {
                if (!$$1.isClientSide()) {
                    $$1.levelEvent(null, 1009, $$2, 0);
                }
                CampfireBlock.dowse(p_43119_.getPlayer(), $$1, $$2, $$3);
                $$6 = (BlockState)$$3.setValue(CampfireBlock.LIT, false);
            }
            if ($$6 != null) {
                if (!$$1.isClientSide) {
                    $$1.setBlock($$2, $$6, 11);
                    $$1.gameEvent(GameEvent.BLOCK_CHANGE, $$2, GameEvent.Context.of($$4, $$6));
                    if ($$4 != null) {
                        p_43119_.getItemInHand().hurtAndBreak(1, $$4, LivingEntity.getSlotForHand(p_43119_.getHand()));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

