/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();
    private final EntityType<?> defaultType;

    public SpawnEggItem(EntityType<? extends Mob> p_43207_, Item.Properties p_43210_) {
        super(p_43210_);
        this.defaultType = p_43207_;
        BY_ID.put(p_43207_, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_43223_) {
        BlockPos $$9;
        Level $$1 = p_43223_.getLevel();
        if ($$1.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack $$2 = p_43223_.getItemInHand();
        BlockPos $$3 = p_43223_.getClickedPos();
        Direction $$4 = p_43223_.getClickedFace();
        BlockState $$5 = $$1.getBlockState($$3);
        BlockEntity blockEntity = $$1.getBlockEntity($$3);
        if (blockEntity instanceof Spawner) {
            Spawner $$6 = (Spawner)((Object)blockEntity);
            EntityType<?> $$7 = this.getType($$1.registryAccess(), $$2);
            $$6.setEntityId($$7, $$1.getRandom());
            $$1.sendBlockUpdated($$3, $$5, $$5, 3);
            $$1.gameEvent((Entity)p_43223_.getPlayer(), GameEvent.BLOCK_CHANGE, $$3);
            $$2.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if ($$5.getCollisionShape($$1, $$3).isEmpty()) {
            BlockPos $$8 = $$3;
        } else {
            $$9 = $$3.relative($$4);
        }
        EntityType<?> $$10 = this.getType($$1.registryAccess(), $$2);
        if ($$10.spawn((ServerLevel)$$1, $$2, p_43223_.getPlayer(), $$9, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals($$3, $$9) && $$4 == Direction.UP) != null) {
            $$2.shrink(1);
            $$1.gameEvent((Entity)p_43223_.getPlayer(), GameEvent.ENTITY_PLACE, $$3);
        }
        return InteractionResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult use(Level p_43225_, Player p_43226_, InteractionHand p_43227_) {
        void $$6;
        ItemStack $$3 = p_43226_.getItemInHand(p_43227_);
        BlockHitResult $$4 = SpawnEggItem.getPlayerPOVHitResult(p_43225_, p_43226_, ClipContext.Fluid.SOURCE_ONLY);
        if ($$4.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (!(p_43225_ instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel $$5 = (ServerLevel)p_43225_;
        BlockHitResult $$7 = $$4;
        BlockPos $$8 = $$7.getBlockPos();
        if (!(p_43225_.getBlockState($$8).getBlock() instanceof LiquidBlock)) {
            return InteractionResult.PASS;
        }
        if (!p_43225_.mayInteract(p_43226_, $$8) || !p_43226_.mayUseItemAt($$8, $$7.getDirection(), $$3)) {
            return InteractionResult.FAIL;
        }
        EntityType<?> $$9 = this.getType($$6.registryAccess(), $$3);
        Object $$10 = $$9.spawn((ServerLevel)$$6, $$3, p_43226_, $$8, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
        if ($$10 == null) {
            return InteractionResult.PASS;
        }
        $$3.consume(1, p_43226_);
        p_43226_.awardStat(Stats.ITEM_USED.get(this));
        p_43225_.gameEvent((Entity)p_43226_, GameEvent.ENTITY_PLACE, ((Entity)$$10).position());
        return InteractionResult.SUCCESS;
    }

    public boolean spawnsEntity(HolderLookup.Provider p_390481_, ItemStack p_330965_, EntityType<?> p_43232_) {
        return Objects.equals(this.getType(p_390481_, p_330965_), p_43232_);
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> p_43214_) {
        return BY_ID.get(p_43214_);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityType<?> getType(HolderLookup.Provider p_390418_, ItemStack p_330335_) {
        EntityType<?> $$3;
        CustomData $$2 = p_330335_.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!$$2.isEmpty() && ($$3 = $$2.parseEntityType(p_390418_, Registries.ENTITY_TYPE)) != null) {
            return $$3;
        }
        return this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player p_43216_, Mob p_43217_, EntityType<? extends Mob> p_43218_, ServerLevel p_43219_, Vec3 p_43220_, ItemStack p_43221_) {
        Mob $$7;
        if (!this.spawnsEntity(p_43219_.registryAccess(), p_43221_, p_43218_)) {
            return Optional.empty();
        }
        if (p_43217_ instanceof AgeableMob) {
            AgeableMob $$6 = ((AgeableMob)p_43217_).getBreedOffspring(p_43219_, (AgeableMob)p_43217_);
        } else {
            $$7 = p_43218_.create(p_43219_, EntitySpawnReason.SPAWN_ITEM_USE);
        }
        if ($$7 == null) {
            return Optional.empty();
        }
        $$7.setBaby(true);
        if (!$$7.isBaby()) {
            return Optional.empty();
        }
        $$7.snapTo(p_43220_.x(), p_43220_.y(), p_43220_.z(), 0.0f, 0.0f);
        $$7.applyComponentsFromItemStack(p_43221_);
        p_43219_.addFreshEntityWithPassengers($$7);
        p_43221_.consume(1, p_43216_);
        return Optional.of($$7);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack p_390471_, @Nullable Player p_390407_) {
        CustomData $$2;
        if (p_390407_ != null && p_390407_.getPermissionLevel() >= 2 && ($$2 = p_390471_.get(DataComponents.ENTITY_DATA)) != null) {
            EntityType<?> $$3 = $$2.parseEntityType(p_390407_.level().registryAccess(), Registries.ENTITY_TYPE);
            return $$3 != null && $$3.onlyOpCanSetNbt();
        }
        return false;
    }
}

