/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class WindChargeItem
extends Item
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 1.5f;

    public WindChargeItem(Item.Properties p_326377_) {
        super(p_326377_);
    }

    @Override
    public InteractionResult use(Level p_326306_, Player p_326042_, InteractionHand p_326470_) {
        ItemStack $$3 = p_326042_.getItemInHand(p_326470_);
        if (p_326306_ instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)p_326306_;
            Projectile.spawnProjectileFromRotation((p_409441_, p_409442_, p_409443_) -> new WindCharge(p_326042_, p_326306_, p_326042_.position().x(), p_326042_.getEyePosition().y(), p_326042_.position().z()), $$4, $$3, p_326042_, 0.0f, PROJECTILE_SHOOT_POWER, 1.0f);
        }
        p_326306_.playSound(null, p_326042_.getX(), p_326042_.getY(), p_326042_.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (p_326306_.getRandom().nextFloat() * 0.4f + 0.8f));
        p_326042_.awardStat(Stats.ITEM_USED.get(this));
        $$3.consume(1, p_326042_);
        return InteractionResult.SUCCESS;
    }

    @Override
    public Projectile asProjectile(Level p_338589_, Position p_338670_, ItemStack p_338308_, Direction p_338206_) {
        RandomSource $$4 = p_338589_.getRandom();
        double $$5 = $$4.triangle((double)p_338206_.getStepX(), 0.11485000000000001);
        double $$6 = $$4.triangle((double)p_338206_.getStepY(), 0.11485000000000001);
        double $$7 = $$4.triangle((double)p_338206_.getStepZ(), 0.11485000000000001);
        Vec3 $$8 = new Vec3($$5, $$6, $$7);
        WindCharge $$9 = new WindCharge(p_338589_, p_338670_.x(), p_338670_.y(), p_338670_.z(), $$8);
        $$9.setDeltaMovement($$8);
        return $$9;
    }

    @Override
    public void shoot(Projectile p_338260_, double p_338763_, double p_338177_, double p_338349_, float p_338273_, float p_338257_) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((p_338288_, p_338801_) -> DispenserBlock.getDispensePosition(p_338288_, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1051).build();
    }
}

