/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;

public record PotionContents(Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects, Optional<String> customName) implements ConsumableListener,
TooltipProvider
{
    private final List<MobEffectInstance> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final Component NO_EFFECT = Component.translatable("effect.none").withStyle(ChatFormatting.GRAY);
    public static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(p_372777_ -> p_372777_.group((App)Potion.CODEC.optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::customName)).apply((Applicative)p_372777_, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, Potion.CODEC, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite(Potion.STREAM_CODEC.apply(ByteBufCodecs::optional), PotionContents::potion, ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), PotionContents::customName, PotionContents::new);

    public PotionContents(Holder<Potion> p_331208_) {
        this(Optional.of(p_331208_), Optional.empty(), List.of(), Optional.empty());
    }

    public static ItemStack createItemStack(Item p_330388_, Holder<Potion> p_331030_) {
        ItemStack $$2 = new ItemStack(p_330388_);
        $$2.set(DataComponents.POTION_CONTENTS, new PotionContents(p_331030_));
        return $$2;
    }

    public boolean is(Holder<Potion> p_331328_) {
        return this.potion.isPresent() && this.potion.get().is(p_331328_) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        if (this.potion.isEmpty()) {
            return this.customEffects;
        }
        if (this.customEffects.isEmpty()) {
            return this.potion.get().value().getEffects();
        }
        return Iterables.concat(this.potion.get().value().getEffects(), this.customEffects);
    }

    public void forEachEffect(Consumer<MobEffectInstance> p_331190_, float p_394070_) {
        if (this.potion.isPresent()) {
            for (MobEffectInstance $$2 : this.potion.get().value().getEffects()) {
                p_331190_.accept($$2.withScaledDuration(p_394070_));
            }
        }
        for (MobEffectInstance $$3 : this.customEffects) {
            p_331190_.accept($$3.withScaledDuration(p_394070_));
        }
    }

    public PotionContents withPotion(Holder<Potion> p_330288_) {
        return new PotionContents(Optional.of(p_330288_), this.customColor, this.customEffects, this.customName);
    }

    public PotionContents withEffectAdded(MobEffectInstance p_332083_) {
        return new PotionContents(this.potion, this.customColor, Util.copyAndAdd(this.customEffects, p_332083_), this.customName);
    }

    public int getColor() {
        return this.getColorOr(-13083194);
    }

    public int getColorOr(int p_388208_) {
        if (this.customColor.isPresent()) {
            return this.customColor.get();
        }
        return PotionContents.getColorOptional(this.getAllEffects()).orElse(p_388208_);
    }

    public Component getName(String p_372972_) {
        String $$1 = this.customName.or(() -> this.potion.map(p_372776_ -> ((Potion)p_372776_.value()).name())).orElse("empty");
        return Component.translatable(p_372972_ + $$1);
    }

    public static OptionalInt getColorOptional(Iterable<MobEffectInstance> p_332699_) {
        int $$1 = 0;
        int $$2 = 0;
        int $$3 = 0;
        int $$4 = 0;
        for (MobEffectInstance $$5 : p_332699_) {
            if (!$$5.isVisible()) continue;
            int $$6 = $$5.getEffect().value().getColor();
            int $$7 = $$5.getAmplifier() + 1;
            $$1 += $$7 * ARGB.red($$6);
            $$2 += $$7 * ARGB.green($$6);
            $$3 += $$7 * ARGB.blue($$6);
            $$4 += $$7;
        }
        if ($$4 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ARGB.color($$1 / $$4, $$2 / $$4, $$3 / $$4));
    }

    public boolean hasEffects() {
        if (!this.customEffects.isEmpty()) {
            return true;
        }
        return this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffectInstance> customEffects() {
        return Lists.transform(this.customEffects, MobEffectInstance::new);
    }

    /*
     * WARNING - void declaration
     */
    public void applyToLivingEntity(LivingEntity p_366471_, float p_393741_) {
        void $$3;
        Player $$4;
        Level level = p_366471_.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$2 = (ServerLevel)level;
        Player $$5 = p_366471_ instanceof Player ? ($$4 = (Player)p_366471_) : null;
        this.forEachEffect(arg_0 -> PotionContents.lambda$applyToLivingEntity$3((ServerLevel)$$3, $$5, p_366471_, arg_0), p_393741_);
    }

    public static void addPotionTooltip(Iterable<MobEffectInstance> p_331825_, Consumer<Component> p_331296_, float p_332038_, float p_332014_) {
        ArrayList $$4 = Lists.newArrayList();
        boolean $$5 = true;
        for (MobEffectInstance $$6 : p_331825_) {
            $$5 = false;
            Holder<MobEffect> $$7 = $$6.getEffect();
            int $$8 = $$6.getAmplifier();
            $$7.value().createModifiers($$8, (p_331556_, p_330860_) -> $$4.add(new Pair(p_331556_, p_330860_)));
            MutableComponent $$9 = PotionContents.getPotionDescription($$7, $$8);
            if (!$$6.endsWithin(20)) {
                $$9 = Component.translatable("potion.withDuration", $$9, MobEffectUtil.formatDuration($$6, p_332038_, p_332014_));
            }
            p_331296_.accept($$9.withStyle($$7.value().getCategory().getTooltipFormatting()));
        }
        if ($$5) {
            p_331296_.accept(NO_EFFECT);
        }
        if (!$$4.isEmpty()) {
            p_331296_.accept(CommonComponents.EMPTY);
            p_331296_.accept(Component.translatable("potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair $$10 : $$4) {
                double $$14;
                AttributeModifier $$11 = (AttributeModifier)$$10.getSecond();
                double $$12 = $$11.amount();
                if ($$11.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || $$11.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                    double $$13 = $$11.amount() * 100.0;
                } else {
                    $$14 = $$11.amount();
                }
                if ($$12 > 0.0) {
                    p_331296_.accept(Component.translatable("attribute.modifier.plus." + $$11.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format($$14), Component.translatable(((Attribute)((Holder)$$10.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!($$12 < 0.0)) continue;
                p_331296_.accept(Component.translatable("attribute.modifier.take." + $$11.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format($$14 *= -1.0), Component.translatable(((Attribute)((Holder)$$10.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.RED));
            }
        }
    }

    public static MutableComponent getPotionDescription(Holder<MobEffect> p_397215_, int p_397091_) {
        MutableComponent $$2 = Component.translatable(p_397215_.value().getDescriptionId());
        if (p_397091_ > 0) {
            return Component.translatable("potion.withAmplifier", $$2, Component.translatable("potion.potency." + p_397091_));
        }
        return $$2;
    }

    @Override
    public void onConsume(Level p_366836_, LivingEntity p_366750_, ItemStack p_366399_, Consumable p_366541_) {
        this.applyToLivingEntity(p_366750_, p_366399_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue());
    }

    @Override
    public void addToTooltip(Item.TooltipContext p_399531_, Consumer<Component> p_399764_, TooltipFlag p_400075_, DataComponentGetter p_400022_) {
        PotionContents.addPotionTooltip(this.getAllEffects(), p_399764_, p_400022_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue(), p_399531_.tickRate());
    }

    private static /* synthetic */ void lambda$applyToLivingEntity$3(ServerLevel p_376015_, Player p_376016_, LivingEntity p_376017_, MobEffectInstance p_376018_) {
        if (p_376018_.getEffect().value().isInstantenous()) {
            p_376018_.getEffect().value().applyInstantenousEffect(p_376015_, p_376016_, p_376016_, p_376017_, p_376018_.getAmplifier(), 1.0);
        } else {
            p_376017_.addEffect(p_376018_);
        }
    }
}

