/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public record Equippable(EquipmentSlot slot, Holder<SoundEvent> equipSound, Optional<ResourceKey<EquipmentAsset>> assetId, Optional<ResourceLocation> cameraOverlay, Optional<HolderSet<EntityType<?>>> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract) {
    public static final Codec<Equippable> CODEC = RecordCodecBuilder.create(p_380896_ -> p_380896_.group((App)EquipmentSlot.CODEC.fieldOf("slot").forGetter(Equippable::slot), (App)SoundEvent.CODEC.optionalFieldOf("equip_sound", SoundEvents.ARMOR_EQUIP_GENERIC).forGetter(Equippable::equipSound), (App)ResourceKey.codec(EquipmentAssets.ROOT_ID).optionalFieldOf("asset_id").forGetter(Equippable::assetId), (App)ResourceLocation.CODEC.optionalFieldOf("camera_overlay").forGetter(Equippable::cameraOverlay), (App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).optionalFieldOf("allowed_entities").forGetter(Equippable::allowedEntities), (App)Codec.BOOL.optionalFieldOf("dispensable", (Object)true).forGetter(Equippable::dispensable), (App)Codec.BOOL.optionalFieldOf("swappable", (Object)true).forGetter(Equippable::swappable), (App)Codec.BOOL.optionalFieldOf("damage_on_hurt", (Object)true).forGetter(Equippable::damageOnHurt), (App)Codec.BOOL.optionalFieldOf("equip_on_interact", (Object)false).forGetter(Equippable::equipOnInteract)).apply((Applicative)p_380896_, Equippable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Equippable> STREAM_CODEC = StreamCodec.composite(EquipmentSlot.STREAM_CODEC, Equippable::slot, SoundEvent.STREAM_CODEC, Equippable::equipSound, ResourceKey.streamCodec(EquipmentAssets.ROOT_ID).apply(ByteBufCodecs::optional), Equippable::assetId, ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs::optional), Equippable::cameraOverlay, ByteBufCodecs.holderSet(Registries.ENTITY_TYPE).apply(ByteBufCodecs::optional), Equippable::allowedEntities, ByteBufCodecs.BOOL, Equippable::dispensable, ByteBufCodecs.BOOL, Equippable::swappable, ByteBufCodecs.BOOL, Equippable::damageOnHurt, ByteBufCodecs.BOOL, Equippable::equipOnInteract, Equippable::new);

    public static Equippable llamaSwag(DyeColor p_371759_) {
        return Equippable.builder(EquipmentSlot.BODY).setEquipSound(SoundEvents.LLAMA_SWAG).setAsset(EquipmentAssets.CARPETS.get(p_371759_)).setAllowedEntities(EntityType.LLAMA, EntityType.TRADER_LLAMA).build();
    }

    public static Equippable saddle() {
        HolderGetter<EntityType<?>> $$0 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
        return Equippable.builder(EquipmentSlot.SADDLE).setEquipSound(SoundEvents.HORSE_SADDLE).setAsset(EquipmentAssets.SADDLE).setAllowedEntities($$0.getOrThrow(EntityTypeTags.CAN_EQUIP_SADDLE)).setEquipOnInteract(true).build();
    }

    public static Builder builder(EquipmentSlot p_373113_) {
        return new Builder(p_373113_);
    }

    public InteractionResult swapWithEquipmentSlot(ItemStack p_371218_, Player p_371907_) {
        if (!p_371907_.canUseSlot(this.slot) || !this.canBeEquippedBy(p_371907_.getType())) {
            return InteractionResult.PASS;
        }
        ItemStack $$2 = p_371907_.getItemBySlot(this.slot);
        if (EnchantmentHelper.has($$2, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !p_371907_.isCreative() || ItemStack.isSameItemSameComponents(p_371218_, $$2)) {
            return InteractionResult.FAIL;
        }
        if (!p_371907_.level().isClientSide()) {
            p_371907_.awardStat(Stats.ITEM_USED.get(p_371218_.getItem()));
        }
        if (p_371218_.getCount() <= 1) {
            ItemStack $$3 = $$2.isEmpty() ? p_371218_ : $$2.copyAndClear();
            ItemStack $$4 = p_371907_.isCreative() ? p_371218_.copy() : p_371218_.copyAndClear();
            p_371907_.setItemSlot(this.slot, $$4);
            return InteractionResult.SUCCESS.heldItemTransformedTo($$3);
        }
        ItemStack $$5 = $$2.copyAndClear();
        ItemStack $$6 = p_371218_.consumeAndReturn(1, p_371907_);
        p_371907_.setItemSlot(this.slot, $$6);
        if (!p_371907_.getInventory().add($$5)) {
            p_371907_.drop($$5, false);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(p_371218_);
    }

    public InteractionResult equipOnTarget(Player p_397505_, LivingEntity p_397083_, ItemStack p_397903_) {
        if (!p_397083_.isEquippableInSlot(p_397903_, this.slot) || p_397083_.hasItemInSlot(this.slot) || !p_397083_.isAlive()) {
            return InteractionResult.PASS;
        }
        if (!p_397505_.level().isClientSide()) {
            p_397083_.setItemSlot(this.slot, p_397903_.split(1));
            if (p_397083_ instanceof Mob) {
                Mob $$3 = (Mob)p_397083_;
                $$3.setGuaranteedDrop(this.slot);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canBeEquippedBy(EntityType<?> p_371805_) {
        return this.allowedEntities.isEmpty() || this.allowedEntities.get().contains(p_371805_.builtInRegistryHolder());
    }

    public static class Builder {
        private final EquipmentSlot slot;
        private Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
        private Optional<ResourceKey<EquipmentAsset>> assetId = Optional.empty();
        private Optional<ResourceLocation> cameraOverlay = Optional.empty();
        private Optional<HolderSet<EntityType<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;
        private boolean equipOnInteract;

        Builder(EquipmentSlot p_373069_) {
            this.slot = p_373069_;
        }

        public Builder setEquipSound(Holder<SoundEvent> p_372976_) {
            this.equipSound = p_372976_;
            return this;
        }

        public Builder setAsset(ResourceKey<EquipmentAsset> p_388051_) {
            this.assetId = Optional.of(p_388051_);
            return this;
        }

        public Builder setCameraOverlay(ResourceLocation p_380964_) {
            this.cameraOverlay = Optional.of(p_380964_);
            return this;
        }

        public Builder setAllowedEntities(EntityType<?> ... p_372825_) {
            return this.setAllowedEntities(HolderSet.direct(EntityType::builtInRegistryHolder, p_372825_));
        }

        public Builder setAllowedEntities(HolderSet<EntityType<?>> p_373030_) {
            this.allowedEntities = Optional.of(p_373030_);
            return this;
        }

        public Builder setDispensable(boolean p_372806_) {
            this.dispensable = p_372806_;
            return this;
        }

        public Builder setSwappable(boolean p_372919_) {
            this.swappable = p_372919_;
            return this;
        }

        public Builder setDamageOnHurt(boolean p_372981_) {
            this.damageOnHurt = p_372981_;
            return this;
        }

        public Builder setEquipOnInteract(boolean p_397609_) {
            this.equipOnInteract = p_397609_;
            return this;
        }

        public Equippable build() {
            return new Equippable(this.slot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract);
        }
    }
}

