/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BaseSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final int EVENT_SPAWN = 1;
    private static final int DEFAULT_SPAWN_DELAY = 20;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 6;
    private static final int DEFAULT_REQUIRED_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    private int spawnDelay = 20;
    private WeightedList<SpawnData> spawnPotentials = WeightedList.of();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.getOrCreateNextSpawnData(p_254041_, p_254221_, p_254050_).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(p_253682_).toString());
    }

    private boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.hasNearbyAlivePlayer((double)p_151345_.getX() + 0.5, (double)p_151345_.getY() + 0.5, (double)p_151345_.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level p_151320_, BlockPos p_151321_) {
        if (!this.isNearPlayer(p_151320_, p_151321_)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource $$2 = p_151320_.getRandom();
            double $$3 = (double)p_151321_.getX() + $$2.nextDouble();
            double $$4 = (double)p_151321_.getY() + $$2.nextDouble();
            double $$5 = (double)p_151321_.getZ() + $$2.nextDouble();
            p_151320_.addParticle(ParticleTypes.SMOKE, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            p_151320_.addParticle(ParticleTypes.FLAME, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel p_151312_, BlockPos p_151313_) {
        if (!this.isNearPlayer(p_151312_, p_151313_)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(p_151312_, p_151313_);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean $$2 = false;
        RandomSource $$3 = p_151312_.getRandom();
        SpawnData $$4 = this.getOrCreateNextSpawnData(p_151312_, $$3, p_151313_);
        for (int $$5 = 0; $$5 < this.spawnCount; ++$$5) {
            SpawnData.CustomSpawnRules $$10;
            CompoundTag $$6 = $$4.getEntityToSpawn();
            Optional<EntityType<?>> $$7 = EntityType.by($$6);
            if ($$7.isEmpty()) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            Vec3 $$8 = $$6.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)p_151313_.getX() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5, p_151313_.getY() + $$3.nextInt(3) - 1, (double)p_151313_.getZ() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5));
            if (!p_151312_.noCollision($$7.get().getSpawnAABB($$8.x, $$8.y, $$8.z))) continue;
            BlockPos $$9 = BlockPos.containing($$8);
            if (!$$4.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules($$7.get(), p_151312_, EntitySpawnReason.SPAWNER, $$9, p_151312_.getRandom()) : !$$7.get().getCategory().isFriendly() && p_151312_.getDifficulty() == Difficulty.PEACEFUL || !($$10 = $$4.getCustomSpawnRules().get()).isValidPosition($$9, p_151312_)) continue;
            Entity $$11 = EntityType.loadEntityRecursive($$6, p_151312_, EntitySpawnReason.SPAWNER, p_404552_ -> {
                p_404552_.snapTo(p_404551_.x, p_404551_.y, p_404551_.z, p_404552_.getYRot(), p_404552_.getXRot());
                return p_404552_;
            });
            if ($$11 == null) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            int $$12 = p_151312_.getEntities(EntityTypeTest.forExactClass($$11.getClass()), new AABB(p_151313_.getX(), p_151313_.getY(), p_151313_.getZ(), p_151313_.getX() + 1, p_151313_.getY() + 1, p_151313_.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
            if ($$12 >= this.maxNearbyEntities) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            $$11.snapTo($$11.getX(), $$11.getY(), $$11.getZ(), $$3.nextFloat() * 360.0f, 0.0f);
            if ($$11 instanceof Mob) {
                boolean $$14;
                Mob $$13 = (Mob)$$11;
                if ($$4.getCustomSpawnRules().isEmpty() && !$$13.checkSpawnRules(p_151312_, EntitySpawnReason.SPAWNER) || !$$13.checkSpawnObstruction(p_151312_)) continue;
                boolean bl = $$14 = $$4.getEntityToSpawn().size() == 1 && $$4.getEntityToSpawn().getString("id").isPresent();
                if ($$14) {
                    ((Mob)$$11).finalizeSpawn(p_151312_, p_151312_.getCurrentDifficultyAt($$11.blockPosition()), EntitySpawnReason.SPAWNER, null);
                }
                $$4.getEquipment().ifPresent($$13::equip);
            }
            if (!p_151312_.tryAddFreshEntityWithPassengers($$11)) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            p_151312_.levelEvent(2004, p_151313_, 0);
            p_151312_.gameEvent($$11, GameEvent.ENTITY_PLACE, $$9);
            if ($$11 instanceof Mob) {
                ((Mob)$$11).spawnAnim();
            }
            $$2 = true;
        }
        if ($$2) {
            this.delay(p_151312_, p_151313_);
        }
    }

    private void delay(Level p_151351_, BlockPos p_151352_) {
        RandomSource $$2 = p_151351_.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + $$2.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom($$2).ifPresent(p_393311_ -> this.setNextSpawnData(p_151351_, p_151352_, (SpawnData)p_393311_));
        this.broadcastEvent(p_151351_, p_151352_, 1);
    }

    public void load(@Nullable Level p_151329_, BlockPos p_151330_, CompoundTag p_151331_) {
        this.spawnDelay = p_151331_.getShortOr("Delay", (short)20);
        p_151331_.read(SPAWN_DATA_TAG, SpawnData.CODEC).ifPresent(p_400944_ -> this.setNextSpawnData(p_151329_, p_151330_, (SpawnData)p_400944_));
        this.spawnPotentials = p_151331_.read("SpawnPotentials", SpawnData.LIST_CODEC).orElseGet(() -> WeightedList.of(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        this.minSpawnDelay = p_151331_.getIntOr("MinSpawnDelay", 200);
        this.maxSpawnDelay = p_151331_.getIntOr("MaxSpawnDelay", 800);
        this.spawnCount = p_151331_.getIntOr("SpawnCount", 4);
        this.maxNearbyEntities = p_151331_.getIntOr("MaxNearbyEntities", 6);
        this.requiredPlayerRange = p_151331_.getIntOr("RequiredPlayerRange", 16);
        this.spawnRange = p_151331_.getIntOr("SpawnRange", 4);
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag p_186382_) {
        p_186382_.putShort("Delay", (short)this.spawnDelay);
        p_186382_.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        p_186382_.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_186382_.putShort("SpawnCount", (short)this.spawnCount);
        p_186382_.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_186382_.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_186382_.putShort("SpawnRange", (short)this.spawnRange);
        p_186382_.storeNullable(SPAWN_DATA_TAG, SpawnData.CODEC, this.nextSpawnData);
        p_186382_.store("SpawnPotentials", SpawnData.LIST_CODEC, this.spawnPotentials);
        return p_186382_;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level p_254323_, BlockPos p_254313_) {
        if (this.displayEntity == null) {
            CompoundTag $$2 = this.getOrCreateNextSpawnData(p_254323_, p_254323_.getRandom(), p_254313_).getEntityToSpawn();
            if ($$2.getString("id").isEmpty()) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive($$2, p_254323_, EntitySpawnReason.SPAWNER, Function.identity());
            if ($$2.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.nextSpawnData = p_151327_;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(p_254503_, p_254487_, this.spawnPotentials.getRandom(p_253892_).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

