/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class TicketStorage
extends SavedData {
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Pair<ChunkPos, Ticket>> TICKET_ENTRY = Codec.mapPair((MapCodec)ChunkPos.CODEC.fieldOf("chunk_pos"), Ticket.CODEC).codec();
    public static final Codec<TicketStorage> CODEC = RecordCodecBuilder.create(p_400948_ -> p_400948_.group((App)TICKET_ENTRY.listOf().optionalFieldOf("tickets", List.of()).forGetter(TicketStorage::packTickets)).apply((Applicative)p_400948_, TicketStorage::fromPacked));
    public static final SavedDataType<TicketStorage> TYPE = new SavedDataType<TicketStorage>("chunks", TicketStorage::new, CODEC, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    private final Long2ObjectOpenHashMap<List<Ticket>> tickets;
    private final Long2ObjectOpenHashMap<List<Ticket>> deactivatedTickets;
    private LongSet chunksWithForcedTickets = new LongOpenHashSet();
    @Nullable
    private ChunkUpdated loadingChunkUpdatedListener;
    @Nullable
    private ChunkUpdated simulationChunkUpdatedListener;

    private TicketStorage(Long2ObjectOpenHashMap<List<Ticket>> p_393873_, Long2ObjectOpenHashMap<List<Ticket>> p_394615_) {
        this.tickets = p_393873_;
        this.deactivatedTickets = p_394615_;
        this.updateForcedChunks();
    }

    public TicketStorage() {
        this((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap());
    }

    private static TicketStorage fromPacked(List<Pair<ChunkPos, Ticket>> p_401113_) {
        Long2ObjectOpenHashMap $$1 = new Long2ObjectOpenHashMap();
        for (Pair<ChunkPos, Ticket> $$2 : p_401113_) {
            ChunkPos $$3 = (ChunkPos)$$2.getFirst();
            List $$4 = (List)$$1.computeIfAbsent($$3.toLong(), p_393722_ -> new ObjectArrayList(4));
            $$4.add((Ticket)$$2.getSecond());
        }
        return new TicketStorage((Long2ObjectOpenHashMap<List<Ticket>>)new Long2ObjectOpenHashMap(4), (Long2ObjectOpenHashMap<List<Ticket>>)$$1);
    }

    private List<Pair<ChunkPos, Ticket>> packTickets() {
        ArrayList<Pair<ChunkPos, Ticket>> $$0 = new ArrayList<Pair<ChunkPos, Ticket>>();
        this.forEachTicket((p_400946_, p_400947_) -> {
            if (p_400947_.getType().persist()) {
                $$0.add(new Pair(p_400946_, p_400947_));
            }
        });
        return $$0;
    }

    private void forEachTicket(BiConsumer<ChunkPos, Ticket> p_401023_) {
        TicketStorage.forEachTicket(p_401023_, this.tickets);
        TicketStorage.forEachTicket(p_401023_, this.deactivatedTickets);
    }

    private static void forEachTicket(BiConsumer<ChunkPos, Ticket> p_401366_, Long2ObjectOpenHashMap<List<Ticket>> p_401184_) {
        for (Long2ObjectMap.Entry $$2 : Long2ObjectMaps.fastIterable(p_401184_)) {
            ChunkPos $$3 = new ChunkPos($$2.getLongKey());
            for (Ticket $$4 : (List)$$2.getValue()) {
                p_401366_.accept($$3, $$4);
            }
        }
    }

    public void activateAllDeactivatedTickets() {
        for (Long2ObjectMap.Entry $$0 : Long2ObjectMaps.fastIterable(this.deactivatedTickets)) {
            for (Ticket $$1 : (List)$$0.getValue()) {
                this.addTicket($$0.getLongKey(), $$1);
            }
        }
        this.deactivatedTickets.clear();
    }

    public void setLoadingChunkUpdatedListener(@Nullable ChunkUpdated p_393504_) {
        this.loadingChunkUpdatedListener = p_393504_;
    }

    public void setSimulationChunkUpdatedListener(@Nullable ChunkUpdated p_394582_) {
        this.simulationChunkUpdatedListener = p_394582_;
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    public List<Ticket> getTickets(long p_393509_) {
        return (List)this.tickets.getOrDefault(p_393509_, List.of());
    }

    private List<Ticket> getOrCreateTickets(long p_394358_) {
        return (List)this.tickets.computeIfAbsent(p_394358_, p_393919_ -> new ObjectArrayList(4));
    }

    public void addTicketWithRadius(TicketType p_394465_, ChunkPos p_394654_, int p_393587_) {
        Ticket $$3 = new Ticket(p_394465_, ChunkLevel.byStatus(FullChunkStatus.FULL) - p_393587_);
        this.addTicket(p_394654_.toLong(), $$3);
    }

    public void addTicket(Ticket p_394208_, ChunkPos p_394290_) {
        this.addTicket(p_394290_.toLong(), p_394208_);
    }

    public boolean addTicket(long p_394247_, Ticket p_394469_) {
        List<Ticket> $$2 = this.getOrCreateTickets(p_394247_);
        for (Ticket $$3 : $$2) {
            if (!TicketStorage.isTicketSameTypeAndLevel(p_394469_, $$3)) continue;
            $$3.resetTicksLeft();
            this.setDirty();
            return false;
        }
        int $$4 = TicketStorage.getTicketLevelAt($$2, true);
        int $$5 = TicketStorage.getTicketLevelAt($$2, false);
        $$2.add(p_394469_);
        if (p_394469_.getType().doesSimulate() && p_394469_.getTicketLevel() < $$4 && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(p_394247_, p_394469_.getTicketLevel(), true);
        }
        if (p_394469_.getType().doesLoad() && p_394469_.getTicketLevel() < $$5 && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(p_394247_, p_394469_.getTicketLevel(), true);
        }
        if (p_394469_.getType().equals(TicketType.FORCED)) {
            this.chunksWithForcedTickets.add(p_394247_);
        }
        this.setDirty();
        return true;
    }

    private static boolean isTicketSameTypeAndLevel(Ticket p_394344_, Ticket p_394181_) {
        return p_394181_.getType() == p_394344_.getType() && p_394181_.getTicketLevel() == p_394344_.getTicketLevel();
    }

    public int getTicketLevelAt(long p_393578_, boolean p_393891_) {
        return TicketStorage.getTicketLevelAt(this.getTickets(p_393578_), p_393891_);
    }

    private static int getTicketLevelAt(List<Ticket> p_394021_, boolean p_393941_) {
        Ticket $$2 = TicketStorage.getLowestTicket(p_394021_, p_393941_);
        return $$2 == null ? ChunkLevel.MAX_LEVEL + 1 : $$2.getTicketLevel();
    }

    @Nullable
    private static Ticket getLowestTicket(@Nullable List<Ticket> p_394073_, boolean p_394430_) {
        if (p_394073_ == null) {
            return null;
        }
        Ticket $$2 = null;
        for (Ticket $$3 : p_394073_) {
            if ($$2 != null && $$3.getTicketLevel() >= $$2.getTicketLevel()) continue;
            if (p_394430_ && $$3.getType().doesSimulate()) {
                $$2 = $$3;
                continue;
            }
            if (p_394430_ || !$$3.getType().doesLoad()) continue;
            $$2 = $$3;
        }
        return $$2;
    }

    public void removeTicketWithRadius(TicketType p_394013_, ChunkPos p_393657_, int p_394336_) {
        Ticket $$3 = new Ticket(p_394013_, ChunkLevel.byStatus(FullChunkStatus.FULL) - p_394336_);
        this.removeTicket(p_393657_.toLong(), $$3);
    }

    public void removeTicket(Ticket p_394399_, ChunkPos p_393510_) {
        this.removeTicket(p_393510_.toLong(), p_394399_);
    }

    public boolean removeTicket(long p_393896_, Ticket p_394054_) {
        List $$2 = (List)this.tickets.get(p_393896_);
        if ($$2 == null) {
            return false;
        }
        boolean $$3 = false;
        Iterator $$4 = $$2.iterator();
        while ($$4.hasNext()) {
            Ticket $$5 = (Ticket)$$4.next();
            if (!TicketStorage.isTicketSameTypeAndLevel(p_394054_, $$5)) continue;
            $$4.remove();
            $$3 = true;
            break;
        }
        if (!$$3) {
            return false;
        }
        if ($$2.isEmpty()) {
            this.tickets.remove(p_393896_);
        }
        if (p_394054_.getType().doesSimulate() && this.simulationChunkUpdatedListener != null) {
            this.simulationChunkUpdatedListener.update(p_393896_, TicketStorage.getTicketLevelAt($$2, true), false);
        }
        if (p_394054_.getType().doesLoad() && this.loadingChunkUpdatedListener != null) {
            this.loadingChunkUpdatedListener.update(p_393896_, TicketStorage.getTicketLevelAt($$2, false), false);
        }
        if (p_394054_.getType().equals(TicketType.FORCED)) {
            this.updateForcedChunks();
        }
        this.setDirty();
        return true;
    }

    private void updateForcedChunks() {
        this.chunksWithForcedTickets = this.getAllChunksWithTicketThat(p_393889_ -> p_393889_.getType().equals(TicketType.FORCED));
    }

    public String getTicketDebugString(long p_393749_, boolean p_394364_) {
        List<Ticket> $$2 = this.getTickets(p_393749_);
        Ticket $$3 = TicketStorage.getLowestTicket($$2, p_394364_);
        return $$3 == null ? "no_ticket" : $$3.toString();
    }

    public void purgeStaleTickets() {
        this.removeTicketIf(p_393626_ -> {
            p_393626_.decreaseTicksLeft();
            return p_393626_.isTimedOut();
        }, null);
        this.setDirty();
    }

    public void deactivateTicketsOnClosing() {
        this.removeTicketIf(p_394604_ -> p_394604_.getType() != TicketType.UNKNOWN, this.deactivatedTickets);
    }

    public void removeTicketIf(Predicate<Ticket> p_393810_, @Nullable Long2ObjectOpenHashMap<List<Ticket>> p_393746_) {
        ObjectIterator $$2 = this.tickets.long2ObjectEntrySet().fastIterator();
        boolean $$3 = false;
        while ($$2.hasNext()) {
            Long2ObjectMap.Entry $$4 = (Long2ObjectMap.Entry)$$2.next();
            Iterator $$5 = ((List)$$4.getValue()).iterator();
            boolean $$6 = false;
            boolean $$7 = false;
            while ($$5.hasNext()) {
                Ticket $$8 = (Ticket)$$5.next();
                if (!p_393810_.test($$8)) continue;
                if (p_393746_ != null) {
                    List $$9 = (List)p_393746_.computeIfAbsent($$4.getLongKey(), p_394107_ -> new ObjectArrayList(((List)$$4.getValue()).size()));
                    $$9.add($$8);
                }
                $$5.remove();
                if ($$8.getType().doesLoad()) {
                    $$7 = true;
                }
                if ($$8.getType().doesSimulate()) {
                    $$6 = true;
                }
                if (!$$8.getType().equals(TicketType.FORCED)) continue;
                $$3 = true;
            }
            if (!$$7 && !$$6) continue;
            if ($$7 && this.loadingChunkUpdatedListener != null) {
                this.loadingChunkUpdatedListener.update($$4.getLongKey(), TicketStorage.getTicketLevelAt((List)$$4.getValue(), false), false);
            }
            if ($$6 && this.simulationChunkUpdatedListener != null) {
                this.simulationChunkUpdatedListener.update($$4.getLongKey(), TicketStorage.getTicketLevelAt((List)$$4.getValue(), true), false);
            }
            this.setDirty();
            if (!((List)$$4.getValue()).isEmpty()) continue;
            $$2.remove();
        }
        if ($$3) {
            this.updateForcedChunks();
        }
    }

    public void replaceTicketLevelOfType(int p_393875_, TicketType p_394261_) {
        ArrayList<Pair> $$2 = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry $$3 : this.tickets.long2ObjectEntrySet()) {
            for (Ticket $$4 : (List)$$3.getValue()) {
                if ($$4.getType() != p_394261_) continue;
                $$2.add(Pair.of((Object)$$4, (Object)$$3.getLongKey()));
            }
        }
        for (Pair $$5 : $$2) {
            Long $$6 = (Long)$$5.getSecond();
            Ticket $$7 = (Ticket)$$5.getFirst();
            this.removeTicket($$6, $$7);
            TicketType $$8 = $$7.getType();
            this.addTicket($$6, new Ticket($$8, p_393875_));
        }
    }

    public boolean updateChunkForced(ChunkPos p_394535_, boolean p_394618_) {
        Ticket $$2 = new Ticket(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL);
        if (p_394618_) {
            return this.addTicket(p_394535_.toLong(), $$2);
        }
        return this.removeTicket(p_394535_.toLong(), $$2);
    }

    public LongSet getForceLoadedChunks() {
        return this.chunksWithForcedTickets;
    }

    private LongSet getAllChunksWithTicketThat(Predicate<Ticket> p_393731_) {
        LongOpenHashSet $$1 = new LongOpenHashSet();
        block0: for (Long2ObjectMap.Entry $$2 : Long2ObjectMaps.fastIterable(this.tickets)) {
            for (Ticket $$3 : (List)$$2.getValue()) {
                if (!p_393731_.test($$3)) continue;
                $$1.add($$2.getLongKey());
                continue block0;
            }
        }
        return $$1;
    }

    @FunctionalInterface
    public static interface ChunkUpdated {
        public void update(long var1, int var3, boolean var4);
    }
}

