/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractCauldronBlock
extends Block {
    protected static final int FLOOR_LEVEL = 4;
    private static final VoxelShape SHAPE_INSIDE = Block.column(12.0, 4.0, 16.0);
    private static final VoxelShape SHAPE = Util.make(() -> {
        int $$0 = 4;
        int $$1 = 3;
        int $$2 = 2;
        return Shapes.join(Shapes.block(), Shapes.or(Block.column(16.0, 8.0, 0.0, 3.0), Block.column(8.0, 16.0, 0.0, 3.0), Block.column(12.0, 0.0, 3.0), SHAPE_INSIDE), BooleanOp.ONLY_FIRST);
    });
    protected final CauldronInteraction.InteractionMap interactions;

    protected abstract MapCodec<? extends AbstractCauldronBlock> codec();

    public AbstractCauldronBlock(BlockBehaviour.Properties p_151946_, CauldronInteraction.InteractionMap p_304473_) {
        super(p_151946_);
        this.interactions = p_304473_;
    }

    protected double getContentHeight(BlockState p_151948_) {
        return 0.0;
    }

    protected boolean isEntityInsideContent(BlockState p_151980_, BlockPos p_151981_, Entity p_151982_) {
        return p_151982_.getY() < (double)p_151981_.getY() + this.getContentHeight(p_151980_) && p_151982_.getBoundingBox().maxY > (double)p_151981_.getY() + 0.25;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316791_, BlockState p_316287_, Level p_316530_, BlockPos p_316585_, Player p_316671_, InteractionHand p_316186_, BlockHitResult p_316294_) {
        CauldronInteraction $$7 = this.interactions.map().get(p_316791_.getItem());
        return $$7.interact(p_316287_, p_316530_, p_316585_, p_316671_, p_316186_, p_316791_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_151964_, BlockGetter p_151965_, BlockPos p_151966_, CollisionContext p_151967_) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getInteractionShape(BlockState p_151955_, BlockGetter p_151956_, BlockPos p_151957_) {
        return SHAPE_INSIDE;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_151986_) {
        return true;
    }

    @Override
    protected boolean isPathfindable(BlockState p_151959_, PathComputationType p_151962_) {
        return false;
    }

    public abstract boolean isFull(BlockState var1);

    @Override
    protected void tick(BlockState p_220702_, ServerLevel p_220703_, BlockPos p_220704_, RandomSource p_220705_) {
        BlockPos $$4 = PointedDripstoneBlock.findStalactiteTipAboveCauldron(p_220703_, p_220704_);
        if ($$4 == null) {
            return;
        }
        Fluid $$5 = PointedDripstoneBlock.getCauldronFillFluidType(p_220703_, $$4);
        if ($$5 != Fluids.EMPTY && this.canReceiveStalactiteDrip($$5)) {
            this.receiveStalactiteDrip(p_220702_, p_220703_, p_220704_, $$5);
        }
    }

    protected boolean canReceiveStalactiteDrip(Fluid p_151983_) {
        return false;
    }

    protected void receiveStalactiteDrip(BlockState p_151975_, Level p_151976_, BlockPos p_151977_, Fluid p_151978_) {
    }
}

