/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CactusBlock
extends Block {
    public static final MapCodec<CactusBlock> CODEC = CactusBlock.simpleCodec(CactusBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final int MAX_AGE = 15;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_COLLISION = Block.column(14.0, 0.0, 15.0);
    private static final int MAX_CACTUS_GROWING_HEIGHT = 3;
    private static final int ATTEMPT_GROW_CACTUS_FLOWER_AGE = 8;
    private static final double ATTEMPT_GROW_CACTUS_FLOWER_SMALL_CACTUS_CHANCE = 0.1;
    private static final double ATTEMPT_GROW_CACTUS_FLOWER_TALL_CACTUS_CHANCE = 0.25;

    public MapCodec<CactusBlock> codec() {
        return CODEC;
    }

    protected CactusBlock(BlockBehaviour.Properties p_51136_) {
        super(p_51136_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected void tick(BlockState p_220908_, ServerLevel p_220909_, BlockPos p_220910_, RandomSource p_220911_) {
        if (!p_220908_.canSurvive(p_220909_, p_220910_)) {
            p_220909_.destroyBlock(p_220910_, true);
        }
    }

    @Override
    protected void randomTick(BlockState p_220913_, ServerLevel p_220914_, BlockPos p_220915_, RandomSource p_220916_) {
        BlockPos $$4 = p_220915_.above();
        if (!p_220914_.isEmptyBlock($$4)) {
            return;
        }
        int $$5 = 1;
        int $$6 = p_220913_.getValue(AGE);
        while (p_220914_.getBlockState(p_220915_.below($$5)).is(this)) {
            if (++$$5 != 3 || $$6 != 15) continue;
            return;
        }
        if ($$6 == 8 && this.canSurvive(this.defaultBlockState(), p_220914_, p_220915_.above())) {
            double $$7;
            double d = $$7 = $$5 >= 3 ? 0.25 : 0.1;
            if (p_220916_.nextDouble() <= $$7) {
                p_220914_.setBlockAndUpdate($$4, Blocks.CACTUS_FLOWER.defaultBlockState());
            }
        } else if ($$6 == 15 && $$5 < 3) {
            p_220914_.setBlockAndUpdate($$4, this.defaultBlockState());
            BlockState $$8 = (BlockState)p_220913_.setValue(AGE, 0);
            p_220914_.setBlock(p_220915_, $$8, 260);
            p_220914_.neighborChanged($$8, $$4, this, null, false);
        }
        if ($$6 < 15) {
            p_220914_.setBlock(p_220915_, (BlockState)p_220913_.setValue(AGE, $$6 + 1), 260);
        }
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_51176_, BlockGetter p_51177_, BlockPos p_51178_, CollisionContext p_51179_) {
        return SHAPE_COLLISION;
    }

    @Override
    protected VoxelShape getShape(BlockState p_51171_, BlockGetter p_51172_, BlockPos p_51173_, CollisionContext p_51174_) {
        return SHAPE;
    }

    @Override
    protected BlockState updateShape(BlockState p_51157_, LevelReader p_374196_, ScheduledTickAccess p_374319_, BlockPos p_51161_, Direction p_51158_, BlockPos p_51162_, BlockState p_51159_, RandomSource p_374070_) {
        if (!p_51157_.canSurvive(p_374196_, p_51161_)) {
            p_374319_.scheduleTick(p_51161_, this, 1);
        }
        return super.updateShape(p_51157_, p_374196_, p_374319_, p_51161_, p_51158_, p_51162_, p_51159_, p_374070_);
    }

    @Override
    protected boolean canSurvive(BlockState p_51153_, LevelReader p_51154_, BlockPos p_51155_) {
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockState $$4 = p_51154_.getBlockState(p_51155_.relative($$3));
            if (!$$4.isSolid() && !p_51154_.getFluidState(p_51155_.relative($$3)).is(FluidTags.LAVA)) continue;
            return false;
        }
        BlockState $$5 = p_51154_.getBlockState(p_51155_.below());
        return ($$5.is(Blocks.CACTUS) || $$5.is(BlockTags.SAND)) && !p_51154_.getBlockState(p_51155_.above()).liquid();
    }

    @Override
    protected void entityInside(BlockState p_51148_, Level p_51149_, BlockPos p_51150_, Entity p_51151_, InsideBlockEffectApplier p_405001_) {
        p_51151_.hurt(p_51149_.damageSources().cactus(), 1.0f);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51164_) {
        p_51164_.add(AGE);
    }

    @Override
    protected boolean isPathfindable(BlockState p_51143_, PathComputationType p_51146_) {
        return false;
    }
}

