/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DragonEggBlock
extends FallingBlock {
    public static final MapCodec<DragonEggBlock> CODEC = DragonEggBlock.simpleCodec(DragonEggBlock::new);
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);

    public MapCodec<DragonEggBlock> codec() {
        return CODEC;
    }

    public DragonEggBlock(BlockBehaviour.Properties p_52911_) {
        super(p_52911_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_52930_, BlockGetter p_52931_, BlockPos p_52932_, CollisionContext p_52933_) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_52923_, Level p_52924_, BlockPos p_52925_, Player p_52926_, BlockHitResult p_52928_) {
        this.teleport(p_52923_, p_52924_, p_52925_);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState p_52918_, Level p_52919_, BlockPos p_52920_, Player p_52921_) {
        this.teleport(p_52918_, p_52919_, p_52920_);
    }

    private void teleport(BlockState p_52936_, Level p_52937_, BlockPos p_52938_) {
        WorldBorder $$3 = p_52937_.getWorldBorder();
        for (int $$4 = 0; $$4 < 1000; ++$$4) {
            BlockPos $$5 = p_52938_.offset(p_52937_.random.nextInt(16) - p_52937_.random.nextInt(16), p_52937_.random.nextInt(8) - p_52937_.random.nextInt(8), p_52937_.random.nextInt(16) - p_52937_.random.nextInt(16));
            if (!p_52937_.getBlockState($$5).isAir() || !$$3.isWithinBounds($$5)) continue;
            if (p_52937_.isClientSide) {
                for (int $$6 = 0; $$6 < 128; ++$$6) {
                    double $$7 = p_52937_.random.nextDouble();
                    float $$8 = (p_52937_.random.nextFloat() - 0.5f) * 0.2f;
                    float $$9 = (p_52937_.random.nextFloat() - 0.5f) * 0.2f;
                    float $$10 = (p_52937_.random.nextFloat() - 0.5f) * 0.2f;
                    double $$11 = Mth.lerp($$7, (double)$$5.getX(), (double)p_52938_.getX()) + (p_52937_.random.nextDouble() - 0.5) + 0.5;
                    double $$12 = Mth.lerp($$7, (double)$$5.getY(), (double)p_52938_.getY()) + p_52937_.random.nextDouble() - 0.5;
                    double $$13 = Mth.lerp($$7, (double)$$5.getZ(), (double)p_52938_.getZ()) + (p_52937_.random.nextDouble() - 0.5) + 0.5;
                    p_52937_.addParticle(ParticleTypes.PORTAL, $$11, $$12, $$13, $$8, $$9, $$10);
                }
            } else {
                p_52937_.setBlock($$5, p_52936_, 2);
                p_52937_.removeBlock(p_52938_, false);
            }
            return;
        }
    }

    @Override
    protected int getDelayAfterPlace() {
        return 5;
    }

    @Override
    protected boolean isPathfindable(BlockState p_52913_, PathComputationType p_52916_) {
        return false;
    }

    @Override
    public int getDustColor(BlockState p_399914_, BlockGetter p_399493_, BlockPos p_399689_) {
        return -16777216;
    }
}

