/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DryVegetationBlock
extends VegetationBlock {
    public static final MapCodec<DryVegetationBlock> CODEC = DryVegetationBlock.simpleCodec(DryVegetationBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 13.0);
    private static final int IDLE_SOUND_CHANCE = 150;
    private static final int IDLE_SOUND_BADLANDS_DECREASED_CHANCE = 5;

    public MapCodec<? extends DryVegetationBlock> codec() {
        return CODEC;
    }

    protected DryVegetationBlock(BlockBehaviour.Properties p_401864_) {
        super(p_401864_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_401767_, BlockGetter p_401764_, BlockPos p_401758_, CollisionContext p_401896_) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_401820_, BlockGetter p_401945_, BlockPos p_401852_) {
        return p_401820_.is(BlockTags.DRY_VEGETATION_MAY_PLACE_ON);
    }

    @Override
    public void animateTick(BlockState p_401875_, Level p_401809_, BlockPos p_401789_, RandomSource p_401918_) {
        if (p_401918_.nextInt(150) == 0) {
            BlockState $$4 = p_401809_.getBlockState(p_401789_.below());
            if (($$4.is(Blocks.RED_SAND) || $$4.is(BlockTags.TERRACOTTA)) && p_401918_.nextInt(5) != 0) {
                return;
            }
            BlockState $$5 = p_401809_.getBlockState(p_401789_.below(2));
            if ($$4.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) && $$5.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS)) {
                p_401809_.playLocalSound(p_401789_.getX(), p_401789_.getY(), p_401789_.getZ(), SoundEvents.DEAD_BUSH_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }
}

