/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlowerPotBlock
extends Block {
    public static final MapCodec<FlowerPotBlock> CODEC = RecordCodecBuilder.mapCodec(p_368424_ -> p_368424_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("potted").forGetter(p_304928_ -> p_304928_.potted), FlowerPotBlock.propertiesCodec()).apply((Applicative)p_368424_, FlowerPotBlock::new));
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    private static final VoxelShape SHAPE = Block.column(6.0, 0.0, 6.0);
    private final Block potted;

    public MapCodec<FlowerPotBlock> codec() {
        return CODEC;
    }

    public FlowerPotBlock(Block p_53528_, BlockBehaviour.Properties p_53529_) {
        super(p_53529_);
        this.potted = p_53528_;
        POTTED_BY_CONTENT.put(p_53528_, this);
    }

    @Override
    protected VoxelShape getShape(BlockState p_53556_, BlockGetter p_53557_, BlockPos p_53558_, CollisionContext p_53559_) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316610_, BlockState p_316240_, Level p_316456_, BlockPos p_316502_, Player p_316491_, InteractionHand p_316444_, BlockHitResult p_316826_) {
        Block block;
        Item item = p_316610_.getItem();
        if (item instanceof BlockItem) {
            BlockItem $$7 = (BlockItem)item;
            block = POTTED_BY_CONTENT.getOrDefault($$7.getBlock(), Blocks.AIR);
        } else {
            block = Blocks.AIR;
        }
        BlockState $$8 = block.defaultBlockState();
        if ($$8.isAir()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        p_316456_.setBlock(p_316502_, $$8, 3);
        p_316456_.gameEvent((Entity)p_316491_, GameEvent.BLOCK_CHANGE, p_316502_);
        p_316491_.awardStat(Stats.POT_FLOWER);
        p_316610_.consume(1, p_316491_);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_316363_, Level p_316655_, BlockPos p_316654_, Player p_316338_, BlockHitResult p_316518_) {
        if (this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        ItemStack $$5 = new ItemStack(this.potted);
        if (!p_316338_.addItem($$5)) {
            p_316338_.drop($$5, false);
        }
        p_316655_.setBlock(p_316654_, Blocks.FLOWER_POT.defaultBlockState(), 3);
        p_316655_.gameEvent((Entity)p_316338_, GameEvent.BLOCK_CHANGE, p_316654_);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader p_304505_, BlockPos p_53532_, BlockState p_53533_, boolean p_388306_) {
        if (this.isEmpty()) {
            return super.getCloneItemStack(p_304505_, p_53532_, p_53533_, p_388306_);
        }
        return new ItemStack(this.potted);
    }

    private boolean isEmpty() {
        return this.potted == Blocks.AIR;
    }

    @Override
    protected BlockState updateShape(BlockState p_53547_, LevelReader p_374311_, ScheduledTickAccess p_374506_, BlockPos p_53551_, Direction p_53548_, BlockPos p_53552_, BlockState p_53549_, RandomSource p_374435_) {
        if (p_53548_ == Direction.DOWN && !p_53547_.canSurvive(p_374311_, p_53551_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_53547_, p_374311_, p_374506_, p_53551_, p_53548_, p_53552_, p_53549_, p_374435_);
    }

    public Block getPotted() {
        return this.potted;
    }

    @Override
    protected boolean isPathfindable(BlockState p_53535_, PathComputationType p_53538_) {
        return false;
    }

    @Override
    protected boolean isRandomlyTicking(BlockState p_383068_) {
        return p_383068_.is(Blocks.POTTED_OPEN_EYEBLOSSOM) || p_383068_.is(Blocks.POTTED_CLOSED_EYEBLOSSOM);
    }

    @Override
    protected void randomTick(BlockState p_382880_, ServerLevel p_383169_, BlockPos p_382955_, RandomSource p_383144_) {
        boolean $$5;
        boolean $$4;
        if (this.isRandomlyTicking(p_382880_) && p_383169_.dimensionType().natural() && ($$4 = this.potted == Blocks.OPEN_EYEBLOSSOM) != ($$5 = CreakingHeartBlock.isNaturalNight(p_383169_))) {
            p_383169_.setBlock(p_382955_, this.opposite(p_382880_), 3);
            EyeblossomBlock.Type $$6 = EyeblossomBlock.Type.fromBoolean($$4).transform();
            $$6.spawnTransformParticle(p_383169_, p_382955_, p_383144_);
            p_383169_.playSound(null, p_382955_, $$6.longSwitchSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(p_382880_, p_383169_, p_382955_, p_383144_);
    }

    public BlockState opposite(BlockState p_383006_) {
        if (p_383006_.is(Blocks.POTTED_OPEN_EYEBLOSSOM)) {
            return Blocks.POTTED_CLOSED_EYEBLOSSOM.defaultBlockState();
        }
        if (p_383006_.is(Blocks.POTTED_CLOSED_EYEBLOSSOM)) {
            return Blocks.POTTED_OPEN_EYEBLOSSOM.defaultBlockState();
        }
        return p_383006_;
    }
}

