/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SegmentableBlock {
    public static final int MIN_SEGMENT = 1;
    public static final int MAX_SEGMENT = 4;
    public static final IntegerProperty AMOUNT = BlockStateProperties.SEGMENT_AMOUNT;

    default public Function<BlockState, VoxelShape> getShapeCalculator(EnumProperty<Direction> p_394273_, IntegerProperty p_394415_) {
        Map<Direction, VoxelShape> $$2 = Shapes.rotateHorizontal(Block.box(0.0, 0.0, 0.0, 8.0, this.getShapeHeight(), 8.0));
        return p_393772_ -> {
            VoxelShape $$4 = Shapes.empty();
            Direction $$5 = (Direction)p_393772_.getValue(p_394273_);
            int $$6 = p_393772_.getValue(p_394415_);
            for (int $$7 = 0; $$7 < $$6; ++$$7) {
                $$4 = Shapes.or($$4, (VoxelShape)$$2.get($$5));
                $$5 = $$5.getCounterClockWise();
            }
            return $$4.singleEncompassing();
        };
    }

    default public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    default public double getShapeHeight() {
        return 1.0;
    }

    default public boolean canBeReplaced(BlockState p_394221_, BlockPlaceContext p_394124_, IntegerProperty p_394071_) {
        return !p_394124_.isSecondaryUseActive() && p_394124_.getItemInHand().is(p_394221_.getBlock().asItem()) && p_394221_.getValue(p_394071_) < 4;
    }

    default public BlockState getStateForPlacement(BlockPlaceContext p_394035_, Block p_393593_, IntegerProperty p_394488_, EnumProperty<Direction> p_393563_) {
        BlockState $$4 = p_394035_.getLevel().getBlockState(p_394035_.getClickedPos());
        if ($$4.is(p_393593_)) {
            return (BlockState)$$4.setValue(p_394488_, Math.min(4, $$4.getValue(p_394488_) + 1));
        }
        return (BlockState)p_393593_.defaultBlockState().setValue(p_393563_, p_394035_.getHorizontalDirection().getOpposite());
    }
}

