/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;

public abstract class VegetationBlock
extends Block {
    protected VegetationBlock(BlockBehaviour.Properties p_401368_) {
        super(p_401368_);
    }

    protected abstract MapCodec<? extends VegetationBlock> codec();

    protected boolean mayPlaceOn(BlockState p_401274_, BlockGetter p_401010_, BlockPos p_401365_) {
        return p_401274_.is(BlockTags.DIRT) || p_401274_.is(Blocks.FARMLAND);
    }

    @Override
    protected BlockState updateShape(BlockState p_401118_, LevelReader p_401198_, ScheduledTickAccess p_401107_, BlockPos p_401142_, Direction p_401236_, BlockPos p_401082_, BlockState p_401336_, RandomSource p_401169_) {
        if (!p_401118_.canSurvive(p_401198_, p_401142_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_401118_, p_401198_, p_401107_, p_401142_, p_401236_, p_401082_, p_401336_, p_401169_);
    }

    @Override
    protected boolean canSurvive(BlockState p_401395_, LevelReader p_401031_, BlockPos p_401248_) {
        BlockPos $$3 = p_401248_.below();
        return this.mayPlaceOn(p_401031_.getBlockState($$3), p_401031_, $$3);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_401261_) {
        return p_401261_.getFluidState().isEmpty();
    }

    @Override
    protected boolean isPathfindable(BlockState p_401351_, PathComputationType p_401371_) {
        if (p_401371_ == PathComputationType.AIR && !this.hasCollision) {
            return true;
        }
        return super.isPathfindable(p_401351_, p_401371_);
    }
}

