/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<WallBlock> CODEC = WallBlock.simpleCodec(WallBlock::new);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Function<BlockState, VoxelShape> shapes;
    private final Function<BlockState, VoxelShape> collisionShapes;
    private static final VoxelShape TEST_SHAPE_POST = Block.column(2.0, 0.0, 16.0);
    private static final Map<Direction, VoxelShape> TEST_SHAPES_WALL = Shapes.rotateHorizontal(Block.boxZ(2.0, 16.0, 0.0, 9.0));

    public MapCodec<WallBlock> codec() {
        return CODEC;
    }

    public WallBlock(BlockBehaviour.Properties p_57964_) {
        super(p_57964_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH, WallSide.NONE)).setValue(EAST, WallSide.NONE)).setValue(SOUTH, WallSide.NONE)).setValue(WEST, WallSide.NONE)).setValue(WATERLOGGED, false));
        this.shapes = this.makeShapes(16.0f, 14.0f);
        this.collisionShapes = this.makeShapes(24.0f, 24.0f);
    }

    private Function<BlockState, VoxelShape> makeShapes(float p_57966_, float p_57967_) {
        VoxelShape $$2 = Block.column(8.0, 0.0, p_57966_);
        int $$3 = 6;
        Map<Direction, VoxelShape> $$4 = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, p_57967_, 0.0, 11.0));
        Map<Direction, VoxelShape> $$5 = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, p_57966_, 0.0, 11.0));
        return this.getShapeForEachState(p_394478_ -> {
            VoxelShape $$4 = p_394478_.getValue(UP) != false ? $$2 : Shapes.empty();
            for (Map.Entry<Direction, EnumProperty<WallSide>> $$5 : PROPERTY_BY_DIRECTION.entrySet()) {
                $$4 = Shapes.or($$4, switch ((WallSide)p_394478_.getValue($$5.getValue())) {
                    default -> throw new MatchException(null, null);
                    case WallSide.NONE -> Shapes.empty();
                    case WallSide.LOW -> (VoxelShape)$$4.get($$5.getKey());
                    case WallSide.TALL -> (VoxelShape)$$5.get($$5.getKey());
                });
            }
            return $$4;
        }, WATERLOGGED);
    }

    @Override
    protected VoxelShape getShape(BlockState p_58050_, BlockGetter p_58051_, BlockPos p_58052_, CollisionContext p_58053_) {
        return this.shapes.apply(p_58050_);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_58055_, BlockGetter p_58056_, BlockPos p_58057_, CollisionContext p_58058_) {
        return this.collisionShapes.apply(p_58055_);
    }

    @Override
    protected boolean isPathfindable(BlockState p_57996_, PathComputationType p_57999_) {
        return false;
    }

    private boolean connectsTo(BlockState p_58021_, boolean p_58022_, Direction p_58023_) {
        Block $$3 = p_58021_.getBlock();
        boolean $$4 = $$3 instanceof FenceGateBlock && FenceGateBlock.connectsToDirection(p_58021_, p_58023_);
        return p_58021_.is(BlockTags.WALLS) || !WallBlock.isExceptionForConnection(p_58021_) && p_58022_ || $$3 instanceof IronBarsBlock || $$4;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57973_) {
        Level $$1 = p_57973_.getLevel();
        BlockPos $$2 = p_57973_.getClickedPos();
        FluidState $$3 = p_57973_.getLevel().getFluidState(p_57973_.getClickedPos());
        BlockPos $$4 = $$2.north();
        BlockPos $$5 = $$2.east();
        BlockPos $$6 = $$2.south();
        BlockPos $$7 = $$2.west();
        BlockPos $$8 = $$2.above();
        BlockState $$9 = $$1.getBlockState($$4);
        BlockState $$10 = $$1.getBlockState($$5);
        BlockState $$11 = $$1.getBlockState($$6);
        BlockState $$12 = $$1.getBlockState($$7);
        BlockState $$13 = $$1.getBlockState($$8);
        boolean $$14 = this.connectsTo($$9, $$9.isFaceSturdy($$1, $$4, Direction.SOUTH), Direction.SOUTH);
        boolean $$15 = this.connectsTo($$10, $$10.isFaceSturdy($$1, $$5, Direction.WEST), Direction.WEST);
        boolean $$16 = this.connectsTo($$11, $$11.isFaceSturdy($$1, $$6, Direction.NORTH), Direction.NORTH);
        boolean $$17 = this.connectsTo($$12, $$12.isFaceSturdy($$1, $$7, Direction.EAST), Direction.EAST);
        BlockState $$18 = (BlockState)this.defaultBlockState().setValue(WATERLOGGED, $$3.getType() == Fluids.WATER);
        return this.updateShape($$1, $$18, $$8, $$13, $$14, $$15, $$16, $$17);
    }

    @Override
    protected BlockState updateShape(BlockState p_58014_, LevelReader p_374577_, ScheduledTickAccess p_374176_, BlockPos p_58018_, Direction p_58015_, BlockPos p_58019_, BlockState p_58016_, RandomSource p_374535_) {
        if (p_58014_.getValue(WATERLOGGED).booleanValue()) {
            p_374176_.scheduleTick(p_58018_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374577_));
        }
        if (p_58015_ == Direction.DOWN) {
            return super.updateShape(p_58014_, p_374577_, p_374176_, p_58018_, p_58015_, p_58019_, p_58016_, p_374535_);
        }
        if (p_58015_ == Direction.UP) {
            return this.topUpdate(p_374577_, p_58014_, p_58019_, p_58016_);
        }
        return this.sideUpdate(p_374577_, p_58018_, p_58014_, p_58019_, p_58016_, p_58015_);
    }

    private static boolean isConnected(BlockState p_58011_, Property<WallSide> p_58012_) {
        return p_58011_.getValue(p_58012_) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape p_58039_, VoxelShape p_58040_) {
        return !Shapes.joinIsNotEmpty(p_58040_, p_58039_, BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader p_57975_, BlockState p_57976_, BlockPos p_57977_, BlockState p_57978_) {
        boolean $$4 = WallBlock.isConnected(p_57976_, NORTH);
        boolean $$5 = WallBlock.isConnected(p_57976_, EAST);
        boolean $$6 = WallBlock.isConnected(p_57976_, SOUTH);
        boolean $$7 = WallBlock.isConnected(p_57976_, WEST);
        return this.updateShape(p_57975_, p_57976_, p_57977_, p_57978_, $$4, $$5, $$6, $$7);
    }

    private BlockState sideUpdate(LevelReader p_57989_, BlockPos p_57990_, BlockState p_57991_, BlockPos p_57992_, BlockState p_57993_, Direction p_57994_) {
        Direction $$6 = p_57994_.getOpposite();
        boolean $$7 = p_57994_ == Direction.NORTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, NORTH);
        boolean $$8 = p_57994_ == Direction.EAST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, EAST);
        boolean $$9 = p_57994_ == Direction.SOUTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, SOUTH);
        boolean $$10 = p_57994_ == Direction.WEST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, WEST);
        BlockPos $$11 = p_57990_.above();
        BlockState $$12 = p_57989_.getBlockState($$11);
        return this.updateShape(p_57989_, p_57991_, $$11, $$12, $$7, $$8, $$9, $$10);
    }

    private BlockState updateShape(LevelReader p_57980_, BlockState p_57981_, BlockPos p_57982_, BlockState p_57983_, boolean p_57984_, boolean p_57985_, boolean p_57986_, boolean p_57987_) {
        VoxelShape $$8 = p_57983_.getCollisionShape(p_57980_, p_57982_).getFaceShape(Direction.DOWN);
        BlockState $$9 = this.updateSides(p_57981_, p_57984_, p_57985_, p_57986_, p_57987_, $$8);
        return (BlockState)$$9.setValue(UP, this.shouldRaisePost($$9, p_57983_, $$8));
    }

    private boolean shouldRaisePost(BlockState p_58007_, BlockState p_58008_, VoxelShape p_58009_) {
        boolean $$13;
        boolean $$12;
        boolean $$3;
        boolean bl = $$3 = p_58008_.getBlock() instanceof WallBlock && p_58008_.getValue(UP) != false;
        if ($$3) {
            return true;
        }
        WallSide $$4 = p_58007_.getValue(NORTH);
        WallSide $$5 = p_58007_.getValue(SOUTH);
        WallSide $$6 = p_58007_.getValue(EAST);
        WallSide $$7 = p_58007_.getValue(WEST);
        boolean $$8 = $$5 == WallSide.NONE;
        boolean $$9 = $$7 == WallSide.NONE;
        boolean $$10 = $$6 == WallSide.NONE;
        boolean $$11 = $$4 == WallSide.NONE;
        boolean bl2 = $$12 = $$11 && $$8 && $$9 && $$10 || $$11 != $$8 || $$9 != $$10;
        if ($$12) {
            return true;
        }
        boolean bl3 = $$13 = $$4 == WallSide.TALL && $$5 == WallSide.TALL || $$6 == WallSide.TALL && $$7 == WallSide.TALL;
        if ($$13) {
            return false;
        }
        return p_58008_.is(BlockTags.WALL_POST_OVERRIDE) || WallBlock.isCovered(p_58009_, TEST_SHAPE_POST);
    }

    private BlockState updateSides(BlockState p_58025_, boolean p_58026_, boolean p_58027_, boolean p_58028_, boolean p_58029_, VoxelShape p_58030_) {
        return (BlockState)((BlockState)((BlockState)((BlockState)p_58025_.setValue(NORTH, this.makeWallState(p_58026_, p_58030_, TEST_SHAPES_WALL.get(Direction.NORTH)))).setValue(EAST, this.makeWallState(p_58027_, p_58030_, TEST_SHAPES_WALL.get(Direction.EAST)))).setValue(SOUTH, this.makeWallState(p_58028_, p_58030_, TEST_SHAPES_WALL.get(Direction.SOUTH)))).setValue(WEST, this.makeWallState(p_58029_, p_58030_, TEST_SHAPES_WALL.get(Direction.WEST)));
    }

    private WallSide makeWallState(boolean p_58042_, VoxelShape p_58043_, VoxelShape p_58044_) {
        if (p_58042_) {
            if (WallBlock.isCovered(p_58043_, p_58044_)) {
                return WallSide.TALL;
            }
            return WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @Override
    protected FluidState getFluidState(BlockState p_58060_) {
        if (p_58060_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_58060_);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_58046_) {
        return p_58046_.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58032_) {
        p_58032_.add(UP, NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }

    @Override
    protected BlockState rotate(BlockState p_58004_, Rotation p_58005_) {
        switch (p_58005_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH, p_58004_.getValue(SOUTH))).setValue(EAST, p_58004_.getValue(WEST))).setValue(SOUTH, p_58004_.getValue(NORTH))).setValue(WEST, p_58004_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH, p_58004_.getValue(EAST))).setValue(EAST, p_58004_.getValue(SOUTH))).setValue(SOUTH, p_58004_.getValue(WEST))).setValue(WEST, p_58004_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH, p_58004_.getValue(WEST))).setValue(EAST, p_58004_.getValue(NORTH))).setValue(SOUTH, p_58004_.getValue(EAST))).setValue(WEST, p_58004_.getValue(SOUTH));
            }
        }
        return p_58004_;
    }

    @Override
    protected BlockState mirror(BlockState p_58001_, Mirror p_58002_) {
        switch (p_58002_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_58001_.setValue(NORTH, p_58001_.getValue(SOUTH))).setValue(SOUTH, p_58001_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_58001_.setValue(EAST, p_58001_.getValue(WEST))).setValue(WEST, p_58001_.getValue(EAST));
            }
        }
        return super.mirror(p_58001_, p_58002_);
    }
}

