/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Codec<Map<ResourceKey<Recipe<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap(Recipe.KEY_CODEC, (Codec)Codec.INT);
    private static final short DEFAULT_COOKING_TIMER = 0;
    private static final short DEFAULT_COOKING_TOTAL_TIME = 0;
    private static final short DEFAULT_LIT_TIME_REMAINING = 0;
    private static final short DEFAULT_LIT_TOTAL_TIME = 0;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    int litTimeRemaining;
    int litTotalTime;
    int cookingTimer;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return AbstractFurnaceBlockEntity.this.litTimeRemaining;
                }
                case 1: {
                    return AbstractFurnaceBlockEntity.this.litTotalTime;
                }
                case 2: {
                    return AbstractFurnaceBlockEntity.this.cookingTimer;
                }
                case 3: {
                    return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    AbstractFurnaceBlockEntity.this.litTimeRemaining = p_58434_;
                    break;
                }
                case 1: {
                    AbstractFurnaceBlockEntity.this.litTotalTime = p_58434_;
                    break;
                }
                case 2: {
                    AbstractFurnaceBlockEntity.this.cookingTimer = p_58434_;
                    break;
                }
                case 3: {
                    AbstractFurnaceBlockEntity.this.cookingTotalTime = p_58434_;
                    break;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    private final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed = new Reference2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_, RecipeType<? extends AbstractCookingRecipe> p_154994_) {
        super(p_154991_, p_154992_, p_154993_);
        this.quickCheck = RecipeManager.createCheck(p_154994_);
    }

    private boolean isLit() {
        return this.litTimeRemaining > 0;
    }

    @Override
    protected void loadAdditional(CompoundTag p_155025_, HolderLookup.Provider p_323468_) {
        super.loadAdditional(p_155025_, p_323468_);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerHelper.loadAllItems(p_155025_, this.items, p_323468_);
        this.cookingTimer = p_155025_.getShortOr("cooking_time_spent", (short)0);
        this.cookingTotalTime = p_155025_.getShortOr("cooking_total_time", (short)0);
        this.litTimeRemaining = p_155025_.getShortOr("lit_time_remaining", (short)0);
        this.litTotalTime = p_155025_.getShortOr("lit_total_time", (short)0);
        this.recipesUsed.clear();
        this.recipesUsed.putAll(p_155025_.read("RecipesUsed", RECIPES_USED_CODEC).orElse(Map.of()));
    }

    @Override
    protected void saveAdditional(CompoundTag p_187452_, HolderLookup.Provider p_323656_) {
        super.saveAdditional(p_187452_, p_323656_);
        p_187452_.putShort("cooking_time_spent", (short)this.cookingTimer);
        p_187452_.putShort("cooking_total_time", (short)this.cookingTotalTime);
        p_187452_.putShort("lit_time_remaining", (short)this.litTimeRemaining);
        p_187452_.putShort("lit_total_time", (short)this.litTotalTime);
        ContainerHelper.saveAllItems(p_187452_, this.items, p_323656_);
        p_187452_.store("RecipesUsed", RECIPES_USED_CODEC, this.recipesUsed);
    }

    public static void serverTick(ServerLevel p_379747_, BlockPos p_155015_, BlockState p_155016_, AbstractFurnaceBlockEntity p_155017_) {
        boolean $$9;
        boolean $$4 = p_155017_.isLit();
        boolean $$5 = false;
        if (p_155017_.isLit()) {
            --p_155017_.litTimeRemaining;
        }
        ItemStack $$6 = p_155017_.items.get(1);
        ItemStack $$7 = p_155017_.items.get(0);
        boolean $$8 = !$$7.isEmpty();
        boolean bl = $$9 = !$$6.isEmpty();
        if (p_155017_.isLit() || $$9 && $$8) {
            RecipeHolder<? extends AbstractCookingRecipe> $$12;
            SingleRecipeInput $$10 = new SingleRecipeInput($$7);
            if ($$8) {
                RecipeHolder $$11 = p_155017_.quickCheck.getRecipeFor($$10, p_379747_).orElse(null);
            } else {
                $$12 = null;
            }
            int $$13 = p_155017_.getMaxStackSize();
            if (!p_155017_.isLit() && AbstractFurnaceBlockEntity.canBurn(p_379747_.registryAccess(), $$12, $$10, p_155017_.items, $$13)) {
                p_155017_.litTotalTime = p_155017_.litTimeRemaining = p_155017_.getBurnDuration(p_379747_.fuelValues(), $$6);
                if (p_155017_.isLit()) {
                    $$5 = true;
                    if ($$9) {
                        Item $$14 = $$6.getItem();
                        $$6.shrink(1);
                        if ($$6.isEmpty()) {
                            p_155017_.items.set(1, $$14.getCraftingRemainder());
                        }
                    }
                }
            }
            if (p_155017_.isLit() && AbstractFurnaceBlockEntity.canBurn(p_379747_.registryAccess(), $$12, $$10, p_155017_.items, $$13)) {
                ++p_155017_.cookingTimer;
                if (p_155017_.cookingTimer == p_155017_.cookingTotalTime) {
                    p_155017_.cookingTimer = 0;
                    p_155017_.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(p_379747_, p_155017_);
                    if (AbstractFurnaceBlockEntity.burn(p_379747_.registryAccess(), $$12, $$10, p_155017_.items, $$13)) {
                        p_155017_.setRecipeUsed($$12);
                    }
                    $$5 = true;
                }
            } else {
                p_155017_.cookingTimer = 0;
            }
        } else if (!p_155017_.isLit() && p_155017_.cookingTimer > 0) {
            p_155017_.cookingTimer = Mth.clamp(p_155017_.cookingTimer - 2, 0, p_155017_.cookingTotalTime);
        }
        if ($$4 != p_155017_.isLit()) {
            $$5 = true;
            p_155016_ = (BlockState)p_155016_.setValue(AbstractFurnaceBlock.LIT, p_155017_.isLit());
            p_379747_.setBlock(p_155015_, p_155016_, 3);
        }
        if ($$5) {
            AbstractFurnaceBlockEntity.setChanged(p_379747_, p_155015_, p_155016_);
        }
    }

    private static boolean canBurn(RegistryAccess p_266924_, @Nullable RecipeHolder<? extends AbstractCookingRecipe> p_301107_, SingleRecipeInput p_380038_, NonNullList<ItemStack> p_155007_, int p_155008_) {
        if (p_155007_.get(0).isEmpty() || p_301107_ == null) {
            return false;
        }
        ItemStack $$5 = p_301107_.value().assemble(p_380038_, (HolderLookup.Provider)p_266924_);
        if ($$5.isEmpty()) {
            return false;
        }
        ItemStack $$6 = p_155007_.get(2);
        if ($$6.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents($$6, $$5)) {
            return false;
        }
        if ($$6.getCount() < p_155008_ && $$6.getCount() < $$6.getMaxStackSize()) {
            return true;
        }
        return $$6.getCount() < $$5.getMaxStackSize();
    }

    private static boolean burn(RegistryAccess p_266740_, @Nullable RecipeHolder<? extends AbstractCookingRecipe> p_300910_, SingleRecipeInput p_380269_, NonNullList<ItemStack> p_267073_, int p_267157_) {
        if (p_300910_ == null || !AbstractFurnaceBlockEntity.canBurn(p_266740_, p_300910_, p_380269_, p_267073_, p_267157_)) {
            return false;
        }
        ItemStack $$5 = p_267073_.get(0);
        ItemStack $$6 = p_300910_.value().assemble(p_380269_, (HolderLookup.Provider)p_266740_);
        ItemStack $$7 = p_267073_.get(2);
        if ($$7.isEmpty()) {
            p_267073_.set(2, $$6.copy());
        } else if (ItemStack.isSameItemSameComponents($$7, $$6)) {
            $$7.grow(1);
        }
        if ($$5.is(Blocks.WET_SPONGE.asItem()) && !p_267073_.get(1).isEmpty() && p_267073_.get(1).is(Items.BUCKET)) {
            p_267073_.set(1, new ItemStack(Items.WATER_BUCKET));
        }
        $$5.shrink(1);
        return true;
    }

    protected int getBurnDuration(FuelValues p_363501_, ItemStack p_58343_) {
        return p_363501_.burnDuration(p_58343_);
    }

    private static int getTotalCookTime(ServerLevel p_380169_, AbstractFurnaceBlockEntity p_222694_) {
        SingleRecipeInput $$2 = new SingleRecipeInput(p_222694_.getItem(0));
        return p_222694_.quickCheck.getRecipeFor($$2, p_380169_).map(p_379263_ -> ((AbstractCookingRecipe)p_379263_.value()).cookingTime()).orElse(200);
    }

    @Override
    public int[] getSlotsForFace(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (p_58363_ == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int p_58336_, ItemStack p_58337_, @Nullable Direction p_58338_) {
        return this.canPlaceItem(p_58336_, p_58337_);
    }

    @Override
    public boolean canTakeItemThroughFace(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        if (p_58394_ == Direction.DOWN && p_58392_ == 1) {
            return p_58393_.is(Items.WATER_BUCKET) || p_58393_.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> p_332808_) {
        this.items = p_332808_;
    }

    @Override
    public void setItem(int p_58333_, ItemStack p_58334_) {
        Level level;
        ItemStack $$2 = this.items.get(p_58333_);
        boolean $$3 = !p_58334_.isEmpty() && ItemStack.isSameItemSameComponents($$2, p_58334_);
        this.items.set(p_58333_, p_58334_);
        p_58334_.limitSize(this.getMaxStackSize(p_58334_));
        if (p_58333_ == 0 && !$$3 && (level = this.level) instanceof ServerLevel) {
            ServerLevel $$4 = (ServerLevel)level;
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime($$4, this);
            this.cookingTimer = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int p_58389_, ItemStack p_58390_) {
        if (p_58389_ == 2) {
            return false;
        }
        if (p_58389_ == 1) {
            ItemStack $$2 = this.items.get(1);
            return this.level.fuelValues().isFuel(p_58390_) || p_58390_.is(Items.BUCKET) && !$$2.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> p_301245_) {
        if (p_301245_ != null) {
            ResourceKey<Recipe<?>> $$1 = p_301245_.id();
            this.recipesUsed.addTo($$1, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player p_58396_, List<ItemStack> p_282202_) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer p_155004_) {
        List<RecipeHolder<?>> $$1 = this.getRecipesToAwardAndPopExperience(p_155004_.serverLevel(), p_155004_.position());
        p_155004_.awardRecipes($$1);
        for (RecipeHolder<?> $$2 : $$1) {
            if ($$2 == null) continue;
            p_155004_.triggerRecipeCrafted($$2, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel p_154996_, Vec3 p_154997_) {
        ArrayList $$2 = Lists.newArrayList();
        for (Reference2IntMap.Entry $$3 : this.recipesUsed.reference2IntEntrySet()) {
            p_154996_.recipeAccess().byKey((ResourceKey)$$3.getKey()).ifPresent(p_379268_ -> {
                $$2.add(p_379268_);
                AbstractFurnaceBlockEntity.createExperience(p_154996_, p_154997_, $$3.getIntValue(), ((AbstractCookingRecipe)p_379268_.value()).experience());
            });
        }
        return $$2;
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int $$4 = Mth.floor((float)p_155001_ * p_155002_);
        float $$5 = Mth.frac((float)p_155001_ * p_155002_);
        if ($$5 != 0.0f && Math.random() < (double)$$5) {
            ++$$4;
        }
        ExperienceOrb.award(p_154999_, p_155000_, $$4);
    }

    @Override
    public void fillStackedContents(StackedItemContents p_363281_) {
        for (ItemStack $$1 : this.items) {
            p_363281_.accountStack($$1);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos p_393693_, BlockState p_393780_) {
        super.preRemoveSideEffects(p_393693_, p_393780_);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            this.getRecipesToAwardAndPopExperience($$2, Vec3.atCenterOf(p_393693_));
        }
    }
}

