/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ARGB;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class BeaconBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable,
BeaconBeamOwner {
    private static final int MAX_LEVELS = 4;
    public static final List<List<Holder<MobEffect>>> BEACON_EFFECTS = List.of(List.of(MobEffects.SPEED, MobEffects.HASTE), List.of(MobEffects.RESISTANCE, MobEffects.JUMP_BOOST), List.of(MobEffects.STRENGTH), List.of(MobEffects.REGENERATION));
    private static final Set<Holder<MobEffect>> VALID_EFFECTS = BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_SECONDARY = 2;
    public static final int NUM_DATA_VALUES = 3;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.translatable("container.beacon");
    private static final String TAG_PRIMARY = "primary_effect";
    private static final String TAG_SECONDARY = "secondary_effect";
    List<BeaconBeamOwner.Section> beamSections = new ArrayList<BeaconBeamOwner.Section>();
    private List<BeaconBeamOwner.Section> checkingBeamSections = new ArrayList<BeaconBeamOwner.Section>();
    int levels;
    private int lastCheckY;
    @Nullable
    Holder<MobEffect> primaryPower;
    @Nullable
    Holder<MobEffect> secondaryPower;
    @Nullable
    private Component name;
    private LockCode lockKey = LockCode.NO_LOCK;
    private final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int p_58711_) {
            return switch (p_58711_) {
                case 0 -> BeaconBlockEntity.this.levels;
                case 1 -> BeaconMenu.encodeEffect(BeaconBlockEntity.this.primaryPower);
                case 2 -> BeaconMenu.encodeEffect(BeaconBlockEntity.this.secondaryPower);
                default -> 0;
            };
        }

        @Override
        public void set(int p_58713_, int p_58714_) {
            switch (p_58713_) {
                case 0: {
                    BeaconBlockEntity.this.levels = p_58714_;
                    break;
                }
                case 1: {
                    if (!BeaconBlockEntity.this.level.isClientSide && !BeaconBlockEntity.this.beamSections.isEmpty()) {
                        BeaconBlockEntity.playSound(BeaconBlockEntity.this.level, BeaconBlockEntity.this.worldPosition, SoundEvents.BEACON_POWER_SELECT);
                    }
                    BeaconBlockEntity.this.primaryPower = BeaconBlockEntity.filterEffect(BeaconMenu.decodeEffect(p_58714_));
                    break;
                }
                case 2: {
                    BeaconBlockEntity.this.secondaryPower = BeaconBlockEntity.filterEffect(BeaconMenu.decodeEffect(p_58714_));
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };

    @Nullable
    static Holder<MobEffect> filterEffect(@Nullable Holder<MobEffect> p_316372_) {
        return VALID_EFFECTS.contains(p_316372_) ? p_316372_ : null;
    }

    public BeaconBlockEntity(BlockPos p_155088_, BlockState p_155089_) {
        super(BlockEntityType.BEACON, p_155088_, p_155089_);
    }

    public static void tick(Level p_155108_, BlockPos p_155109_, BlockState p_155110_, BeaconBlockEntity p_155111_) {
        BlockPos $$8;
        int $$4 = p_155109_.getX();
        int $$5 = p_155109_.getY();
        int $$6 = p_155109_.getZ();
        if (p_155111_.lastCheckY < $$5) {
            BlockPos $$7 = p_155109_;
            p_155111_.checkingBeamSections = Lists.newArrayList();
            p_155111_.lastCheckY = $$7.getY() - 1;
        } else {
            $$8 = new BlockPos($$4, p_155111_.lastCheckY + 1, $$6);
        }
        BeaconBeamOwner.Section $$9 = p_155111_.checkingBeamSections.isEmpty() ? null : p_155111_.checkingBeamSections.get(p_155111_.checkingBeamSections.size() - 1);
        int $$10 = p_155108_.getHeight(Heightmap.Types.WORLD_SURFACE, $$4, $$6);
        for (int $$11 = 0; $$11 < 10 && $$8.getY() <= $$10; ++$$11) {
            block18: {
                BlockState $$12;
                block16: {
                    int $$15;
                    block17: {
                        $$12 = p_155108_.getBlockState($$8);
                        Block $$13 = $$12.getBlock();
                        if (!($$13 instanceof BeaconBeamBlock)) break block16;
                        BeaconBeamBlock $$14 = (BeaconBeamBlock)((Object)$$13);
                        $$15 = $$14.getColor().getTextureDiffuseColor();
                        if (p_155111_.checkingBeamSections.size() > 1) break block17;
                        $$9 = new BeaconBeamOwner.Section($$15);
                        p_155111_.checkingBeamSections.add($$9);
                        break block18;
                    }
                    if ($$9 == null) break block18;
                    if ($$15 == $$9.getColor()) {
                        $$9.increaseHeight();
                    } else {
                        $$9 = new BeaconBeamOwner.Section(ARGB.average($$9.getColor(), $$15));
                        p_155111_.checkingBeamSections.add($$9);
                    }
                    break block18;
                }
                if ($$9 != null && ($$12.getLightBlock() < 15 || $$12.is(Blocks.BEDROCK))) {
                    $$9.increaseHeight();
                } else {
                    p_155111_.checkingBeamSections.clear();
                    p_155111_.lastCheckY = $$10;
                    break;
                }
            }
            $$8 = $$8.above();
            ++p_155111_.lastCheckY;
        }
        int $$16 = p_155111_.levels;
        if (p_155108_.getGameTime() % 80L == 0L) {
            if (!p_155111_.beamSections.isEmpty()) {
                p_155111_.levels = BeaconBlockEntity.updateBase(p_155108_, $$4, $$5, $$6);
            }
            if (p_155111_.levels > 0 && !p_155111_.beamSections.isEmpty()) {
                BeaconBlockEntity.applyEffects(p_155108_, p_155109_, p_155111_.levels, p_155111_.primaryPower, p_155111_.secondaryPower);
                BeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.BEACON_AMBIENT);
            }
        }
        if (p_155111_.lastCheckY >= $$10) {
            p_155111_.lastCheckY = p_155108_.getMinY() - 1;
            boolean $$17 = $$16 > 0;
            p_155111_.beamSections = p_155111_.checkingBeamSections;
            if (!p_155108_.isClientSide) {
                boolean $$18;
                boolean bl = $$18 = p_155111_.levels > 0;
                if (!$$17 && $$18) {
                    BeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.BEACON_ACTIVATE);
                    for (ServerPlayer $$19 : p_155108_.getEntitiesOfClass(ServerPlayer.class, new AABB($$4, $$5, $$6, $$4, $$5 - 4, $$6).inflate(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.CONSTRUCT_BEACON.trigger($$19, p_155111_.levels);
                    }
                } else if ($$17 && !$$18) {
                    BeaconBlockEntity.playSound(p_155108_, p_155109_, SoundEvents.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(Level p_155093_, int p_155094_, int p_155095_, int p_155096_) {
        int $$6;
        int $$4 = 0;
        int $$5 = 1;
        while ($$5 <= 4 && ($$6 = p_155095_ - $$5) >= p_155093_.getMinY()) {
            boolean $$7 = true;
            block1: for (int $$8 = p_155094_ - $$5; $$8 <= p_155094_ + $$5 && $$7; ++$$8) {
                for (int $$9 = p_155096_ - $$5; $$9 <= p_155096_ + $$5; ++$$9) {
                    if (p_155093_.getBlockState(new BlockPos($$8, $$6, $$9)).is(BlockTags.BEACON_BASE_BLOCKS)) continue;
                    $$7 = false;
                    continue block1;
                }
            }
            if (!$$7) break;
            $$4 = $$5++;
        }
        return $$4;
    }

    @Override
    public void setRemoved() {
        BeaconBlockEntity.playSound(this.level, this.worldPosition, SoundEvents.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    private static void applyEffects(Level p_155098_, BlockPos p_155099_, int p_155100_, @Nullable Holder<MobEffect> p_316599_, @Nullable Holder<MobEffect> p_316343_) {
        if (p_155098_.isClientSide || p_316599_ == null) {
            return;
        }
        double $$5 = p_155100_ * 10 + 10;
        int $$6 = 0;
        if (p_155100_ >= 4 && Objects.equals(p_316599_, p_316343_)) {
            $$6 = 1;
        }
        int $$7 = (9 + p_155100_ * 2) * 20;
        AABB $$8 = new AABB(p_155099_).inflate($$5).expandTowards(0.0, p_155098_.getHeight(), 0.0);
        List<Player> $$9 = p_155098_.getEntitiesOfClass(Player.class, $$8);
        for (Player $$10 : $$9) {
            $$10.addEffect(new MobEffectInstance(p_316599_, $$7, $$6, true, true));
        }
        if (p_155100_ >= 4 && !Objects.equals(p_316599_, p_316343_) && p_316343_ != null) {
            for (Player $$11 : $$9) {
                $$11.addEffect(new MobEffectInstance(p_316343_, $$7, 0, true, true));
            }
        }
    }

    public static void playSound(Level p_155104_, BlockPos p_155105_, SoundEvent p_155106_) {
        p_155104_.playSound(null, p_155105_, p_155106_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324570_) {
        return this.saveCustomOnly(p_324570_);
    }

    private static void storeEffect(CompoundTag p_298214_, String p_298983_, @Nullable Holder<MobEffect> p_316689_) {
        if (p_316689_ != null) {
            p_316689_.unwrapKey().ifPresent(p_316401_ -> p_298214_.putString(p_298983_, p_316401_.location().toString()));
        }
    }

    @Nullable
    private static Holder<MobEffect> loadEffect(CompoundTag p_298570_, String p_299310_) {
        return p_298570_.read(p_299310_, BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).filter(VALID_EFFECTS::contains).orElse(null);
    }

    @Override
    protected void loadAdditional(CompoundTag p_338669_, HolderLookup.Provider p_338291_) {
        super.loadAdditional(p_338669_, p_338291_);
        this.primaryPower = BeaconBlockEntity.loadEffect(p_338669_, TAG_PRIMARY);
        this.secondaryPower = BeaconBlockEntity.loadEffect(p_338669_, TAG_SECONDARY);
        this.name = BeaconBlockEntity.parseCustomNameSafe(p_338669_.get("CustomName"), p_338291_);
        this.lockKey = LockCode.fromTag(p_338669_, p_338291_);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187463_, HolderLookup.Provider p_324268_) {
        super.saveAdditional(p_187463_, p_324268_);
        BeaconBlockEntity.storeEffect(p_187463_, TAG_PRIMARY, this.primaryPower);
        BeaconBlockEntity.storeEffect(p_187463_, TAG_SECONDARY, this.secondaryPower);
        p_187463_.putInt("Levels", this.levels);
        p_187463_.storeNullable("CustomName", ComponentSerialization.CODEC, p_324268_.createSerializationContext(NbtOps.INSTANCE), this.name);
        this.lockKey.addToTag(p_187463_, p_324268_);
    }

    public void setCustomName(@Nullable Component p_58682_) {
        this.name = p_58682_;
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int p_58696_, Inventory p_58697_, Player p_58698_) {
        if (BaseContainerBlockEntity.canUnlock(p_58698_, this.lockKey, this.getDisplayName())) {
            return new BeaconMenu(p_58696_, p_58697_, this.dataAccess, ContainerLevelAccess.create(this.level, this.getBlockPos()));
        }
        return null;
    }

    @Override
    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getName() {
        if (this.name != null) {
            return this.name;
        }
        return DEFAULT_NAME;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397309_) {
        super.applyImplicitComponents(p_397309_);
        this.name = p_397309_.get(DataComponents.CUSTOM_NAME);
        this.lockKey = p_397309_.getOrDefault(DataComponents.LOCK, LockCode.NO_LOCK);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338239_) {
        super.collectImplicitComponents(p_338239_);
        p_338239_.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(LockCode.NO_LOCK)) {
            p_338239_.set(DataComponents.LOCK, this.lockKey);
        }
    }

    @Override
    public void removeComponentsFromTag(CompoundTag p_331401_) {
        p_331401_.remove("CustomName");
        p_331401_.remove("lock");
    }

    @Override
    public void setLevel(Level p_155091_) {
        super.setLevel(p_155091_);
        this.lastCheckY = p_155091_.getMinY() - 1;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

