/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CommandBlockEntity
extends BlockEntity {
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_CONDITION_MET = false;
    private static final boolean DEFAULT_AUTOMATIC = false;
    private boolean powered = false;
    private boolean auto = false;
    private boolean conditionMet = false;
    private final BaseCommandBlock commandBlock = new BaseCommandBlock(){

        @Override
        public void setCommand(String p_59157_) {
            super.setCommand(p_59157_);
            CommandBlockEntity.this.setChanged();
        }

        @Override
        public ServerLevel getLevel() {
            return (ServerLevel)CommandBlockEntity.this.level;
        }

        @Override
        public void onUpdated() {
            BlockState $$0 = CommandBlockEntity.this.level.getBlockState(CommandBlockEntity.this.worldPosition);
            this.getLevel().sendBlockUpdated(CommandBlockEntity.this.worldPosition, $$0, $$0, 3);
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.atCenterOf(CommandBlockEntity.this.worldPosition);
        }

        @Override
        public CommandSourceStack createCommandSourceStack() {
            Direction $$0 = CommandBlockEntity.this.getBlockState().getValue(CommandBlock.FACING);
            return new CommandSourceStack(this, Vec3.atCenterOf(CommandBlockEntity.this.worldPosition), new Vec2(0.0f, $$0.toYRot()), this.getLevel(), 2, this.getName().getString(), this.getName(), this.getLevel().getServer(), null);
        }

        @Override
        public boolean isValid() {
            return !CommandBlockEntity.this.isRemoved();
        }
    };

    public CommandBlockEntity(BlockPos p_155380_, BlockState p_155381_) {
        super(BlockEntityType.COMMAND_BLOCK, p_155380_, p_155381_);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187491_, HolderLookup.Provider p_324575_) {
        super.saveAdditional(p_187491_, p_324575_);
        this.commandBlock.save(p_187491_, p_324575_);
        p_187491_.putBoolean("powered", this.isPowered());
        p_187491_.putBoolean("conditionMet", this.wasConditionMet());
        p_187491_.putBoolean("auto", this.isAutomatic());
    }

    @Override
    protected void loadAdditional(CompoundTag p_338502_, HolderLookup.Provider p_338638_) {
        super.loadAdditional(p_338502_, p_338638_);
        this.commandBlock.load(p_338502_, p_338638_);
        this.powered = p_338502_.getBooleanOr("powered", false);
        this.conditionMet = p_338502_.getBooleanOr("conditionMet", false);
        this.setAutomatic(p_338502_.getBooleanOr("auto", false));
    }

    public BaseCommandBlock getCommandBlock() {
        return this.commandBlock;
    }

    public void setPowered(boolean p_59136_) {
        this.powered = p_59136_;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAutomatic() {
        return this.auto;
    }

    public void setAutomatic(boolean p_59138_) {
        boolean $$1 = this.auto;
        this.auto = p_59138_;
        if (!$$1 && p_59138_ && !this.powered && this.level != null && this.getMode() != Mode.SEQUENCE) {
            this.scheduleTick();
        }
    }

    public void onModeSwitch() {
        Mode $$0 = this.getMode();
        if ($$0 == Mode.AUTO && (this.powered || this.auto) && this.level != null) {
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        Block $$0 = this.getBlockState().getBlock();
        if ($$0 instanceof CommandBlock) {
            this.markConditionMet();
            this.level.scheduleTick(this.worldPosition, $$0, 1);
        }
    }

    public boolean wasConditionMet() {
        return this.conditionMet;
    }

    public boolean markConditionMet() {
        this.conditionMet = true;
        if (this.isConditional()) {
            BlockEntity $$1;
            BlockPos $$0 = this.worldPosition.relative(this.level.getBlockState(this.worldPosition).getValue(CommandBlock.FACING).getOpposite());
            this.conditionMet = this.level.getBlockState($$0).getBlock() instanceof CommandBlock ? ($$1 = this.level.getBlockEntity($$0)) instanceof CommandBlockEntity && ((CommandBlockEntity)$$1).getCommandBlock().getSuccessCount() > 0 : false;
        }
        return this.conditionMet;
    }

    public Mode getMode() {
        BlockState $$0 = this.getBlockState();
        if ($$0.is(Blocks.COMMAND_BLOCK)) {
            return Mode.REDSTONE;
        }
        if ($$0.is(Blocks.REPEATING_COMMAND_BLOCK)) {
            return Mode.AUTO;
        }
        if ($$0.is(Blocks.CHAIN_COMMAND_BLOCK)) {
            return Mode.SEQUENCE;
        }
        return Mode.REDSTONE;
    }

    public boolean isConditional() {
        BlockState $$0 = this.level.getBlockState(this.getBlockPos());
        if ($$0.getBlock() instanceof CommandBlock) {
            return $$0.getValue(CommandBlock.CONDITIONAL);
        }
        return false;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397353_) {
        super.applyImplicitComponents(p_397353_);
        this.commandBlock.setCustomName(p_397353_.get(DataComponents.CUSTOM_NAME));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338580_) {
        super.collectImplicitComponents(p_338580_);
        p_338580_.set(DataComponents.CUSTOM_NAME, this.commandBlock.getCustomName());
    }

    @Override
    public void removeComponentsFromTag(CompoundTag p_331967_) {
        super.removeComponentsFromTag(p_331967_);
        p_331967_.remove("CustomName");
        p_331967_.remove("conditionMet");
        p_331967_.remove("powered");
    }

    public static enum Mode {
        SEQUENCE,
        AUTO,
        REDSTONE;

    }
}

