/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private static final int NO_COOLDOWN_TIME = -1;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    private int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;

    public HopperBlockEntity(BlockPos p_155550_, BlockState p_155551_) {
        super(BlockEntityType.HOPPER, p_155550_, p_155551_);
        this.facing = p_155551_.getValue(HopperBlock.FACING);
    }

    @Override
    protected void loadAdditional(CompoundTag p_155588_, HolderLookup.Provider p_324320_) {
        super.loadAdditional(p_155588_, p_324320_);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(p_155588_)) {
            ContainerHelper.loadAllItems(p_155588_, this.items, p_324320_);
        }
        this.cooldownTime = p_155588_.getIntOr("TransferCooldown", -1);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187502_, HolderLookup.Provider p_324174_) {
        super.saveAdditional(p_187502_, p_324174_);
        if (!this.trySaveLootTable(p_187502_)) {
            ContainerHelper.saveAllItems(p_187502_, this.items, p_324174_);
        }
        p_187502_.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public ItemStack removeItem(int p_59309_, int p_59310_) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), p_59309_, p_59310_);
    }

    @Override
    public void setItem(int p_59315_, ItemStack p_59316_) {
        this.unpackLootTable(null);
        this.getItems().set(p_59315_, p_59316_);
        p_59316_.limitSize(this.getMaxStackSize(p_59316_));
    }

    @Override
    public void setBlockState(BlockState p_326468_) {
        super.setBlockState(p_326468_);
        this.facing = p_326468_.getValue(HopperBlock.FACING);
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.hopper");
    }

    public static void pushItemsTick(Level p_155574_, BlockPos p_155575_, BlockState p_155576_, HopperBlockEntity p_155577_) {
        --p_155577_.cooldownTime;
        p_155577_.tickedGameTime = p_155574_.getGameTime();
        if (!p_155577_.isOnCooldown()) {
            p_155577_.setCooldown(0);
            HopperBlockEntity.tryMoveItems(p_155574_, p_155575_, p_155576_, p_155577_, () -> HopperBlockEntity.suckInItems(p_155574_, p_155577_));
        }
    }

    private static boolean tryMoveItems(Level p_155579_, BlockPos p_155580_, BlockState p_155581_, HopperBlockEntity p_155582_, BooleanSupplier p_155583_) {
        if (p_155579_.isClientSide) {
            return false;
        }
        if (!p_155582_.isOnCooldown() && p_155581_.getValue(HopperBlock.ENABLED).booleanValue()) {
            boolean $$5 = false;
            if (!p_155582_.isEmpty()) {
                $$5 = HopperBlockEntity.ejectItems(p_155579_, p_155580_, p_155582_);
            }
            if (!p_155582_.inventoryFull()) {
                $$5 |= p_155583_.getAsBoolean();
            }
            if ($$5) {
                p_155582_.setCooldown(8);
                HopperBlockEntity.setChanged(p_155579_, p_155580_, p_155581_);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack $$0 : this.items) {
            if (!$$0.isEmpty() && $$0.getCount() == $$0.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level p_155563_, BlockPos p_155564_, HopperBlockEntity p_326256_) {
        Container $$3 = HopperBlockEntity.getAttachedContainer(p_155563_, p_155564_, p_326256_);
        if ($$3 == null) {
            return false;
        }
        Direction $$4 = p_326256_.facing.getOpposite();
        if (HopperBlockEntity.isFullContainer($$3, $$4)) {
            return false;
        }
        for (int $$5 = 0; $$5 < p_326256_.getContainerSize(); ++$$5) {
            ItemStack $$6 = p_326256_.getItem($$5);
            if ($$6.isEmpty()) continue;
            int $$7 = $$6.getCount();
            ItemStack $$8 = HopperBlockEntity.addItem(p_326256_, $$3, p_326256_.removeItem($$5, 1), $$4);
            if ($$8.isEmpty()) {
                $$3.setChanged();
                return true;
            }
            $$6.setCount($$7);
            if ($$7 != 1) continue;
            p_326256_.setItem($$5, $$6);
        }
        return false;
    }

    private static int[] getSlots(Container p_59340_, Direction p_59341_) {
        if (p_59340_ instanceof WorldlyContainer) {
            WorldlyContainer $$2 = (WorldlyContainer)p_59340_;
            return $$2.getSlotsForFace(p_59341_);
        }
        int $$3 = p_59340_.getContainerSize();
        if ($$3 < CACHED_SLOTS.length) {
            int[] $$4 = CACHED_SLOTS[$$3];
            if ($$4 != null) {
                return $$4;
            }
            int[] $$5 = HopperBlockEntity.createFlatSlots($$3);
            HopperBlockEntity.CACHED_SLOTS[$$3] = $$5;
            return $$5;
        }
        return HopperBlockEntity.createFlatSlots($$3);
    }

    private static int[] createFlatSlots(int p_326328_) {
        int[] $$1 = new int[p_326328_];
        for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
            $$1[$$2] = $$2;
        }
        return $$1;
    }

    private static boolean isFullContainer(Container p_59386_, Direction p_59387_) {
        int[] $$2;
        for (int $$3 : $$2 = HopperBlockEntity.getSlots(p_59386_, p_59387_)) {
            ItemStack $$4 = p_59386_.getItem($$3);
            if ($$4.getCount() >= $$4.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(Level p_155553_, Hopper p_155554_) {
        boolean $$7;
        BlockState $$3;
        BlockPos $$2 = BlockPos.containing(p_155554_.getLevelX(), p_155554_.getLevelY() + 1.0, p_155554_.getLevelZ());
        Container $$4 = HopperBlockEntity.getSourceContainer(p_155553_, p_155554_, $$2, $$3 = p_155553_.getBlockState($$2));
        if ($$4 != null) {
            Direction $$5 = Direction.DOWN;
            for (int $$6 : HopperBlockEntity.getSlots($$4, $$5)) {
                if (!HopperBlockEntity.tryTakeInItemFromSlot(p_155554_, $$4, $$6, $$5)) continue;
                return true;
            }
            return false;
        }
        boolean bl = $$7 = p_155554_.isGridAligned() && $$3.isCollisionShapeFullBlock(p_155553_, $$2) && !$$3.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (!$$7) {
            for (ItemEntity $$8 : HopperBlockEntity.getItemsAtAndAbove(p_155553_, p_155554_)) {
                if (!HopperBlockEntity.addItem(p_155554_, $$8)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper p_59355_, Container p_59356_, int p_59357_, Direction p_59358_) {
        ItemStack $$4 = p_59356_.getItem(p_59357_);
        if (!$$4.isEmpty() && HopperBlockEntity.canTakeItemFromContainer(p_59355_, p_59356_, $$4, p_59357_, p_59358_)) {
            int $$5 = $$4.getCount();
            ItemStack $$6 = HopperBlockEntity.addItem(p_59356_, p_59355_, p_59356_.removeItem(p_59357_, 1), null);
            if ($$6.isEmpty()) {
                p_59356_.setChanged();
                return true;
            }
            $$4.setCount($$5);
            if ($$5 == 1) {
                p_59356_.setItem(p_59357_, $$4);
            }
        }
        return false;
    }

    public static boolean addItem(Container p_59332_, ItemEntity p_59333_) {
        boolean $$2 = false;
        ItemStack $$3 = p_59333_.getItem().copy();
        ItemStack $$4 = HopperBlockEntity.addItem(null, p_59332_, $$3, null);
        if ($$4.isEmpty()) {
            $$2 = true;
            p_59333_.setItem(ItemStack.EMPTY);
            p_59333_.discard();
        } else {
            p_59333_.setItem($$4);
        }
        return $$2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack addItem(@Nullable Container p_59327_, Container p_59328_, ItemStack p_59329_, @Nullable Direction p_59330_) {
        if (p_59328_ instanceof WorldlyContainer) {
            WorldlyContainer $$4 = (WorldlyContainer)p_59328_;
            if (p_59330_ != null) {
                int[] $$5 = $$4.getSlotsForFace(p_59330_);
                int $$6 = 0;
                while ($$6 < $$5.length) {
                    if (p_59329_.isEmpty()) return p_59329_;
                    p_59329_ = HopperBlockEntity.tryMoveInItem(p_59327_, p_59328_, p_59329_, $$5[$$6], p_59330_);
                    ++$$6;
                }
                return p_59329_;
            }
        }
        int $$7 = p_59328_.getContainerSize();
        int $$8 = 0;
        while ($$8 < $$7) {
            if (p_59329_.isEmpty()) return p_59329_;
            p_59329_ = HopperBlockEntity.tryMoveInItem(p_59327_, p_59328_, p_59329_, $$8, p_59330_);
            ++$$8;
        }
        return p_59329_;
    }

    private static boolean canPlaceItemInContainer(Container p_59335_, ItemStack p_59336_, int p_59337_, @Nullable Direction p_59338_) {
        WorldlyContainer $$4;
        if (!p_59335_.canPlaceItem(p_59337_, p_59336_)) {
            return false;
        }
        return !(p_59335_ instanceof WorldlyContainer) || ($$4 = (WorldlyContainer)p_59335_).canPlaceItemThroughFace(p_59337_, p_59336_, p_59338_);
    }

    private static boolean canTakeItemFromContainer(Container p_273433_, Container p_273542_, ItemStack p_273400_, int p_273519_, Direction p_273088_) {
        WorldlyContainer $$5;
        if (!p_273542_.canTakeItem(p_273433_, p_273519_, p_273400_)) {
            return false;
        }
        return !(p_273542_ instanceof WorldlyContainer) || ($$5 = (WorldlyContainer)p_273542_).canTakeItemThroughFace(p_273519_, p_273400_, p_273088_);
    }

    private static ItemStack tryMoveInItem(@Nullable Container p_59321_, Container p_59322_, ItemStack p_59323_, int p_59324_, @Nullable Direction p_59325_) {
        ItemStack $$5 = p_59322_.getItem(p_59324_);
        if (HopperBlockEntity.canPlaceItemInContainer(p_59322_, p_59323_, p_59324_, p_59325_)) {
            boolean $$6 = false;
            boolean $$7 = p_59322_.isEmpty();
            if ($$5.isEmpty()) {
                p_59322_.setItem(p_59324_, p_59323_);
                p_59323_ = ItemStack.EMPTY;
                $$6 = true;
            } else if (HopperBlockEntity.canMergeItems($$5, p_59323_)) {
                int $$8 = p_59323_.getMaxStackSize() - $$5.getCount();
                int $$9 = Math.min(p_59323_.getCount(), $$8);
                p_59323_.shrink($$9);
                $$5.grow($$9);
                boolean bl = $$6 = $$9 > 0;
            }
            if ($$6) {
                HopperBlockEntity $$10;
                if ($$7 && p_59322_ instanceof HopperBlockEntity && !($$10 = (HopperBlockEntity)p_59322_).isOnCustomCooldown()) {
                    int $$11 = 0;
                    if (p_59321_ instanceof HopperBlockEntity) {
                        HopperBlockEntity $$12 = (HopperBlockEntity)p_59321_;
                        if ($$10.tickedGameTime >= $$12.tickedGameTime) {
                            $$11 = 1;
                        }
                    }
                    $$10.setCooldown(8 - $$11);
                }
                p_59322_.setChanged();
            }
        }
        return p_59323_;
    }

    @Nullable
    private static Container getAttachedContainer(Level p_155593_, BlockPos p_155594_, HopperBlockEntity p_326320_) {
        return HopperBlockEntity.getContainerAt(p_155593_, p_155594_.relative(p_326320_.facing));
    }

    @Nullable
    private static Container getSourceContainer(Level p_155597_, Hopper p_155598_, BlockPos p_326315_, BlockState p_326093_) {
        return HopperBlockEntity.getContainerAt(p_155597_, p_326315_, p_326093_, p_155598_.getLevelX(), p_155598_.getLevelY() + 1.0, p_155598_.getLevelZ());
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level p_155590_, Hopper p_155591_) {
        AABB $$2 = p_155591_.getSuckAabb().move(p_155591_.getLevelX() - 0.5, p_155591_.getLevelY() - 0.5, p_155591_.getLevelZ() - 0.5);
        return p_155590_.getEntitiesOfClass(ItemEntity.class, $$2, EntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static Container getContainerAt(Level p_59391_, BlockPos p_59392_) {
        return HopperBlockEntity.getContainerAt(p_59391_, p_59392_, p_59391_.getBlockState(p_59392_), (double)p_59392_.getX() + 0.5, (double)p_59392_.getY() + 0.5, (double)p_59392_.getZ() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level p_59348_, BlockPos p_326114_, BlockState p_326445_, double p_59349_, double p_59350_, double p_59351_) {
        Container $$6 = HopperBlockEntity.getBlockContainer(p_59348_, p_326114_, p_326445_);
        if ($$6 == null) {
            $$6 = HopperBlockEntity.getEntityContainer(p_59348_, p_59349_, p_59350_, p_59351_);
        }
        return $$6;
    }

    @Nullable
    private static Container getBlockContainer(Level p_326127_, BlockPos p_326017_, BlockState p_326108_) {
        BlockEntity $$4;
        Block $$3 = p_326108_.getBlock();
        if ($$3 instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)((Object)$$3)).getContainer(p_326108_, p_326127_, p_326017_);
        }
        if (p_326108_.hasBlockEntity() && ($$4 = p_326127_.getBlockEntity(p_326017_)) instanceof Container) {
            Container $$5 = (Container)((Object)$$4);
            if ($$5 instanceof ChestBlockEntity && $$3 instanceof ChestBlock) {
                $$5 = ChestBlock.getContainer((ChestBlock)$$3, p_326108_, p_326127_, p_326017_, true);
            }
            return $$5;
        }
        return null;
    }

    @Nullable
    private static Container getEntityContainer(Level p_326325_, double p_326012_, double p_326191_, double p_326289_) {
        List<Entity> $$4 = p_326325_.getEntities((Entity)null, new AABB(p_326012_ - 0.5, p_326191_ - 0.5, p_326289_ - 0.5, p_326012_ + 0.5, p_326191_ + 0.5, p_326289_ + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR);
        if (!$$4.isEmpty()) {
            return (Container)((Object)$$4.get(p_326325_.random.nextInt($$4.size())));
        }
        return null;
    }

    private static boolean canMergeItems(ItemStack p_59345_, ItemStack p_59346_) {
        return p_59345_.getCount() <= p_59345_.getMaxStackSize() && ItemStack.isSameItemSameComponents(p_59345_, p_59346_);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    private void setCooldown(int p_59396_) {
        this.cooldownTime = p_59396_;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> p_59371_) {
        this.items = p_59371_;
    }

    public static void entityInside(Level p_155568_, BlockPos p_155569_, BlockState p_155570_, Entity p_155571_, HopperBlockEntity p_155572_) {
        ItemEntity $$5;
        if (p_155571_ instanceof ItemEntity && !($$5 = (ItemEntity)p_155571_).getItem().isEmpty() && p_155571_.getBoundingBox().move(-p_155569_.getX(), -p_155569_.getY(), -p_155569_.getZ()).intersects(p_155572_.getSuckAabb())) {
            HopperBlockEntity.tryMoveItems(p_155568_, p_155569_, p_155570_, p_155572_, () -> HopperBlockEntity.addItem(p_155572_, $$5));
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int p_59312_, Inventory p_59313_) {
        return new HopperMenu(p_59312_, p_59313_, this);
    }
}

