/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Services;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SkullBlockEntity
extends BlockEntity {
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    private static final String TAG_CUSTOM_NAME = "custom_name";
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @Nullable
    private static LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> profileCacheById;
    public static final Executor CHECKED_MAIN_THREAD_EXECUTOR;
    @Nullable
    private ResolvableProfile owner;
    @Nullable
    private ResourceLocation noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;
    @Nullable
    private Component customName;

    public SkullBlockEntity(BlockPos p_155731_, BlockState p_155732_) {
        super(BlockEntityType.SKULL, p_155731_, p_155732_);
    }

    public static void setup(final Services p_222886_, Executor p_222887_) {
        mainThreadExecutor = p_222887_;
        final BooleanSupplier $$2 = () -> profileCacheById == null;
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(String p_304652_) {
                return SkullBlockEntity.fetchProfileByName(p_304652_, p_222886_);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((String)object);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(UUID p_339657_) {
                return SkullBlockEntity.fetchProfileById(p_339657_, p_222886_, $$2);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((UUID)object);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileByName(String p_339683_, Services p_339592_) {
        return p_339592_.profileCache().getAsync(p_339683_).thenCompose(p_339545_ -> {
            LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> $$1 = profileCacheById;
            if ($$1 == null || p_339545_.isEmpty()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return ((CompletableFuture)$$1.getUnchecked((Object)((GameProfile)p_339545_.get()).getId())).thenApply(p_339543_ -> p_339543_.or(() -> p_339545_));
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(UUID p_339663_, Services p_339676_, BooleanSupplier p_339631_) {
        return CompletableFuture.supplyAsync(() -> {
            if (p_339631_.getAsBoolean()) {
                return Optional.empty();
            }
            ProfileResult $$3 = p_339676_.sessionService().fetchProfile(p_339663_, true);
            return Optional.ofNullable($$3).map(ProfileResult::profile);
        }, Util.backgroundExecutor().forName("fetchProfile"));
    }

    public static void clear() {
        mainThreadExecutor = null;
        profileCacheByName = null;
        profileCacheById = null;
    }

    @Override
    protected void saveAdditional(CompoundTag p_187518_, HolderLookup.Provider p_324418_) {
        super.saveAdditional(p_187518_, p_324418_);
        p_187518_.storeNullable(TAG_PROFILE, ResolvableProfile.CODEC, this.owner);
        p_187518_.storeNullable(TAG_NOTE_BLOCK_SOUND, ResourceLocation.CODEC, this.noteBlockSound);
        p_187518_.storeNullable(TAG_CUSTOM_NAME, ComponentSerialization.CODEC, p_324418_.createSerializationContext(NbtOps.INSTANCE), this.customName);
    }

    @Override
    protected void loadAdditional(CompoundTag p_155745_, HolderLookup.Provider p_323876_) {
        super.loadAdditional(p_155745_, p_323876_);
        this.setOwner(p_155745_.read(TAG_PROFILE, ResolvableProfile.CODEC).orElse(null));
        this.noteBlockSound = p_155745_.read(TAG_NOTE_BLOCK_SOUND, ResourceLocation.CODEC).orElse(null);
        this.customName = SkullBlockEntity.parseCustomNameSafe(p_155745_.get(TAG_CUSTOM_NAME), p_323876_);
    }

    public static void animation(Level p_261710_, BlockPos p_262153_, BlockState p_262021_, SkullBlockEntity p_261594_) {
        if (p_262021_.hasProperty(SkullBlock.POWERED) && p_262021_.getValue(SkullBlock.POWERED).booleanValue()) {
            p_261594_.isAnimating = true;
            ++p_261594_.animationTickCount;
        } else {
            p_261594_.isAnimating = false;
        }
    }

    public float getAnimation(float p_262053_) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + p_262053_;
        }
        return this.animationTickCount;
    }

    @Nullable
    public ResolvableProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_323711_) {
        return this.saveCustomOnly(p_323711_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable ResolvableProfile p_332738_) {
        SkullBlockEntity skullBlockEntity = this;
        synchronized (skullBlockEntity) {
            this.owner = p_332738_;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.owner == null || this.owner.isResolved()) {
            this.setChanged();
            return;
        }
        this.owner.resolve().thenAcceptAsync(p_332638_ -> {
            this.owner = p_332638_;
            this.setChanged();
        }, CHECKED_MAIN_THREAD_EXECUTOR);
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String p_295932_) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> $$1 = profileCacheByName;
        if ($$1 != null && StringUtil.isValidPlayerName(p_295932_)) {
            return (CompletableFuture)$$1.getUnchecked((Object)p_295932_);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID p_339604_) {
        LoadingCache<UUID, CompletableFuture<Optional<GameProfile>>> $$1 = profileCacheById;
        if ($$1 != null) {
            return (CompletableFuture)$$1.getUnchecked((Object)p_339604_);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397656_) {
        super.applyImplicitComponents(p_397656_);
        this.setOwner(p_397656_.get(DataComponents.PROFILE));
        this.noteBlockSound = p_397656_.get(DataComponents.NOTE_BLOCK_SOUND);
        this.customName = p_397656_.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338880_) {
        super.collectImplicitComponents(p_338880_);
        p_338880_.set(DataComponents.PROFILE, this.owner);
        p_338880_.set(DataComponents.NOTE_BLOCK_SOUND, this.noteBlockSound);
        p_338880_.set(DataComponents.CUSTOM_NAME, this.customName);
    }

    @Override
    public void removeComponentsFromTag(CompoundTag p_331773_) {
        super.removeComponentsFromTag(p_331773_);
        p_331773_.remove(TAG_PROFILE);
        p_331773_.remove(TAG_NOTE_BLOCK_SOUND);
        p_331773_.remove(TAG_CUSTOM_NAME);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    static {
        CHECKED_MAIN_THREAD_EXECUTOR = p_294078_ -> {
            Executor $$1 = mainThreadExecutor;
            if ($$1 != null) {
                $$1.execute(p_294078_);
            }
        };
    }
}

