/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public class TestInstanceBlockEntity
extends BlockEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final Component INVALID_TEST_NAME = Component.translatable("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.Section> BEAM_CLEARED = List.of();
    private static final List<BeaconBeamOwner.Section> BEAM_RUNNING = List.of(new BeaconBeamOwner.Section(ARGB.color(128, 128, 128)));
    private static final List<BeaconBeamOwner.Section> BEAM_SUCCESS = List.of(new BeaconBeamOwner.Section(ARGB.color(0, 255, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_REQUIRED_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 0, 0)));
    private static final List<BeaconBeamOwner.Section> BEAM_OPTIONAL_FAILED = List.of(new BeaconBeamOwner.Section(ARGB.color(255, 128, 0)));
    private static final Vec3i STRUCTURE_OFFSET = new Vec3i(0, 1, 1);
    private Data data = new Data(Optional.empty(), Vec3i.ZERO, Rotation.NONE, false, Status.CLEARED, Optional.empty());

    public TestInstanceBlockEntity(BlockPos p_398018_, BlockState p_397894_) {
        super(BlockEntityType.TEST_INSTANCE_BLOCK, p_398018_, p_397894_);
    }

    public void set(Data p_397682_) {
        this.data = p_397682_;
        this.setChanged();
    }

    public static Optional<Vec3i> getStructureSize(ServerLevel p_397895_, ResourceKey<GameTestInstance> p_397299_) {
        return TestInstanceBlockEntity.getStructureTemplate(p_397895_, p_397299_).map(StructureTemplate::getSize);
    }

    public BoundingBox getStructureBoundingBox() {
        BlockPos $$0 = this.getStructurePos();
        BlockPos $$1 = $$0.offset(this.getTransformedSize()).offset(-1, -1, -1);
        return BoundingBox.fromCorners($$0, $$1);
    }

    public AABB getStructureBounds() {
        return AABB.of(this.getStructureBoundingBox());
    }

    private static Optional<StructureTemplate> getStructureTemplate(ServerLevel p_397539_, ResourceKey<GameTestInstance> p_397417_) {
        return p_397539_.registryAccess().get(p_397417_).map(p_397340_ -> ((GameTestInstance)p_397340_.value()).structure()).flatMap(p_396996_ -> p_397539_.getStructureManager().get((ResourceLocation)p_396996_));
    }

    public Optional<ResourceKey<GameTestInstance>> test() {
        return this.data.test();
    }

    public Component getTestName() {
        return this.test().map(p_397722_ -> Component.literal(p_397722_.location().toString())).orElse(INVALID_TEST_NAME);
    }

    private Optional<Holder.Reference<GameTestInstance>> getTestHolder() {
        return this.test().flatMap(this.level.registryAccess()::get);
    }

    public boolean ignoreEntities() {
        return this.data.ignoreEntities();
    }

    public Vec3i getSize() {
        return this.data.size();
    }

    public Rotation getRotation() {
        return this.getTestHolder().map(Holder::value).map(GameTestInstance::rotation).orElse(Rotation.NONE).getRotated(this.data.rotation());
    }

    public Optional<Component> errorMessage() {
        return this.data.errorMessage();
    }

    public void setErrorMessage(Component p_397179_) {
        this.set(this.data.withError(p_397179_));
    }

    public void setSuccess() {
        this.set(this.data.withStatus(Status.FINISHED));
        this.removeBarriers();
    }

    public void setRunning() {
        this.set(this.data.withStatus(Status.RUNNING));
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_397498_) {
        CompoundTag $$1 = new CompoundTag();
        this.saveAdditional($$1, p_397498_);
        return $$1;
    }

    @Override
    protected void loadAdditional(CompoundTag p_398056_, HolderLookup.Provider p_397876_) {
        Tag $$2 = p_398056_.get("data");
        if ($$2 == null) {
            return;
        }
        Data.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$2).ifSuccess(this::set);
    }

    @Override
    protected void saveAdditional(CompoundTag p_397008_, HolderLookup.Provider p_397043_) {
        DataResult $$2 = Data.CODEC.encode((Object)this.data, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag());
        $$2.ifSuccess(p_397473_ -> p_397008_.put("data", (Tag)p_397473_));
    }

    @Override
    public BoundingBoxRenderable.Mode renderMode() {
        return BoundingBoxRenderable.Mode.BOX;
    }

    public BlockPos getStructurePos() {
        return TestInstanceBlockEntity.getStructurePos(this.getBlockPos());
    }

    public static BlockPos getStructurePos(BlockPos p_397863_) {
        return p_397863_.offset(STRUCTURE_OFFSET);
    }

    @Override
    public BoundingBoxRenderable.RenderableBox getRenderableBox() {
        return new BoundingBoxRenderable.RenderableBox(new BlockPos(STRUCTURE_OFFSET), this.getTransformedSize());
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return switch (this.data.status().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BEAM_CLEARED;
            case 1 -> BEAM_RUNNING;
            case 2 -> this.errorMessage().isEmpty() ? BEAM_SUCCESS : (this.getTestHolder().map(Holder::value).map(GameTestInstance::required).orElse(true) != false ? BEAM_REQUIRED_FAILED : BEAM_OPTIONAL_FAILED);
        };
    }

    private Vec3i getTransformedSize() {
        Vec3i $$0 = this.getSize();
        Rotation $$1 = this.getRotation();
        boolean $$2 = $$1 == Rotation.CLOCKWISE_90 || $$1 == Rotation.COUNTERCLOCKWISE_90;
        int $$3 = $$2 ? $$0.getZ() : $$0.getX();
        int $$4 = $$2 ? $$0.getX() : $$0.getZ();
        return new Vec3i($$3, $$0.getY(), $$4);
    }

    public void resetTest(Consumer<Component> p_397939_) {
        this.removeBarriers();
        boolean $$1 = this.placeStructure();
        if ($$1) {
            p_397939_.accept(Component.translatable("test_instance_block.reset_success", this.getTestName()).withStyle(ChatFormatting.GREEN));
        }
        this.set(this.data.withStatus(Status.CLEARED));
    }

    public Optional<ResourceLocation> saveTest(Consumer<Component> p_398041_) {
        Optional<ResourceLocation> $$3;
        Optional<Holder.Reference<GameTestInstance>> $$1 = this.getTestHolder();
        if ($$1.isPresent()) {
            Optional<ResourceLocation> $$2 = Optional.of($$1.get().value().structure());
        } else {
            $$3 = this.test().map(ResourceKey::location);
        }
        if ($$3.isEmpty()) {
            BlockPos $$4 = this.getBlockPos();
            p_398041_.accept(Component.translatable("test_instance_block.error.unable_to_save", $$4.getX(), $$4.getY(), $$4.getZ()).withStyle(ChatFormatting.RED));
            return $$3;
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)level;
            StructureBlockEntity.saveStructure($$5, $$3.get(), this.getStructurePos(), this.getSize(), this.ignoreEntities(), "", true);
        }
        return $$3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean exportTest(Consumer<Component> p_396997_) {
        void $$3;
        Level level;
        Optional<ResourceLocation> $$1 = this.saveTest(p_396997_);
        if ($$1.isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel $$2 = (ServerLevel)level;
        return TestInstanceBlockEntity.export((ServerLevel)$$3, $$1.get(), p_396997_);
    }

    public static boolean export(ServerLevel p_397725_, ResourceLocation p_397333_, Consumer<Component> p_397846_) {
        Path $$3 = StructureUtils.testStructuresDir;
        Path $$4 = p_397725_.getStructureManager().createAndValidatePathToGeneratedStructure(p_397333_, ".nbt");
        Path $$5 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, $$4, p_397333_.getPath(), $$3.resolve(p_397333_.getNamespace()).resolve("structure"));
        if ($$5 == null) {
            p_397846_.accept(Component.literal("Failed to export " + String.valueOf($$4)).withStyle(ChatFormatting.RED));
            return true;
        }
        try {
            FileUtil.createDirectoriesSafe($$5.getParent());
        }
        catch (IOException $$6) {
            p_397846_.accept(Component.literal("Could not create folder " + String.valueOf($$5.getParent())).withStyle(ChatFormatting.RED));
            return true;
        }
        p_397846_.accept(Component.literal("Exported " + String.valueOf(p_397333_) + " to " + String.valueOf($$5.toAbsolutePath())));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void runTest(Consumer<Component> p_397726_) {
        void $$2;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        Optional<Holder.Reference<GameTestInstance>> $$3 = this.getTestHolder();
        BlockPos $$4 = this.getBlockPos();
        if ($$3.isEmpty()) {
            p_397726_.accept(Component.translatable("test_instance_block.error.no_test", $$4.getX(), $$4.getY(), $$4.getZ()).withStyle(ChatFormatting.RED));
            return;
        }
        if (!this.placeStructure()) {
            p_397726_.accept(Component.translatable("test_instance_block.error.no_test_structure", $$4.getX(), $$4.getY(), $$4.getZ()).withStyle(ChatFormatting.RED));
            return;
        }
        GameTestRunner.clearMarkers((ServerLevel)$$2);
        GameTestTicker.SINGLETON.clear();
        FailedTestTracker.forgetFailedTests();
        p_397726_.accept(Component.translatable("test_instance_block.starting", $$3.get().getRegisteredName()));
        GameTestInfo $$5 = new GameTestInfo($$3.get(), this.data.rotation(), (ServerLevel)$$2, RetryOptions.noRetries());
        $$5.setTestBlockPos($$4);
        GameTestRunner $$6 = GameTestRunner.Builder.fromInfo(List.of($$5), (ServerLevel)$$2).build();
        TestCommand.trackAndStartRunner($$2.getServer().createCommandSourceStack(), $$6);
    }

    public boolean placeStructure() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            Optional $$1 = this.data.test().flatMap(p_397292_ -> TestInstanceBlockEntity.getStructureTemplate($$0, p_397292_));
            if ($$1.isPresent()) {
                this.placeStructure($$0, (StructureTemplate)$$1.get());
                return true;
            }
        }
        return false;
    }

    private void placeStructure(ServerLevel p_397984_, StructureTemplate p_397168_) {
        StructurePlaceSettings $$2 = new StructurePlaceSettings().setRotation(this.getRotation()).setIgnoreEntities(this.data.ignoreEntities()).setKnownShape(true);
        BlockPos $$3 = this.getStartCorner();
        this.forceLoadChunks();
        this.removeEntities();
        p_397168_.placeInWorld(p_397984_, $$3, $$3, $$2, p_397984_.getRandom(), 818);
    }

    private void removeEntities() {
        this.level.getEntities(null, this.getStructureBounds()).stream().filter(p_399456_ -> !(p_399456_ instanceof Player)).forEach(Entity::discard);
    }

    private void forceLoadChunks() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            this.getStructureBoundingBox().intersectingChunks().forEach(p_397470_ -> $$0.setChunkForced(p_397470_.x, p_397470_.z, true));
        }
    }

    public BlockPos getStartCorner() {
        Vec3i $$0 = this.getSize();
        Rotation $$1 = this.getRotation();
        BlockPos $$2 = this.getStructurePos();
        return switch ($$1) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> $$2;
            case Rotation.CLOCKWISE_90 -> $$2.offset($$0.getZ() - 1, 0, 0);
            case Rotation.CLOCKWISE_180 -> $$2.offset($$0.getX() - 1, 0, $$0.getZ() - 1);
            case Rotation.COUNTERCLOCKWISE_90 -> $$2.offset(0, 0, $$0.getX() - 1);
        };
    }

    public void encaseStructure() {
        this.processStructureBoundary(p_397469_ -> {
            if (!this.level.getBlockState((BlockPos)p_397469_).is(Blocks.TEST_INSTANCE_BLOCK)) {
                this.level.setBlockAndUpdate((BlockPos)p_397469_, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public void removeBarriers() {
        this.processStructureBoundary(p_398011_ -> {
            if (this.level.getBlockState((BlockPos)p_398011_).is(Blocks.BARRIER)) {
                this.level.setBlockAndUpdate((BlockPos)p_398011_, Blocks.AIR.defaultBlockState());
            }
        });
    }

    public void processStructureBoundary(Consumer<BlockPos> p_397268_) {
        AABB $$1 = this.getStructureBounds();
        boolean $$2 = this.getTestHolder().map(p_397339_ -> ((GameTestInstance)p_397339_.value()).skyAccess()).orElse(false) == false;
        BlockPos $$3 = BlockPos.containing($$1.minX, $$1.minY, $$1.minZ).offset(-1, -1, -1);
        BlockPos $$4 = BlockPos.containing($$1.maxX, $$1.maxY, $$1.maxZ);
        BlockPos.betweenClosedStream($$3, $$4).forEach(p_397351_ -> {
            boolean $$6;
            boolean $$5 = p_397351_.getX() == $$3.getX() || p_397351_.getX() == $$4.getX() || p_397351_.getZ() == $$3.getZ() || p_397351_.getZ() == $$4.getZ() || p_397351_.getY() == $$3.getY();
            boolean bl = $$6 = p_397351_.getY() == $$4.getY();
            if ($$5 || $$6 && $$2) {
                p_397268_.accept((BlockPos)p_397351_);
            }
        });
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public record Data(Optional<ResourceKey<GameTestInstance>> test, Vec3i size, Rotation rotation, boolean ignoreEntities, Status status, Optional<Component> errorMessage) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(p_397596_ -> p_397596_.group((App)ResourceKey.codec(Registries.TEST_INSTANCE).optionalFieldOf("test").forGetter(Data::test), (App)Vec3i.CODEC.fieldOf("size").forGetter(Data::size), (App)Rotation.CODEC.fieldOf("rotation").forGetter(Data::rotation), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(Data::ignoreEntities), (App)Status.CODEC.fieldOf("status").forGetter(Data::status), (App)ComponentSerialization.CODEC.optionalFieldOf("error_message").forGetter(Data::errorMessage)).apply((Applicative)p_397596_, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ResourceKey.streamCodec(Registries.TEST_INSTANCE)), Data::test, Vec3i.STREAM_CODEC, Data::size, Rotation.STREAM_CODEC, Data::rotation, ByteBufCodecs.BOOL, Data::ignoreEntities, Status.STREAM_CODEC, Data::status, ByteBufCodecs.optional(ComponentSerialization.STREAM_CODEC), Data::errorMessage, Data::new);

        public Data withSize(Vec3i p_397709_) {
            return new Data(this.test, p_397709_, this.rotation, this.ignoreEntities, this.status, this.errorMessage);
        }

        public Data withStatus(Status p_398013_) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, p_398013_, Optional.empty());
        }

        public Data withError(Component p_397453_) {
            return new Data(this.test, this.size, this.rotation, this.ignoreEntities, Status.FINISHED, Optional.of(p_397453_));
        }
    }

    public static enum Status implements StringRepresentable
    {
        CLEARED("cleared", 0),
        RUNNING("running", 1),
        FINISHED("finished", 2);

        private static final IntFunction<Status> ID_MAP;
        public static final Codec<Status> CODEC;
        public static final StreamCodec<ByteBuf, Status> STREAM_CODEC;
        private final String id;
        private final int index;

        private Status(String p_397410_, int p_397632_) {
            this.id = p_397410_;
            this.index = p_397632_;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static Status byIndex(int p_397227_) {
            return ID_MAP.apply(p_397227_);
        }

        static {
            ID_MAP = ByIdMap.continuous(p_397441_ -> p_397441_.index, Status.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Status::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(Status::byIndex, p_397803_ -> p_397803_.index);
        }
    }
}

