/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private Holder<TrialSpawnerConfig> normalConfig;
    private Holder<TrialSpawnerConfig> ominousConfig;
    private final TrialSpawnerData data;
    private final int requiredPlayerRange;
    private final int targetCooldownLength;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public MapCodec<TrialSpawner> codec() {
        return RecordCodecBuilder.mapCodec(p_368470_ -> p_368470_.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(p_368468_ -> p_368468_.normalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(p_368469_ -> p_368469_.ominousConfig), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)p_368470_, (p_368463_, p_368464_, p_368465_, p_368466_, p_368467_) -> new TrialSpawner((Holder<TrialSpawnerConfig>)p_368463_, (Holder<TrialSpawnerConfig>)p_368464_, (TrialSpawnerData)p_368465_, (int)p_368466_, (int)p_368467_, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(StateAccessor p_312676_, PlayerDetector p_312004_, PlayerDetector.EntitySelector p_323917_) {
        this(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), new TrialSpawnerData(), 36000, 14, p_312676_, p_312004_, p_323917_);
    }

    public TrialSpawner(Holder<TrialSpawnerConfig> p_368597_, Holder<TrialSpawnerConfig> p_368488_, TrialSpawnerData p_323470_, int p_338747_, int p_338885_, StateAccessor p_312198_, PlayerDetector p_312690_, PlayerDetector.EntitySelector p_323834_) {
        this.normalConfig = p_368597_;
        this.ominousConfig = p_368488_;
        this.data = p_323470_;
        this.targetCooldownLength = p_338747_;
        this.requiredPlayerRange = p_338885_;
        this.stateAccessor = p_312198_;
        this.playerDetector = p_312690_;
        this.entitySelector = p_323834_;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.getOminousConfig() : this.getNormalConfig();
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig.value();
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig.value();
    }

    public void applyOminous(ServerLevel p_338315_, BlockPos p_338416_) {
        p_338315_.setBlock(p_338416_, (BlockState)p_338315_.getBlockState(p_338416_).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        p_338315_.levelEvent(3020, p_338416_, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, p_338315_);
    }

    public void removeOminous(ServerLevel p_338672_, BlockPos p_338318_) {
        p_338672_.setBlock(p_338318_, (BlockState)p_338672_.getBlockState(p_338318_).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level p_312688_, TrialSpawnerState p_312718_) {
        this.stateAccessor.setState(p_312688_, p_312718_);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(ServerLevel p_376465_) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (p_376465_.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_376465_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(ServerLevel p_312582_, BlockPos p_312518_) {
        SpawnData.CustomSpawnRules $$8;
        RandomSource $$2 = p_312582_.getRandom();
        SpawnData $$3 = this.data.getOrCreateNextSpawnData(this, p_312582_.getRandom());
        CompoundTag $$4 = $$3.entityToSpawn();
        Optional<EntityType<?>> $$5 = EntityType.by($$4);
        if ($$5.isEmpty()) {
            return Optional.empty();
        }
        Vec3 $$6 = $$4.read("Pos", Vec3.CODEC).orElseGet(() -> new Vec3((double)p_312518_.getX() + ($$2.nextDouble() - $$2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5, p_312518_.getY() + $$2.nextInt(3) - 1, (double)p_312518_.getZ() + ($$2.nextDouble() - $$2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5));
        if (!p_312582_.noCollision($$5.get().getSpawnAABB($$6.x, $$6.y, $$6.z))) {
            return Optional.empty();
        }
        if (!TrialSpawner.inLineOfSight(p_312582_, p_312518_.getCenter(), $$6)) {
            return Optional.empty();
        }
        BlockPos $$7 = BlockPos.containing($$6);
        if (!SpawnPlacements.checkSpawnRules($$5.get(), p_312582_, EntitySpawnReason.TRIAL_SPAWNER, $$7, p_312582_.getRandom())) {
            return Optional.empty();
        }
        if ($$3.getCustomSpawnRules().isPresent() && !($$8 = $$3.getCustomSpawnRules().get()).isValidPosition($$7, p_312582_)) {
            return Optional.empty();
        }
        Entity $$9 = EntityType.loadEntityRecursive($$4, p_312582_, EntitySpawnReason.TRIAL_SPAWNER, p_404588_ -> {
            p_404588_.snapTo(p_404586_.x, p_404586_.y, p_404586_.z, $$2.nextFloat() * 360.0f, 0.0f);
            return p_404588_;
        });
        if ($$9 == null) {
            return Optional.empty();
        }
        if ($$9 instanceof Mob) {
            boolean $$11;
            Mob $$10 = (Mob)$$9;
            if (!$$10.checkSpawnObstruction(p_312582_)) {
                return Optional.empty();
            }
            boolean bl = $$11 = $$3.getEntityToSpawn().size() == 1 && $$3.getEntityToSpawn().getString("id").isPresent();
            if ($$11) {
                $$10.finalizeSpawn(p_312582_, p_312582_.getCurrentDifficultyAt($$10.blockPosition()), EntitySpawnReason.TRIAL_SPAWNER, null);
            }
            $$10.setPersistenceRequired();
            $$3.getEquipment().ifPresent($$10::equip);
        }
        if (!p_312582_.tryAddFreshEntityWithPassengers($$9)) {
            return Optional.empty();
        }
        FlameParticle $$12 = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
        p_312582_.levelEvent(3011, p_312518_, $$12.encode());
        p_312582_.levelEvent(3012, $$7, $$12.encode());
        p_312582_.gameEvent($$9, GameEvent.ENTITY_PLACE, $$7);
        return Optional.of($$9.getUUID());
    }

    public void ejectReward(ServerLevel p_312892_, BlockPos p_312668_, ResourceKey<LootTable> p_335942_) {
        LootParams $$4;
        LootTable $$3 = p_312892_.getServer().reloadableRegistries().getLootTable(p_335942_);
        ObjectArrayList<ItemStack> $$5 = $$3.getRandomItems($$4 = new LootParams.Builder(p_312892_).create(LootContextParamSets.EMPTY));
        if (!$$5.isEmpty()) {
            for (ItemStack $$6 : $$5) {
                DefaultDispenseItemBehavior.spawnItem(p_312892_, $$6, 2, Direction.UP, Vec3.atBottomCenterOf(p_312668_).relative(Direction.UP, 1.2));
            }
            p_312892_.levelEvent(3014, p_312668_, 0);
        }
    }

    public void tickClient(Level p_312771_, BlockPos p_312484_, boolean p_338382_) {
        RandomSource $$5;
        TrialSpawnerState $$3 = this.getState();
        $$3.emitParticles(p_312771_, p_312484_, p_338382_);
        if ($$3.hasSpinningMob()) {
            double $$4 = Math.max(0L, this.data.nextMobSpawnsAt - p_312771_.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + $$3.spinningMobSpeed() / ($$4 + 200.0)) % 360.0;
        }
        if ($$3.isCapableOfSpawning() && ($$5 = p_312771_.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent $$6 = p_338382_ ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            p_312771_.playLocalSound(p_312484_, $$6, SoundSource.BLOCKS, $$5.nextFloat() * 0.25f + 0.75f, $$5.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel p_312132_, BlockPos p_312062_, boolean p_338207_) {
        TrialSpawnerState $$4;
        this.isOminous = p_338207_;
        TrialSpawnerState $$3 = this.getState();
        if (this.data.currentMobs.removeIf(p_312870_ -> TrialSpawner.shouldMobBeUntracked(p_312132_, p_312062_, p_312870_))) {
            this.data.nextMobSpawnsAt = p_312132_.getGameTime() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if (($$4 = $$3.tickAndGetNext(p_312062_, this, p_312132_)) != $$3) {
            this.setState(p_312132_, $$4);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel p_312908_, BlockPos p_312807_, UUID p_311952_) {
        Entity $$3 = p_312908_.getEntity(p_311952_);
        return $$3 == null || !$$3.isAlive() || !$$3.level().dimension().equals(p_312908_.dimension()) || $$3.blockPosition().distSqr(p_312807_) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level p_312623_, Vec3 p_312390_, Vec3 p_312652_) {
        BlockHitResult $$3 = p_312623_.clip(new ClipContext(p_312652_, p_312390_, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return $$3.getBlockPos().equals(BlockPos.containing(p_312390_)) || $$3.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level p_312303_, BlockPos p_312392_, RandomSource p_312825_, SimpleParticleType p_338426_) {
        for (int $$4 = 0; $$4 < 20; ++$$4) {
            double $$5 = (double)p_312392_.getX() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)p_312392_.getY() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double $$7 = (double)p_312392_.getZ() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            p_312303_.addParticle(ParticleTypes.SMOKE, $$5, $$6, $$7, 0.0, 0.0, 0.0);
            p_312303_.addParticle(p_338426_, $$5, $$6, $$7, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level p_338657_, BlockPos p_338406_, RandomSource p_338527_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_338406_.getX() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$5 = (double)p_338406_.getY() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)p_338406_.getZ() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$7 = p_338527_.nextGaussian() * 0.02;
            double $$8 = p_338527_.nextGaussian() * 0.02;
            double $$9 = p_338527_.nextGaussian() * 0.02;
            p_338657_.addParticle(ParticleTypes.TRIAL_OMEN, $$4, $$5, $$6, $$7, $$8, $$9);
            p_338657_.addParticle(ParticleTypes.SOUL_FIRE_FLAME, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    public static void addDetectPlayerParticles(Level p_312225_, BlockPos p_311759_, RandomSource p_312553_, int p_312188_, ParticleOptions p_338522_) {
        for (int $$5 = 0; $$5 < 30 + Math.min(p_312188_, 10) * 5; ++$$5) {
            double $$6 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double $$7 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double $$8 = (double)p_311759_.getX() + 0.5 + $$6;
            double $$9 = (double)p_311759_.getY() + 0.1 + (double)p_312553_.nextFloat() * 0.8;
            double $$10 = (double)p_311759_.getZ() + 0.5 + $$7;
            p_312225_.addParticle(p_338522_, $$8, $$9, $$10, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level p_312009_, BlockPos p_312583_, RandomSource p_312715_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_312583_.getX() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$5 = (double)p_312583_.getY() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$6 = (double)p_312583_.getZ() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$7 = p_312715_.nextGaussian() * 0.02;
            double $$8 = p_312715_.nextGaussian() * 0.02;
            double $$9 = p_312715_.nextGaussian() * 0.02;
            p_312009_.addParticle(ParticleTypes.SMALL_FLAME, $$4, $$5, $$6, $$7, $$8, $$9 * 0.25);
            p_312009_.addParticle(ParticleTypes.SMOKE, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    public void overrideEntityToSpawn(EntityType<?> p_387174_, Level p_386596_) {
        this.data.reset();
        this.normalConfig = Holder.direct(this.normalConfig.value().withSpawning(p_387174_));
        this.ominousConfig = Holder.direct(this.ominousConfig.value().withSpawning(p_387174_));
        this.setState(p_386596_, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector p_312510_) {
        this.playerDetector = p_312510_;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType p_338374_) {
            this.particleType = p_338374_;
        }

        public static FlameParticle decode(int p_338695_) {
            FlameParticle[] $$1 = FlameParticle.values();
            if (p_338695_ > $$1.length || p_338695_ < 0) {
                return NORMAL;
            }
            return $$1[p_338695_];
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

