/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMath;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonMovingBlockEntity
extends BlockEntity {
    private static final int TICKS_TO_EXTEND = 2;
    private static final double PUSH_OFFSET = 0.01;
    public static final double TICK_MOVEMENT = 0.51;
    private static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
    private static final float DEFAULT_PROGRESS = 0.0f;
    private static final boolean DEFAULT_EXTENDING = false;
    private static final boolean DEFAULT_SOURCE = false;
    private BlockState movedState = DEFAULT_BLOCK_STATE;
    private Direction direction;
    private boolean extending = false;
    private boolean isSourcePiston = false;
    private static final ThreadLocal<Direction> NOCLIP = ThreadLocal.withInitial(() -> null);
    private float progress = 0.0f;
    private float progressO = 0.0f;
    private long lastTicked;
    private int deathTicks;

    public PistonMovingBlockEntity(BlockPos p_155901_, BlockState p_155902_) {
        super(BlockEntityType.PISTON, p_155901_, p_155902_);
    }

    public PistonMovingBlockEntity(BlockPos p_155904_, BlockState p_155905_, BlockState p_155906_, Direction p_155907_, boolean p_155908_, boolean p_155909_) {
        this(p_155904_, p_155905_);
        this.movedState = p_155906_;
        this.direction = p_155907_;
        this.extending = p_155908_;
        this.isSourcePiston = p_155909_;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324521_) {
        return this.saveCustomOnly(p_324521_);
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float p_60351_) {
        if (p_60351_ > 1.0f) {
            p_60351_ = 1.0f;
        }
        return Mth.lerp(p_60351_, this.progressO, this.progress);
    }

    public float getXOff(float p_60381_) {
        return (float)this.direction.getStepX() * this.getExtendedProgress(this.getProgress(p_60381_));
    }

    public float getYOff(float p_60386_) {
        return (float)this.direction.getStepY() * this.getExtendedProgress(this.getProgress(p_60386_));
    }

    public float getZOff(float p_60389_) {
        return (float)this.direction.getStepZ() * this.getExtendedProgress(this.getProgress(p_60389_));
    }

    private float getExtendedProgress(float p_60391_) {
        return this.extending ? p_60391_ - 1.0f : 1.0f - p_60391_;
    }

    private BlockState getCollisionRelatedBlockState() {
        if (!this.isExtending() && this.isSourcePiston() && this.movedState.getBlock() instanceof PistonBaseBlock) {
            return (BlockState)((BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.SHORT, this.progress > 0.25f)).setValue(PistonHeadBlock.TYPE, this.movedState.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT)).setValue(PistonHeadBlock.FACING, (Direction)this.movedState.getValue(PistonBaseBlock.FACING));
        }
        return this.movedState;
    }

    private static void moveCollidedEntities(Level p_155911_, BlockPos p_155912_, float p_155913_, PistonMovingBlockEntity p_155914_) {
        Direction $$4 = p_155914_.getMovementDirection();
        double $$5 = p_155913_ - p_155914_.progress;
        VoxelShape $$6 = p_155914_.getCollisionRelatedBlockState().getCollisionShape(p_155911_, p_155912_);
        if ($$6.isEmpty()) {
            return;
        }
        AABB $$7 = PistonMovingBlockEntity.moveByPositionAndProgress(p_155912_, $$6.bounds(), p_155914_);
        List<Entity> $$8 = p_155911_.getEntities(null, PistonMath.getMovementArea($$7, $$4, $$5).minmax($$7));
        if ($$8.isEmpty()) {
            return;
        }
        List<AABB> $$9 = $$6.toAabbs();
        boolean $$10 = p_155914_.movedState.is(Blocks.SLIME_BLOCK);
        for (Entity $$11 : $$8) {
            AABB $$19;
            AABB $$17;
            AABB $$18;
            if ($$11.getPistonPushReaction() == PushReaction.IGNORE) continue;
            if ($$10) {
                if ($$11 instanceof ServerPlayer) continue;
                Vec3 $$12 = $$11.getDeltaMovement();
                double $$13 = $$12.x;
                double $$14 = $$12.y;
                double $$15 = $$12.z;
                switch ($$4.getAxis()) {
                    case X: {
                        $$13 = $$4.getStepX();
                        break;
                    }
                    case Y: {
                        $$14 = $$4.getStepY();
                        break;
                    }
                    case Z: {
                        $$15 = $$4.getStepZ();
                    }
                }
                $$11.setDeltaMovement($$13, $$14, $$15);
            }
            double $$16 = 0.0;
            Iterator<AABB> iterator = $$9.iterator();
            while (!(!iterator.hasNext() || ($$18 = PistonMath.getMovementArea(PistonMovingBlockEntity.moveByPositionAndProgress(p_155912_, $$17 = iterator.next(), p_155914_), $$4, $$5)).intersects($$19 = $$11.getBoundingBox()) && ($$16 = Math.max($$16, PistonMovingBlockEntity.getMovement($$18, $$4, $$19))) >= $$5)) {
            }
            if ($$16 <= 0.0) continue;
            $$16 = Math.min($$16, $$5) + 0.01;
            PistonMovingBlockEntity.moveEntityByPiston($$4, $$11, $$16, $$4);
            if (p_155914_.extending || !p_155914_.isSourcePiston) continue;
            PistonMovingBlockEntity.fixEntityWithinPistonBase(p_155912_, $$11, $$4, $$5);
        }
    }

    private static void moveEntityByPiston(Direction p_60372_, Entity p_60373_, double p_60374_, Direction p_60375_) {
        NOCLIP.set(p_60372_);
        Vec3 $$4 = p_60373_.position();
        p_60373_.move(MoverType.PISTON, new Vec3(p_60374_ * (double)p_60375_.getStepX(), p_60374_ * (double)p_60375_.getStepY(), p_60374_ * (double)p_60375_.getStepZ()));
        p_60373_.applyEffectsFromBlocks($$4, p_60373_.position());
        p_60373_.removeLatestMovementRecordingBatch();
        NOCLIP.set(null);
    }

    private static void moveStuckEntities(Level p_155932_, BlockPos p_155933_, float p_155934_, PistonMovingBlockEntity p_155935_) {
        if (!p_155935_.isStickyForEntities()) {
            return;
        }
        Direction $$4 = p_155935_.getMovementDirection();
        if (!$$4.getAxis().isHorizontal()) {
            return;
        }
        double $$5 = p_155935_.movedState.getCollisionShape(p_155932_, p_155933_).max(Direction.Axis.Y);
        AABB $$6 = PistonMovingBlockEntity.moveByPositionAndProgress(p_155933_, new AABB(0.0, $$5, 0.0, 1.0, 1.5000010000000001, 1.0), p_155935_);
        double $$7 = p_155934_ - p_155935_.progress;
        List<Entity> $$8 = p_155932_.getEntities((Entity)null, $$6, p_287552_ -> PistonMovingBlockEntity.matchesStickyCritera($$6, p_287552_, p_155933_));
        for (Entity $$9 : $$8) {
            PistonMovingBlockEntity.moveEntityByPiston($$4, $$9, $$7, $$4);
        }
    }

    private static boolean matchesStickyCritera(AABB p_287782_, Entity p_287720_, BlockPos p_287775_) {
        return p_287720_.getPistonPushReaction() == PushReaction.NORMAL && p_287720_.onGround() && (p_287720_.isSupportedBy(p_287775_) || p_287720_.getX() >= p_287782_.minX && p_287720_.getX() <= p_287782_.maxX && p_287720_.getZ() >= p_287782_.minZ && p_287720_.getZ() <= p_287782_.maxZ);
    }

    private boolean isStickyForEntities() {
        return this.movedState.is(Blocks.HONEY_BLOCK);
    }

    public Direction getMovementDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    private static double getMovement(AABB p_60368_, Direction p_60369_, AABB p_60370_) {
        switch (p_60369_) {
            case EAST: {
                return p_60368_.maxX - p_60370_.minX;
            }
            case WEST: {
                return p_60370_.maxX - p_60368_.minX;
            }
            default: {
                return p_60368_.maxY - p_60370_.minY;
            }
            case DOWN: {
                return p_60370_.maxY - p_60368_.minY;
            }
            case SOUTH: {
                return p_60368_.maxZ - p_60370_.minZ;
            }
            case NORTH: 
        }
        return p_60370_.maxZ - p_60368_.minZ;
    }

    private static AABB moveByPositionAndProgress(BlockPos p_155926_, AABB p_155927_, PistonMovingBlockEntity p_155928_) {
        double $$3 = p_155928_.getExtendedProgress(p_155928_.progress);
        return p_155927_.move((double)p_155926_.getX() + $$3 * (double)p_155928_.direction.getStepX(), (double)p_155926_.getY() + $$3 * (double)p_155928_.direction.getStepY(), (double)p_155926_.getZ() + $$3 * (double)p_155928_.direction.getStepZ());
    }

    private static void fixEntityWithinPistonBase(BlockPos p_155921_, Entity p_155922_, Direction p_155923_, double p_155924_) {
        double $$8;
        Direction $$6;
        double $$7;
        AABB $$5;
        AABB $$4 = p_155922_.getBoundingBox();
        if ($$4.intersects($$5 = Shapes.block().bounds().move(p_155921_)) && Math.abs(($$7 = PistonMovingBlockEntity.getMovement($$5, $$6 = p_155923_.getOpposite(), $$4) + 0.01) - ($$8 = PistonMovingBlockEntity.getMovement($$5, $$6, $$4.intersect($$5)) + 0.01)) < 0.01) {
            $$7 = Math.min($$7, p_155924_) + 0.01;
            PistonMovingBlockEntity.moveEntityByPiston(p_155923_, p_155922_, $$7, $$6);
        }
    }

    public BlockState getMovedState() {
        return this.movedState;
    }

    public void finalTick() {
        if (this.level != null && (this.progressO < 1.0f || this.level.isClientSide)) {
            this.progressO = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).is(Blocks.MOVING_PISTON)) {
                BlockState $$1;
                if (this.isSourcePiston) {
                    BlockState $$0 = Blocks.AIR.defaultBlockState();
                } else {
                    $$1 = Block.updateFromNeighbourShapes(this.movedState, this.level, this.worldPosition);
                }
                this.level.setBlock(this.worldPosition, $$1, 3);
                this.level.neighborChanged(this.worldPosition, $$1.getBlock(), ExperimentalRedstoneUtils.initialOrientation(this.level, this.getPushDirection(), null));
            }
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos p_394613_, BlockState p_393744_) {
        this.finalTick();
    }

    public Direction getPushDirection() {
        return this.extending ? this.direction : this.direction.getOpposite();
    }

    public static void tick(Level p_155916_, BlockPos p_155917_, BlockState p_155918_, PistonMovingBlockEntity p_155919_) {
        p_155919_.lastTicked = p_155916_.getGameTime();
        p_155919_.progressO = p_155919_.progress;
        if (p_155919_.progressO >= 1.0f) {
            if (p_155916_.isClientSide && p_155919_.deathTicks < 5) {
                ++p_155919_.deathTicks;
                return;
            }
            p_155916_.removeBlockEntity(p_155917_);
            p_155919_.setRemoved();
            if (p_155916_.getBlockState(p_155917_).is(Blocks.MOVING_PISTON)) {
                BlockState $$4 = Block.updateFromNeighbourShapes(p_155919_.movedState, p_155916_, p_155917_);
                if ($$4.isAir()) {
                    p_155916_.setBlock(p_155917_, p_155919_.movedState, 340);
                    Block.updateOrDestroy(p_155919_.movedState, $$4, p_155916_, p_155917_, 3);
                } else {
                    if ($$4.hasProperty(BlockStateProperties.WATERLOGGED) && $$4.getValue(BlockStateProperties.WATERLOGGED).booleanValue()) {
                        $$4 = (BlockState)$$4.setValue(BlockStateProperties.WATERLOGGED, false);
                    }
                    p_155916_.setBlock(p_155917_, $$4, 67);
                    p_155916_.neighborChanged(p_155917_, $$4.getBlock(), ExperimentalRedstoneUtils.initialOrientation(p_155916_, p_155919_.getPushDirection(), null));
                }
            }
            return;
        }
        float $$5 = p_155919_.progress + 0.5f;
        PistonMovingBlockEntity.moveCollidedEntities(p_155916_, p_155917_, $$5, p_155919_);
        PistonMovingBlockEntity.moveStuckEntities(p_155916_, p_155917_, $$5, p_155919_);
        p_155919_.progress = $$5;
        if (p_155919_.progress >= 1.0f) {
            p_155919_.progress = 1.0f;
        }
    }

    @Override
    protected void loadAdditional(CompoundTag p_155930_, HolderLookup.Provider p_324214_) {
        super.loadAdditional(p_155930_, p_324214_);
        RegistryOps<Tag> $$2 = p_324214_.createSerializationContext(NbtOps.INSTANCE);
        this.movedState = p_155930_.read("blockState", BlockState.CODEC, $$2).orElse(DEFAULT_BLOCK_STATE);
        this.direction = p_155930_.read("facing", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN);
        this.progressO = this.progress = p_155930_.getFloatOr("progress", 0.0f);
        this.extending = p_155930_.getBooleanOr("extending", false);
        this.isSourcePiston = p_155930_.getBooleanOr("source", false);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187530_, HolderLookup.Provider p_323923_) {
        super.saveAdditional(p_187530_, p_323923_);
        RegistryOps<Tag> $$2 = p_323923_.createSerializationContext(NbtOps.INSTANCE);
        p_187530_.store("blockState", BlockState.CODEC, $$2, this.movedState);
        p_187530_.store("facing", Direction.LEGACY_ID_CODEC, this.direction);
        p_187530_.putFloat("progress", this.progressO);
        p_187530_.putBoolean("extending", this.extending);
        p_187530_.putBoolean("source", this.isSourcePiston);
    }

    public VoxelShape getCollisionShape(BlockGetter p_60357_, BlockPos p_60358_) {
        BlockState $$6;
        VoxelShape $$3;
        if (!this.extending && this.isSourcePiston && this.movedState.getBlock() instanceof PistonBaseBlock) {
            VoxelShape $$2 = ((BlockState)this.movedState.setValue(PistonBaseBlock.EXTENDED, true)).getCollisionShape(p_60357_, p_60358_);
        } else {
            $$3 = Shapes.empty();
        }
        Direction $$4 = NOCLIP.get();
        if ((double)this.progress < 1.0 && $$4 == this.getMovementDirection()) {
            return $$3;
        }
        if (this.isSourcePiston()) {
            BlockState $$5 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.FACING, this.direction)).setValue(PistonHeadBlock.SHORT, this.extending != 1.0f - this.progress < 0.25f);
        } else {
            $$6 = this.movedState;
        }
        float $$7 = this.getExtendedProgress(this.progress);
        double $$8 = (float)this.direction.getStepX() * $$7;
        double $$9 = (float)this.direction.getStepY() * $$7;
        double $$10 = (float)this.direction.getStepZ() * $$7;
        return Shapes.or($$3, $$6.getCollisionShape(p_60357_, p_60358_).move($$8, $$9, $$10));
    }

    public long getLastTicked() {
        return this.lastTicked;
    }

    @Override
    public void setLevel(Level p_250671_) {
        super.setLevel(p_250671_);
        if (p_250671_.holderLookup(Registries.BLOCK).get(this.movedState.getBlock().builtInRegistryHolder().key()).isEmpty()) {
            this.movedState = Blocks.AIR.defaultBlockState();
        }
    }
}

