/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.sounds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 1600;
    private static final int WIND_SOUND_CHANCE = 10000;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_CHECK = 8;

    public static void playAmbientBlockSounds(BlockState p_401053_, Level p_401223_, BlockPos p_401396_, RandomSource p_401144_) {
        if (!p_401053_.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) || !p_401223_.canSeeSky(p_401396_.above())) {
            return;
        }
        if (p_401144_.nextInt(1600) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(p_401223_, p_401396_)) {
            p_401223_.playLocalSound(p_401396_.getX(), p_401396_.getY(), p_401396_.getZ(), SoundEvents.SAND_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        if (p_401144_.nextInt(10000) == 0 && AmbientDesertBlockSoundsPlayer.isInAmbientSoundBiome(p_401223_.getBiome(p_401396_)) && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSound(p_401223_, p_401396_)) {
            p_401223_.playPlayerSound(SoundEvents.SAND_WIND, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private static boolean isInAmbientSoundBiome(Holder<Biome> p_401313_) {
        return p_401313_.is(Biomes.DESERT) || p_401313_.is(BiomeTags.IS_BADLANDS);
    }

    private static boolean shouldPlayAmbientSound(Level p_401188_, BlockPos p_401265_) {
        int $$2 = 0;
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockPos $$4 = p_401265_.relative($$3, 8);
            BlockState $$5 = p_401188_.getBlockState($$4.atY(p_401188_.getHeight(Heightmap.Types.WORLD_SURFACE, $$4) - 1));
            if (!$$5.is(BlockTags.PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS) || ++$$2 < 3) continue;
            return true;
        }
        return false;
    }
}

