/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class StateHolder<O, S> {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> p_61155_) {
            if (p_61155_ == null) {
                return "<NULL>";
            }
            Property<?> $$1 = p_61155_.getKey();
            return $$1.getName() + "=" + this.getName($$1, p_61155_.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> p_61152_, Comparable<?> p_61153_) {
            return p_61152_.getName(p_61153_);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O owner;
    private final Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    private Map<Property<?>, S[]> neighbours;
    protected final MapCodec<S> propertiesCodec;

    protected StateHolder(O p_61117_, Reference2ObjectArrayMap<Property<?>, Comparable<?>> p_326342_, MapCodec<S> p_61119_) {
        this.owner = p_61117_;
        this.values = p_326342_;
        this.propertiesCodec = p_61119_;
    }

    public <T extends Comparable<T>> S cycle(Property<T> p_61123_) {
        return this.setValue(p_61123_, (Comparable)StateHolder.findNextInCollection(p_61123_.getPossibleValues(), this.getValue(p_61123_)));
    }

    protected static <T> T findNextInCollection(List<T> p_373062_, T p_61132_) {
        int $$2 = p_373062_.indexOf(p_61132_) + 1;
        return $$2 == p_373062_.size() ? p_373062_.getFirst() : p_373062_.get($$2);
    }

    public String toString() {
        StringBuilder $$0 = new StringBuilder();
        $$0.append(this.owner);
        if (!this.getValues().isEmpty()) {
            $$0.append('[');
            $$0.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            $$0.append(']');
        }
        return $$0.toString();
    }

    public final boolean equals(Object p_394267_) {
        return super.equals(p_394267_);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    public boolean hasProperty(Property<?> p_61139_) {
        return this.values.containsKey(p_61139_);
    }

    public <T extends Comparable<T>> T getValue(Property<T> p_61144_) {
        Comparable $$1 = (Comparable)this.values.get(p_61144_);
        if ($$1 == null) {
            throw new IllegalArgumentException("Cannot get property " + String.valueOf(p_61144_) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return (T)((Comparable)p_61144_.getValueClass().cast($$1));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> p_61146_) {
        return Optional.ofNullable(this.getNullableValue(p_61146_));
    }

    public <T extends Comparable<T>> T getValueOrElse(Property<T> p_363461_, T p_362474_) {
        return (T)((Comparable)Objects.requireNonNullElse(this.getNullableValue(p_363461_), p_362474_));
    }

    @Nullable
    private <T extends Comparable<T>> T getNullableValue(Property<T> p_360378_) {
        Comparable $$1 = (Comparable)this.values.get(p_360378_);
        if ($$1 == null) {
            return null;
        }
        return (T)((Comparable)p_360378_.getValueClass().cast($$1));
    }

    public <T extends Comparable<T>, V extends T> S setValue(Property<T> p_61125_, V p_61126_) {
        Comparable $$2 = (Comparable)this.values.get(p_61125_);
        if ($$2 == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(p_61125_) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return this.setValueInternal(p_61125_, p_61126_, $$2);
    }

    public <T extends Comparable<T>, V extends T> S trySetValue(Property<T> p_263324_, V p_263334_) {
        Comparable $$2 = (Comparable)this.values.get(p_263324_);
        if ($$2 == null) {
            return (S)this;
        }
        return this.setValueInternal(p_263324_, p_263334_, $$2);
    }

    private <T extends Comparable<T>, V extends T> S setValueInternal(Property<T> p_372896_, V p_372842_, Comparable<?> p_372921_) {
        if (p_372921_.equals(p_372842_)) {
            return (S)this;
        }
        int $$3 = p_372896_.getInternalIndex(p_372842_);
        if ($$3 < 0) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(p_372896_) + " to " + String.valueOf(p_372842_) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return this.neighbours.get(p_372896_)[$$3];
    }

    public void populateNeighbours(Map<Map<Property<?>, Comparable<?>>, S> p_61134_) {
        if (this.neighbours != null) {
            throw new IllegalStateException();
        }
        Reference2ObjectArrayMap $$1 = new Reference2ObjectArrayMap(this.values.size());
        for (Map.Entry $$2 : this.values.entrySet()) {
            Property $$3 = (Property)$$2.getKey();
            $$1.put($$3, $$3.getPossibleValues().stream().map(p_372787_ -> p_61134_.get(this.makeNeighbourValues($$3, (Comparable<?>)p_372787_))).toArray());
        }
        this.neighbours = $$1;
    }

    private Map<Property<?>, Comparable<?>> makeNeighbourValues(Property<?> p_61141_, Comparable<?> p_61142_) {
        Reference2ObjectArrayMap $$2 = new Reference2ObjectArrayMap(this.values);
        $$2.put(p_61141_, p_61142_);
        return $$2;
    }

    public Map<Property<?>, Comparable<?>> getValues() {
        return this.values;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> p_61128_, Function<O, S> p_61129_) {
        return p_61128_.dispatch(NAME_TAG, p_61121_ -> p_61121_.owner, p_338076_ -> {
            StateHolder $$2 = (StateHolder)p_61129_.apply(p_338076_);
            if ($$2.getValues().isEmpty()) {
                return MapCodec.unit((Object)$$2);
            }
            return $$2.propertiesCodec.codec().lenientOptionalFieldOf(PROPERTIES_TAG).xmap(p_187544_ -> p_187544_.orElse($$2), Optional::of);
        });
    }
}

