/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R, P>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final SimpleRegionStorage simpleRegionStorage;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirtyChunks = new LongLinkedOpenHashSet();
    private final Codec<P> codec;
    private final Function<R, P> packer;
    private final BiFunction<P, Runnable, R> unpacker;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    private final ChunkIOErrorReporter errorReporter;
    protected final LevelHeightAccessor levelHeightAccessor;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<PackedChunk<P>>>> pendingLoads = new Long2ObjectOpenHashMap();
    private final Object loadLock = new Object();

    public SectionStorage(SimpleRegionStorage p_321814_, Codec<P> p_363117_, Function<R, P> p_223510_, BiFunction<P, Runnable, R> p_360520_, Function<Runnable, R> p_223511_, RegistryAccess p_223515_, ChunkIOErrorReporter p_352357_, LevelHeightAccessor p_223516_) {
        this.simpleRegionStorage = p_321814_;
        this.codec = p_363117_;
        this.packer = p_223510_;
        this.unpacker = p_360520_;
        this.factory = p_223511_;
        this.registryAccess = p_223515_;
        this.errorReporter = p_352357_;
        this.levelHeightAccessor = p_223516_;
    }

    protected void tick(BooleanSupplier p_63812_) {
        LongListIterator $$1 = this.dirtyChunks.iterator();
        while ($$1.hasNext() && p_63812_.getAsBoolean()) {
            ChunkPos $$2 = new ChunkPos($$1.nextLong());
            $$1.remove();
            this.writeChunk($$2);
        }
        this.unpackPendingLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPendingLoads() {
        Object object = this.loadLock;
        synchronized (object) {
            ObjectIterator $$0 = Long2ObjectMaps.fastIterator(this.pendingLoads);
            while ($$0.hasNext()) {
                Long2ObjectMap.Entry $$1 = (Long2ObjectMap.Entry)$$0.next();
                Optional $$2 = ((CompletableFuture)$$1.getValue()).getNow(null);
                if ($$2 == null) continue;
                long $$3 = $$1.getLongKey();
                this.unpackChunk(new ChunkPos($$3), $$2.orElse(null));
                $$0.remove();
                this.loadedChunks.add($$3);
            }
        }
    }

    public void flushAll() {
        if (!this.dirtyChunks.isEmpty()) {
            this.dirtyChunks.forEach(p_360211_ -> this.writeChunk(new ChunkPos(p_360211_)));
            this.dirtyChunks.clear();
        }
    }

    public boolean hasWork() {
        return !this.dirtyChunks.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long p_63819_) {
        return (Optional)this.storage.get(p_63819_);
    }

    protected Optional<R> getOrLoad(long p_63824_) {
        if (this.outsideStoredRange(p_63824_)) {
            return Optional.empty();
        }
        Optional<R> $$1 = this.get(p_63824_);
        if ($$1 != null) {
            return $$1;
        }
        this.unpackChunk(SectionPos.of(p_63824_).chunk());
        $$1 = this.get(p_63824_);
        if ($$1 == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return $$1;
    }

    protected boolean outsideStoredRange(long p_156631_) {
        int $$1 = SectionPos.sectionToBlockCoord(SectionPos.y(p_156631_));
        return this.levelHeightAccessor.isOutsideBuildHeight($$1);
    }

    protected R getOrCreate(long p_63828_) {
        if (this.outsideStoredRange(p_63828_)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> $$1 = this.getOrLoad(p_63828_);
        if ($$1.isPresent()) {
            return $$1.get();
        }
        R $$2 = this.factory.apply(() -> this.setDirty(p_63828_));
        this.storage.put(p_63828_, Optional.of($$2));
        return $$2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> prefetch(ChunkPos p_364373_) {
        Object object = this.loadLock;
        synchronized (object) {
            long $$1 = p_364373_.toLong();
            if (this.loadedChunks.contains($$1)) {
                return CompletableFuture.completedFuture(null);
            }
            return (CompletableFuture)this.pendingLoads.computeIfAbsent($$1, p_360206_ -> this.tryRead(p_364373_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void unpackChunk(ChunkPos p_365521_) {
        void $$3;
        long $$1 = p_365521_.toLong();
        Object object = this.loadLock;
        synchronized (object) {
            if (!this.loadedChunks.add($$1)) {
                return;
            }
            CompletableFuture $$2 = (CompletableFuture)this.pendingLoads.computeIfAbsent($$1, p_360213_ -> this.tryRead(p_365521_));
        }
        this.unpackChunk(p_365521_, ((Optional)$$3.join()).orElse(null));
        object = this.loadLock;
        synchronized (object) {
            this.pendingLoads.remove($$1);
        }
    }

    private CompletableFuture<Optional<PackedChunk<P>>> tryRead(ChunkPos p_223533_) {
        RegistryOps<Tag> $$1 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        return ((CompletableFuture)this.simpleRegionStorage.read(p_223533_).thenApplyAsync(p_360208_ -> p_360208_.map(p_360215_ -> PackedChunk.parse(this.codec, $$1, p_360215_, this.simpleRegionStorage, this.levelHeightAccessor)), Util.backgroundExecutor().forName("parseSection"))).exceptionally(p_382775_ -> {
            if (p_382775_ instanceof CompletionException) {
                p_382775_ = p_382775_.getCause();
            }
            if (p_382775_ instanceof IOException) {
                IOException $$2 = (IOException)p_382775_;
                LOGGER.error("Error reading chunk {} data from disk", (Object)p_223533_, (Object)$$2);
                this.errorReporter.reportChunkLoadFailure($$2, this.simpleRegionStorage.storageInfo(), p_223533_);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)p_382775_);
        });
    }

    private void unpackChunk(ChunkPos p_365130_, @Nullable PackedChunk<P> p_361845_) {
        if (p_361845_ == null) {
            for (int $$2 = this.levelHeightAccessor.getMinSectionY(); $$2 <= this.levelHeightAccessor.getMaxSectionY(); ++$$2) {
                this.storage.put(SectionStorage.getKey(p_365130_, $$2), Optional.empty());
            }
        } else {
            boolean $$3 = p_361845_.versionChanged();
            for (int $$4 = this.levelHeightAccessor.getMinSectionY(); $$4 <= this.levelHeightAccessor.getMaxSectionY(); ++$$4) {
                long $$5 = SectionStorage.getKey(p_365130_, $$4);
                Optional<Object> $$6 = Optional.ofNullable(p_361845_.sectionsByY.get($$4)).map(p_360210_ -> this.unpacker.apply(p_360210_, () -> this.setDirty($$5)));
                this.storage.put($$5, $$6);
                $$6.ifPresent(p_223523_ -> {
                    this.onSectionLoad($$5);
                    if ($$3) {
                        this.setDirty($$5);
                    }
                });
            }
        }
    }

    private void writeChunk(ChunkPos p_361540_) {
        RegistryOps<Tag> $$1 = this.registryAccess.createSerializationContext(NbtOps.INSTANCE);
        Dynamic<Tag> $$2 = this.writeChunk(p_361540_, $$1);
        Tag $$3 = (Tag)$$2.getValue();
        if ($$3 instanceof CompoundTag) {
            this.simpleRegionStorage.write(p_361540_, (CompoundTag)$$3).exceptionally(p_351992_ -> {
                this.errorReporter.reportChunkSaveFailure((Throwable)p_351992_, this.simpleRegionStorage.storageInfo(), p_361540_);
                return null;
            });
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)$$3);
        }
    }

    private <T> Dynamic<T> writeChunk(ChunkPos p_362535_, DynamicOps<T> p_360921_) {
        HashMap $$2 = Maps.newHashMap();
        for (int $$3 = this.levelHeightAccessor.getMinSectionY(); $$3 <= this.levelHeightAccessor.getMaxSectionY(); ++$$3) {
            long $$4 = SectionStorage.getKey(p_362535_, $$3);
            Optional $$5 = (Optional)this.storage.get($$4);
            if ($$5 == null || $$5.isEmpty()) continue;
            DataResult $$6 = this.codec.encodeStart(p_360921_, this.packer.apply($$5.get()));
            String $$7 = Integer.toString($$3);
            $$6.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_223531_ -> $$2.put(p_360921_.createString($$7), p_223531_));
        }
        return new Dynamic(p_360921_, p_360921_.createMap((Map)ImmutableMap.of((Object)p_360921_.createString(SECTIONS_TAG), (Object)p_360921_.createMap((Map)$$2), (Object)p_360921_.createString("DataVersion"), (Object)p_360921_.createInt(SharedConstants.getCurrentVersion().getDataVersion().getVersion()))));
    }

    private static long getKey(ChunkPos p_156628_, int p_156629_) {
        return SectionPos.asLong(p_156628_.x, p_156629_, p_156628_.z);
    }

    protected void onSectionLoad(long p_63813_) {
    }

    protected void setDirty(long p_63788_) {
        Optional $$1 = (Optional)this.storage.get(p_63788_);
        if ($$1 == null || $$1.isEmpty()) {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of(p_63788_));
            return;
        }
        this.dirtyChunks.add(ChunkPos.asLong(SectionPos.x(p_63788_), SectionPos.z(p_63788_)));
    }

    static int getVersion(Dynamic<?> p_63806_) {
        return p_63806_.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkPos p_63797_) {
        if (this.dirtyChunks.remove(p_63797_.toLong())) {
            this.writeChunk(p_63797_);
        }
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }

    record PackedChunk<T>(Int2ObjectMap<T> sectionsByY, boolean versionChanged) {
        public static <T> PackedChunk<T> parse(Codec<T> p_365233_, DynamicOps<Tag> p_363840_, Tag p_364375_, SimpleRegionStorage p_362076_, LevelHeightAccessor p_362314_) {
            int $$7;
            Dynamic $$5 = new Dynamic(p_363840_, (Object)p_364375_);
            int $$6 = SectionStorage.getVersion($$5);
            boolean $$8 = $$6 != ($$7 = SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            Dynamic<Tag> $$9 = p_362076_.upgradeChunkTag((Dynamic<Tag>)$$5, $$6);
            OptionalDynamic $$10 = $$9.get(SectionStorage.SECTIONS_TAG);
            Int2ObjectOpenHashMap $$11 = new Int2ObjectOpenHashMap();
            for (int $$12 = p_362314_.getMinSectionY(); $$12 <= p_362314_.getMaxSectionY(); ++$$12) {
                Optional $$13 = $$10.get(Integer.toString($$12)).result().flatMap(p_361362_ -> p_365233_.parse(p_361362_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                if (!$$13.isPresent()) continue;
                $$11.put($$12, $$13.get());
            }
            return new PackedChunk<T>($$11, $$8);
        }
    }
}

