/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;

public class EntitySectionStorage<T extends EntityAccess> {
    public static final int CHONKY_ENTITY_SEARCH_GRACE = 2;
    public static final int MAX_NON_CHONKY_ENTITY_SIZE = 4;
    private final Class<T> entityClass;
    private final Long2ObjectFunction<Visibility> intialSectionVisibility;
    private final Long2ObjectMap<EntitySection<T>> sections = new Long2ObjectOpenHashMap();
    private final LongSortedSet sectionIds = new LongAVLTreeSet();

    public EntitySectionStorage(Class<T> p_156855_, Long2ObjectFunction<Visibility> p_156856_) {
        this.entityClass = p_156855_;
        this.intialSectionVisibility = p_156856_;
    }

    public void forEachAccessibleNonEmptySection(AABB p_188363_, AbortableIterationConsumer<EntitySection<T>> p_261588_) {
        int $$2 = SectionPos.posToSectionCoord(p_188363_.minX - 2.0);
        int $$3 = SectionPos.posToSectionCoord(p_188363_.minY - 4.0);
        int $$4 = SectionPos.posToSectionCoord(p_188363_.minZ - 2.0);
        int $$5 = SectionPos.posToSectionCoord(p_188363_.maxX + 2.0);
        int $$6 = SectionPos.posToSectionCoord(p_188363_.maxY + 0.0);
        int $$7 = SectionPos.posToSectionCoord(p_188363_.maxZ + 2.0);
        for (int $$8 = $$2; $$8 <= $$5; ++$$8) {
            long $$9 = SectionPos.asLong($$8, 0, 0);
            long $$10 = SectionPos.asLong($$8, -1, -1);
            LongBidirectionalIterator $$11 = this.sectionIds.subSet($$9, $$10 + 1L).iterator();
            while ($$11.hasNext()) {
                EntitySection $$15;
                long $$12 = $$11.nextLong();
                int $$13 = SectionPos.y($$12);
                int $$14 = SectionPos.z($$12);
                if ($$13 < $$3 || $$13 > $$6 || $$14 < $$4 || $$14 > $$7 || ($$15 = (EntitySection)this.sections.get($$12)) == null || $$15.isEmpty() || !$$15.getStatus().isAccessible() || !p_261588_.accept($$15).shouldAbort()) continue;
                return;
            }
        }
    }

    public LongStream getExistingSectionPositionsInChunk(long p_156862_) {
        int $$2;
        int $$1 = ChunkPos.getX(p_156862_);
        LongSortedSet $$3 = this.getChunkSections($$1, $$2 = ChunkPos.getZ(p_156862_));
        if ($$3.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator $$4 = $$3.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)$$4, 1301), false);
    }

    private LongSortedSet getChunkSections(int p_156859_, int p_156860_) {
        long $$2 = SectionPos.asLong(p_156859_, 0, p_156860_);
        long $$3 = SectionPos.asLong(p_156859_, -1, p_156860_);
        return this.sectionIds.subSet($$2, $$3 + 1L);
    }

    public Stream<EntitySection<T>> getExistingSectionsInChunk(long p_156889_) {
        return this.getExistingSectionPositionsInChunk(p_156889_).mapToObj(arg_0 -> this.sections.get(arg_0)).filter(Objects::nonNull);
    }

    private static long getChunkKeyFromSectionKey(long p_156900_) {
        return ChunkPos.asLong(SectionPos.x(p_156900_), SectionPos.z(p_156900_));
    }

    public EntitySection<T> getOrCreateSection(long p_156894_) {
        return (EntitySection)this.sections.computeIfAbsent(p_156894_, this::createSection);
    }

    @Nullable
    public EntitySection<T> getSection(long p_156896_) {
        return (EntitySection)this.sections.get(p_156896_);
    }

    private EntitySection<T> createSection(long p_156902_) {
        long $$1 = EntitySectionStorage.getChunkKeyFromSectionKey(p_156902_);
        Visibility $$2 = (Visibility)((Object)this.intialSectionVisibility.get($$1));
        this.sectionIds.add(p_156902_);
        return new EntitySection<T>(this.entityClass, $$2);
    }

    public LongSet getAllChunksWithExistingSections() {
        LongOpenHashSet $$0 = new LongOpenHashSet();
        this.sections.keySet().forEach(arg_0 -> EntitySectionStorage.lambda$getAllChunksWithExistingSections$0((LongSet)$$0, arg_0));
        return $$0;
    }

    public void getEntities(AABB p_261820_, AbortableIterationConsumer<T> p_261992_) {
        this.forEachAccessibleNonEmptySection(p_261820_, p_261459_ -> p_261459_.getEntities(p_261820_, p_261992_));
    }

    public <U extends T> void getEntities(EntityTypeTest<T, U> p_261630_, AABB p_261843_, AbortableIterationConsumer<U> p_261742_) {
        this.forEachAccessibleNonEmptySection(p_261843_, p_261463_ -> p_261463_.getEntities(p_261630_, p_261843_, p_261742_));
    }

    public void remove(long p_156898_) {
        this.sections.remove(p_156898_);
        this.sectionIds.remove(p_156898_);
    }

    @VisibleForDebug
    public int count() {
        return this.sectionIds.size();
    }

    private static /* synthetic */ void lambda$getAllChunksWithExistingSections$0(LongSet p_156885_, long p_156886_) {
        p_156885_.add(EntitySectionStorage.getChunkKeyFromSectionKey(p_156886_));
    }
}

